package models

// DeleteCommentsJob requests deletion of the comments specified
type DeleteCommentsJob struct {
	AuthenticatedUserID string   `json:"authenticated_user_id"`
	CommentIDs          []string `json:"comment_ids"`
}

// PurgeCommenterJob requests deletion of all comments by a particular commenter on a channel (is specified)
type PurgeCommenterJob struct {
	AuthenticatedUserID string  `json:"authenticated_user_id"`
	ChannelID           *string `json:"channel_id,omitempty"`
	CommenterID         string  `json:"commenter_id"`
}
