package models

import "time"

const (
	// CommentNotificationTypeCreated indicates that a new comment was created
	CommentNotificationTypeCreated = "comment-created"
	// CommentNotificationTypePublished indicates that a comment was published (for the first time)
	CommentNotificationTypePublished = "comment-published"
)

// CommentNotification holds data about a comment that experienced a state change
type CommentNotification struct {
	CommentID     string          `json:"comment_id"`
	ParentID      *string         `json:"parent_id"`
	ChannelID     string          `json:"channel_id"`
	CommenterID   string          `json:"commenter_id"`
	ContentObject *ContentObject  `json:"content"`
	ContentOffset *ContentOffset  `json:"content_offset"`
	CreatedAt     time.Time       `json:"created_at"`
	UpdatedAt     time.Time       `json:"updated_at"`
	PublishedAt   *time.Time      `json:"published_at,omitempty"`
	Message       *CommentMessage `json:"message"`
	State         CommentState    `json:"state"`
}
