// Code generated by protoc-gen-go. DO NOT EDIT.
// source: requests.proto

package vodapi

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/wrappers"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type CreateUploadRequest struct {
	// broadcast_type is the broadcast type of the vod
	BroadcastType VodType `protobuf:"varint,1,opt,name=broadcast_type,json=broadcastType,enum=vodapi.VodType" json:"broadcast_type,omitempty"`
	// broadcast_id is the id related to the broadcast of the vod
	BroadcastId string `protobuf:"bytes,2,opt,name=broadcast_id,json=broadcastId" json:"broadcast_id,omitempty"`
	// owner_id is the owner of the vod
	OwnerId string `protobuf:"bytes,3,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	// description is a user provided description of the vod
	Description string `protobuf:"bytes,4,opt,name=description" json:"description,omitempty"`
	// title is the vod title that shows up in directory listings
	Title string `protobuf:"bytes,5,opt,name=title" json:"title,omitempty"`
	// game is the game for the vod
	Game string `protobuf:"bytes,6,opt,name=game" json:"game,omitempty"`
	// communities is what communities the vod is related to
	Communities []string `protobuf:"bytes,7,rep,name=communities" json:"communities,omitempty"`
	// language is the language of the vod
	Language string `protobuf:"bytes,8,opt,name=language" json:"language,omitempty"`
	// tag_list is a list of tag descriptors of the vod
	TagList []string `protobuf:"bytes,9,rep,name=tag_list,json=tagList" json:"tag_list,omitempty"`
	// viewable is the viewability configuration for the vod
	Viewable VodViewable `protobuf:"varint,10,opt,name=viewable,enum=vodapi.VodViewable" json:"viewable,omitempty"`
	// viewable_at is when the vod became publicly viewable
	ViewableAt *google_protobuf1.Timestamp `protobuf:"bytes,11,opt,name=viewable_at,json=viewableAt" json:"viewable_at,omitempty"`
	// duration is the duration of the vod
	Duration int64 `protobuf:"varint,12,opt,name=duration" json:"duration,omitempty"`
	// uri is the path to the raw archive data
	Uri string `protobuf:"bytes,13,opt,name=uri" json:"uri,omitempty"`
	// manifest is the file describing the different ts chunks
	Manifest string `protobuf:"bytes,14,opt,name=manifest" json:"manifest,omitempty"`
}

func (m *CreateUploadRequest) Reset()                    { *m = CreateUploadRequest{} }
func (m *CreateUploadRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateUploadRequest) ProtoMessage()               {}
func (*CreateUploadRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *CreateUploadRequest) GetBroadcastType() VodType {
	if m != nil {
		return m.BroadcastType
	}
	return VodType_INVALID_TYPE
}

func (m *CreateUploadRequest) GetBroadcastId() string {
	if m != nil {
		return m.BroadcastId
	}
	return ""
}

func (m *CreateUploadRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CreateUploadRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateUploadRequest) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *CreateUploadRequest) GetGame() string {
	if m != nil {
		return m.Game
	}
	return ""
}

func (m *CreateUploadRequest) GetCommunities() []string {
	if m != nil {
		return m.Communities
	}
	return nil
}

func (m *CreateUploadRequest) GetLanguage() string {
	if m != nil {
		return m.Language
	}
	return ""
}

func (m *CreateUploadRequest) GetTagList() []string {
	if m != nil {
		return m.TagList
	}
	return nil
}

func (m *CreateUploadRequest) GetViewable() VodViewable {
	if m != nil {
		return m.Viewable
	}
	return VodViewable_INVALID_VIEWABLE
}

func (m *CreateUploadRequest) GetViewableAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.ViewableAt
	}
	return nil
}

func (m *CreateUploadRequest) GetDuration() int64 {
	if m != nil {
		return m.Duration
	}
	return 0
}

func (m *CreateUploadRequest) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *CreateUploadRequest) GetManifest() string {
	if m != nil {
		return m.Manifest
	}
	return ""
}

type ShowFormatRequest struct {
	// playlist_preference is an index into the formats for order to play the formats
	PlaylistPreference int64 `protobuf:"varint,1,opt,name=playlist_preference,json=playlistPreference" json:"playlist_preference,omitempty"`
	// display_name is the display name of the format
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// bitrate is the bitrate of the format
	Bitrate int64 `protobuf:"varint,3,opt,name=bitrate" json:"bitrate,omitempty"`
	// fps is the frames per second of the format
	Fps float64 `protobuf:"fixed64,4,opt,name=fps" json:"fps,omitempty"`
	// max_idr_interval is the max idr interval for the format
	MaxIdrInterval int64 `protobuf:"varint,5,opt,name=max_idr_interval,json=maxIdrInterval" json:"max_idr_interval,omitempty"`
	// codecs is the list of codecs related to this format
	Codecs string `protobuf:"bytes,6,opt,name=codecs" json:"codecs,omitempty"`
	// resolution is the resolution of the format
	Resolution string `protobuf:"bytes,7,opt,name=resolution" json:"resolution,omitempty"`
}

func (m *ShowFormatRequest) Reset()                    { *m = ShowFormatRequest{} }
func (m *ShowFormatRequest) String() string            { return proto.CompactTextString(m) }
func (*ShowFormatRequest) ProtoMessage()               {}
func (*ShowFormatRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *ShowFormatRequest) GetPlaylistPreference() int64 {
	if m != nil {
		return m.PlaylistPreference
	}
	return 0
}

func (m *ShowFormatRequest) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *ShowFormatRequest) GetBitrate() int64 {
	if m != nil {
		return m.Bitrate
	}
	return 0
}

func (m *ShowFormatRequest) GetFps() float64 {
	if m != nil {
		return m.Fps
	}
	return 0
}

func (m *ShowFormatRequest) GetMaxIdrInterval() int64 {
	if m != nil {
		return m.MaxIdrInterval
	}
	return 0
}

func (m *ShowFormatRequest) GetCodecs() string {
	if m != nil {
		return m.Codecs
	}
	return ""
}

func (m *ShowFormatRequest) GetResolution() string {
	if m != nil {
		return m.Resolution
	}
	return ""
}

type CreateArchiveRequest struct {
	// broadcast_id is the id related to the broadcast of the vod
	BroadcastId string `protobuf:"bytes,1,opt,name=broadcast_id,json=broadcastId" json:"broadcast_id,omitempty"`
	// broadcaster_software is what software was used to broadcast the archive
	BroadcasterSoftware string `protobuf:"bytes,2,opt,name=broadcaster_software,json=broadcasterSoftware" json:"broadcaster_software,omitempty"`
	// recorded_on is when the archive became recorded
	RecordedOn *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=recorded_on,json=recordedOn" json:"recorded_on,omitempty"`
	// title is the title of the archive
	Title string `protobuf:"bytes,4,opt,name=title" json:"title,omitempty"`
	// channel_id is the channel creating the archive
	ChannelId string `protobuf:"bytes,5,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// duration is the duration of the vod
	Duration int64 `protobuf:"varint,7,opt,name=duration" json:"duration,omitempty"`
	// uri is the path to the raw archive data
	Uri string `protobuf:"bytes,8,opt,name=uri" json:"uri,omitempty"`
	// manifest is the file describing the different ts chunks
	Manifest string `protobuf:"bytes,9,opt,name=manifest" json:"manifest,omitempty"`
	// deleted is whether the vod is deleted
	Deleted bool `protobuf:"varint,10,opt,name=deleted" json:"deleted,omitempty"`
	// handwave_latency_ms is the handwave latency milliseconds
	HandwaveLatencyMs int64 `protobuf:"varint,11,opt,name=handwave_latency_ms,json=handwaveLatencyMs" json:"handwave_latency_ms,omitempty"`
}

func (m *CreateArchiveRequest) Reset()                    { *m = CreateArchiveRequest{} }
func (m *CreateArchiveRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateArchiveRequest) ProtoMessage()               {}
func (*CreateArchiveRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *CreateArchiveRequest) GetBroadcastId() string {
	if m != nil {
		return m.BroadcastId
	}
	return ""
}

func (m *CreateArchiveRequest) GetBroadcasterSoftware() string {
	if m != nil {
		return m.BroadcasterSoftware
	}
	return ""
}

func (m *CreateArchiveRequest) GetRecordedOn() *google_protobuf1.Timestamp {
	if m != nil {
		return m.RecordedOn
	}
	return nil
}

func (m *CreateArchiveRequest) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *CreateArchiveRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *CreateArchiveRequest) GetDuration() int64 {
	if m != nil {
		return m.Duration
	}
	return 0
}

func (m *CreateArchiveRequest) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *CreateArchiveRequest) GetManifest() string {
	if m != nil {
		return m.Manifest
	}
	return ""
}

func (m *CreateArchiveRequest) GetDeleted() bool {
	if m != nil {
		return m.Deleted
	}
	return false
}

func (m *CreateArchiveRequest) GetHandwaveLatencyMs() int64 {
	if m != nil {
		return m.HandwaveLatencyMs
	}
	return 0
}

type InternalCreateHighlightRequest struct {
	// source_archive_id is the id of the original source vod
	SourceArchiveId string `protobuf:"bytes,1,opt,name=source_archive_id,json=sourceArchiveId" json:"source_archive_id,omitempty"`
	// owner_id is the owner of the vod
	OwnerId string `protobuf:"bytes,2,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	// uri is the path to the raw data
	Uri string `protobuf:"bytes,3,opt,name=uri" json:"uri,omitempty"`
	// broadcast_id is the id related to the broadcast of the vod
	BroadcastId string `protobuf:"bytes,4,opt,name=broadcast_id,json=broadcastId" json:"broadcast_id,omitempty"`
	// show_formats is the new show_formats value for the vod
	ShowFormats map[string]*ShowFormatRequest `protobuf:"bytes,5,rep,name=show_formats,json=showFormats" json:"show_formats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// title is the title for the highlight
	Title string `protobuf:"bytes,6,opt,name=title" json:"title,omitempty"`
	// duration is the duration of the vod
	Duration int64 `protobuf:"varint,7,opt,name=duration" json:"duration,omitempty"`
}

func (m *InternalCreateHighlightRequest) Reset()                    { *m = InternalCreateHighlightRequest{} }
func (m *InternalCreateHighlightRequest) String() string            { return proto.CompactTextString(m) }
func (*InternalCreateHighlightRequest) ProtoMessage()               {}
func (*InternalCreateHighlightRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *InternalCreateHighlightRequest) GetSourceArchiveId() string {
	if m != nil {
		return m.SourceArchiveId
	}
	return ""
}

func (m *InternalCreateHighlightRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *InternalCreateHighlightRequest) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *InternalCreateHighlightRequest) GetBroadcastId() string {
	if m != nil {
		return m.BroadcastId
	}
	return ""
}

func (m *InternalCreateHighlightRequest) GetShowFormats() map[string]*ShowFormatRequest {
	if m != nil {
		return m.ShowFormats
	}
	return nil
}

func (m *InternalCreateHighlightRequest) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *InternalCreateHighlightRequest) GetDuration() int64 {
	if m != nil {
		return m.Duration
	}
	return 0
}

type ManagerCreateHighlightRequest struct {
	// vod_id is the id of the original source vod
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// description is the description for the highlight
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// game is the game for the highlight
	Game string `protobuf:"bytes,3,opt,name=game" json:"game,omitempty"`
	// title is the title for the highlight
	Title string `protobuf:"bytes,4,opt,name=title" json:"title,omitempty"`
	// language is the language for the highlight
	Language string `protobuf:"bytes,5,opt,name=language" json:"language,omitempty"`
	// start_seconds is the start time in the original vod for the highlight
	StartSeconds int64 `protobuf:"varint,6,opt,name=start_seconds,json=startSeconds" json:"start_seconds,omitempty"`
	// end_seconds is the end time in the original vod for the highlight
	EndSeconds int64 `protobuf:"varint,7,opt,name=end_seconds,json=endSeconds" json:"end_seconds,omitempty"`
	// tag_list is a list of tag descriptors of the vod
	TagList []string `protobuf:"bytes,8,rep,name=tag_list,json=tagList" json:"tag_list,omitempty"`
	// created_by is the user that created this highlight
	CreatedBy string `protobuf:"bytes,9,opt,name=created_by,json=createdBy" json:"created_by,omitempty"`
	// user_id is the user id making the create highlight request (could be an editor or staff)
	UserId string `protobuf:"bytes,10,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerCreateHighlightRequest) Reset()                    { *m = ManagerCreateHighlightRequest{} }
func (m *ManagerCreateHighlightRequest) String() string            { return proto.CompactTextString(m) }
func (*ManagerCreateHighlightRequest) ProtoMessage()               {}
func (*ManagerCreateHighlightRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *ManagerCreateHighlightRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *ManagerCreateHighlightRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ManagerCreateHighlightRequest) GetGame() string {
	if m != nil {
		return m.Game
	}
	return ""
}

func (m *ManagerCreateHighlightRequest) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *ManagerCreateHighlightRequest) GetLanguage() string {
	if m != nil {
		return m.Language
	}
	return ""
}

func (m *ManagerCreateHighlightRequest) GetStartSeconds() int64 {
	if m != nil {
		return m.StartSeconds
	}
	return 0
}

func (m *ManagerCreateHighlightRequest) GetEndSeconds() int64 {
	if m != nil {
		return m.EndSeconds
	}
	return 0
}

func (m *ManagerCreateHighlightRequest) GetTagList() []string {
	if m != nil {
		return m.TagList
	}
	return nil
}

func (m *ManagerCreateHighlightRequest) GetCreatedBy() string {
	if m != nil {
		return m.CreatedBy
	}
	return ""
}

func (m *ManagerCreateHighlightRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type PublicGetVodByIDRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
}

func (m *PublicGetVodByIDRequest) Reset()                    { *m = PublicGetVodByIDRequest{} }
func (m *PublicGetVodByIDRequest) String() string            { return proto.CompactTextString(m) }
func (*PublicGetVodByIDRequest) ProtoMessage()               {}
func (*PublicGetVodByIDRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *PublicGetVodByIDRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

type InternalGetVodByIDRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
}

func (m *InternalGetVodByIDRequest) Reset()                    { *m = InternalGetVodByIDRequest{} }
func (m *InternalGetVodByIDRequest) String() string            { return proto.CompactTextString(m) }
func (*InternalGetVodByIDRequest) ProtoMessage()               {}
func (*InternalGetVodByIDRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *InternalGetVodByIDRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

type ManagerInternalGetVodByIDRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerInternalGetVodByIDRequest) Reset()         { *m = ManagerInternalGetVodByIDRequest{} }
func (m *ManagerInternalGetVodByIDRequest) String() string { return proto.CompactTextString(m) }
func (*ManagerInternalGetVodByIDRequest) ProtoMessage()    {}
func (*ManagerInternalGetVodByIDRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{7}
}

func (m *ManagerInternalGetVodByIDRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *ManagerInternalGetVodByIDRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type ManagerGetVodMuteInfoRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerGetVodMuteInfoRequest) Reset()                    { *m = ManagerGetVodMuteInfoRequest{} }
func (m *ManagerGetVodMuteInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*ManagerGetVodMuteInfoRequest) ProtoMessage()               {}
func (*ManagerGetVodMuteInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *ManagerGetVodMuteInfoRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *ManagerGetVodMuteInfoRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type InternalGetVodMuteInfoRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
}

func (m *InternalGetVodMuteInfoRequest) Reset()                    { *m = InternalGetVodMuteInfoRequest{} }
func (m *InternalGetVodMuteInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*InternalGetVodMuteInfoRequest) ProtoMessage()               {}
func (*InternalGetVodMuteInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *InternalGetVodMuteInfoRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

type ManagerGetVodMuteInfosRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerGetVodMuteInfosRequest) Reset()                    { *m = ManagerGetVodMuteInfosRequest{} }
func (m *ManagerGetVodMuteInfosRequest) String() string            { return proto.CompactTextString(m) }
func (*ManagerGetVodMuteInfosRequest) ProtoMessage()               {}
func (*ManagerGetVodMuteInfosRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *ManagerGetVodMuteInfosRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

func (m *ManagerGetVodMuteInfosRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type GetVodByIDIncludeBannedUsersRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
}

func (m *GetVodByIDIncludeBannedUsersRequest) Reset()         { *m = GetVodByIDIncludeBannedUsersRequest{} }
func (m *GetVodByIDIncludeBannedUsersRequest) String() string { return proto.CompactTextString(m) }
func (*GetVodByIDIncludeBannedUsersRequest) ProtoMessage()    {}
func (*GetVodByIDIncludeBannedUsersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{11}
}

func (m *GetVodByIDIncludeBannedUsersRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

type ManagerGetVodByIDRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerGetVodByIDRequest) Reset()                    { *m = ManagerGetVodByIDRequest{} }
func (m *ManagerGetVodByIDRequest) String() string            { return proto.CompactTextString(m) }
func (*ManagerGetVodByIDRequest) ProtoMessage()               {}
func (*ManagerGetVodByIDRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *ManagerGetVodByIDRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *ManagerGetVodByIDRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type ManagerSearchVodsRequest struct {
	// channel_id is the id of the channel we are making the request for
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// search is the search string
	Search string `protobuf:"bytes,2,opt,name=search" json:"search,omitempty"`
	// limit is the maximum number of response objects from the response list, used for pagination
	Limit int64 `protobuf:"varint,3,opt,name=limit" json:"limit,omitempty"`
	// offset is the offset into the response list, used for pagination
	Offset int64 `protobuf:"varint,4,opt,name=offset" json:"offset,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,5,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerSearchVodsRequest) Reset()                    { *m = ManagerSearchVodsRequest{} }
func (m *ManagerSearchVodsRequest) String() string            { return proto.CompactTextString(m) }
func (*ManagerSearchVodsRequest) ProtoMessage()               {}
func (*ManagerSearchVodsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *ManagerSearchVodsRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *ManagerSearchVodsRequest) GetSearch() string {
	if m != nil {
		return m.Search
	}
	return ""
}

func (m *ManagerSearchVodsRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ManagerSearchVodsRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ManagerSearchVodsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type PublicGetVodsByUserRequest struct {
	// channel_id is the id of the channel we are making the request for
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// broadcast_types is the list of broadcast types that we want to filter by
	BroadcastTypes []VodType `protobuf:"varint,2,rep,packed,name=broadcast_types,json=broadcastTypes,enum=vodapi.VodType" json:"broadcast_types,omitempty"`
	// language is the language filter
	Language string `protobuf:"bytes,3,opt,name=language" json:"language,omitempty"`
	// status is the filter based on vod status
	Status VodStatus `protobuf:"varint,4,opt,name=status,enum=vodapi.VodStatus" json:"status,omitempty"`
	// sort is the sort format of the response objects
	Sort VodSort `protobuf:"varint,5,opt,name=sort,enum=vodapi.VodSort" json:"sort,omitempty"`
	// limit is the maximum number of response objects from the response list, used for pagination
	Limit int64 `protobuf:"varint,6,opt,name=limit" json:"limit,omitempty"`
	// offset is the offset into the response list, used for pagination
	Offset int64 `protobuf:"varint,7,opt,name=offset" json:"offset,omitempty"`
	// recorded_after is a filter for vods recorded after a time
	RecordedAfter *google_protobuf1.Timestamp `protobuf:"bytes,8,opt,name=recorded_after,json=recordedAfter" json:"recorded_after,omitempty"`
	// recorded_before is a filter for vods recorded before a time
	RecordedBefore *google_protobuf1.Timestamp `protobuf:"bytes,9,opt,name=recorded_before,json=recordedBefore" json:"recorded_before,omitempty"`
}

func (m *PublicGetVodsByUserRequest) Reset()                    { *m = PublicGetVodsByUserRequest{} }
func (m *PublicGetVodsByUserRequest) String() string            { return proto.CompactTextString(m) }
func (*PublicGetVodsByUserRequest) ProtoMessage()               {}
func (*PublicGetVodsByUserRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *PublicGetVodsByUserRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *PublicGetVodsByUserRequest) GetBroadcastTypes() []VodType {
	if m != nil {
		return m.BroadcastTypes
	}
	return nil
}

func (m *PublicGetVodsByUserRequest) GetLanguage() string {
	if m != nil {
		return m.Language
	}
	return ""
}

func (m *PublicGetVodsByUserRequest) GetStatus() VodStatus {
	if m != nil {
		return m.Status
	}
	return VodStatus_INVALID_STATUS
}

func (m *PublicGetVodsByUserRequest) GetSort() VodSort {
	if m != nil {
		return m.Sort
	}
	return VodSort_INVALID_SORT
}

func (m *PublicGetVodsByUserRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *PublicGetVodsByUserRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *PublicGetVodsByUserRequest) GetRecordedAfter() *google_protobuf1.Timestamp {
	if m != nil {
		return m.RecordedAfter
	}
	return nil
}

func (m *PublicGetVodsByUserRequest) GetRecordedBefore() *google_protobuf1.Timestamp {
	if m != nil {
		return m.RecordedBefore
	}
	return nil
}

type ManagerInternalGetVodsByUserRequest struct {
	// channel_id is the id of the channel we are making the request for
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// broadcast_types is the list of broadcast types that we want to filter by
	BroadcastTypes []VodType `protobuf:"varint,2,rep,packed,name=broadcast_types,json=broadcastTypes,enum=vodapi.VodType" json:"broadcast_types,omitempty"`
	// language is the language filter
	Language string `protobuf:"bytes,3,opt,name=language" json:"language,omitempty"`
	// sort is the sort format of the response objects
	Sort VodSort `protobuf:"varint,5,opt,name=sort,enum=vodapi.VodSort" json:"sort,omitempty"`
	// limit is the maximum number of response objects from the response list, used for pagination
	Limit int64 `protobuf:"varint,6,opt,name=limit" json:"limit,omitempty"`
	// offset is the offset into the response list, used for pagination
	Offset int64 `protobuf:"varint,7,opt,name=offset" json:"offset,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,8,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	// published_within is a filter on responses published within some threshold
	PublishedWithin string `protobuf:"bytes,9,opt,name=published_within,json=publishedWithin" json:"published_within,omitempty"`
	// recorded_after is a filter for vods recorded after a time
	RecordedAfter *google_protobuf1.Timestamp `protobuf:"bytes,10,opt,name=recorded_after,json=recordedAfter" json:"recorded_after,omitempty"`
	// recorded_before is a filter for vods recorded before a time
	RecordedBefore *google_protobuf1.Timestamp `protobuf:"bytes,11,opt,name=recorded_before,json=recordedBefore" json:"recorded_before,omitempty"`
	// statuses is the filter based on vod statuses
	Statuses []VodStatus `protobuf:"varint,12,rep,packed,name=statuses,enum=vodapi.VodStatus" json:"statuses,omitempty"`
	// status is the filter based on vod status
	Status VodStatus `protobuf:"varint,4,opt,name=status,enum=vodapi.VodStatus" json:"status,omitempty"`
}

func (m *ManagerInternalGetVodsByUserRequest) Reset()         { *m = ManagerInternalGetVodsByUserRequest{} }
func (m *ManagerInternalGetVodsByUserRequest) String() string { return proto.CompactTextString(m) }
func (*ManagerInternalGetVodsByUserRequest) ProtoMessage()    {}
func (*ManagerInternalGetVodsByUserRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{15}
}

func (m *ManagerInternalGetVodsByUserRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *ManagerInternalGetVodsByUserRequest) GetBroadcastTypes() []VodType {
	if m != nil {
		return m.BroadcastTypes
	}
	return nil
}

func (m *ManagerInternalGetVodsByUserRequest) GetLanguage() string {
	if m != nil {
		return m.Language
	}
	return ""
}

func (m *ManagerInternalGetVodsByUserRequest) GetSort() VodSort {
	if m != nil {
		return m.Sort
	}
	return VodSort_INVALID_SORT
}

func (m *ManagerInternalGetVodsByUserRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ManagerInternalGetVodsByUserRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ManagerInternalGetVodsByUserRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *ManagerInternalGetVodsByUserRequest) GetPublishedWithin() string {
	if m != nil {
		return m.PublishedWithin
	}
	return ""
}

func (m *ManagerInternalGetVodsByUserRequest) GetRecordedAfter() *google_protobuf1.Timestamp {
	if m != nil {
		return m.RecordedAfter
	}
	return nil
}

func (m *ManagerInternalGetVodsByUserRequest) GetRecordedBefore() *google_protobuf1.Timestamp {
	if m != nil {
		return m.RecordedBefore
	}
	return nil
}

func (m *ManagerInternalGetVodsByUserRequest) GetStatuses() []VodStatus {
	if m != nil {
		return m.Statuses
	}
	return nil
}

func (m *ManagerInternalGetVodsByUserRequest) GetStatus() VodStatus {
	if m != nil {
		return m.Status
	}
	return VodStatus_INVALID_STATUS
}

type ManagerGetVodsByUserIncludeBannedUsersRequest struct {
	// channel_id is the id of the channel we are making the request for
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// broadcast_types is the list of broadcast types that we want to filter by
	BroadcastTypes []VodType `protobuf:"varint,2,rep,packed,name=broadcast_types,json=broadcastTypes,enum=vodapi.VodType" json:"broadcast_types,omitempty"`
	// language is the language filter
	Language string `protobuf:"bytes,3,opt,name=language" json:"language,omitempty"`
	// status is the filter based on vod status
	Status VodStatus `protobuf:"varint,4,opt,name=status,enum=vodapi.VodStatus" json:"status,omitempty"`
	// sort is the sort format of the response objects
	Sort VodSort `protobuf:"varint,5,opt,name=sort,enum=vodapi.VodSort" json:"sort,omitempty"`
	// limit is the maximum number of response objects from the response list, used for pagination
	Limit int64 `protobuf:"varint,6,opt,name=limit" json:"limit,omitempty"`
	// offset is the offset into the response list, used for pagination
	Offset int64 `protobuf:"varint,7,opt,name=offset" json:"offset,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,8,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerGetVodsByUserIncludeBannedUsersRequest) Reset() {
	*m = ManagerGetVodsByUserIncludeBannedUsersRequest{}
}
func (m *ManagerGetVodsByUserIncludeBannedUsersRequest) String() string {
	return proto.CompactTextString(m)
}
func (*ManagerGetVodsByUserIncludeBannedUsersRequest) ProtoMessage() {}
func (*ManagerGetVodsByUserIncludeBannedUsersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{16}
}

func (m *ManagerGetVodsByUserIncludeBannedUsersRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *ManagerGetVodsByUserIncludeBannedUsersRequest) GetBroadcastTypes() []VodType {
	if m != nil {
		return m.BroadcastTypes
	}
	return nil
}

func (m *ManagerGetVodsByUserIncludeBannedUsersRequest) GetLanguage() string {
	if m != nil {
		return m.Language
	}
	return ""
}

func (m *ManagerGetVodsByUserIncludeBannedUsersRequest) GetStatus() VodStatus {
	if m != nil {
		return m.Status
	}
	return VodStatus_INVALID_STATUS
}

func (m *ManagerGetVodsByUserIncludeBannedUsersRequest) GetSort() VodSort {
	if m != nil {
		return m.Sort
	}
	return VodSort_INVALID_SORT
}

func (m *ManagerGetVodsByUserIncludeBannedUsersRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ManagerGetVodsByUserIncludeBannedUsersRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ManagerGetVodsByUserIncludeBannedUsersRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type InternalGetVodsByBroadcastIDsRequest struct {
	// broadcast_ids is the list of broadcast ids to make the request for
	BroadcastIds []string `protobuf:"bytes,1,rep,name=broadcast_ids,json=broadcastIds" json:"broadcast_ids,omitempty"`
}

func (m *InternalGetVodsByBroadcastIDsRequest) Reset()         { *m = InternalGetVodsByBroadcastIDsRequest{} }
func (m *InternalGetVodsByBroadcastIDsRequest) String() string { return proto.CompactTextString(m) }
func (*InternalGetVodsByBroadcastIDsRequest) ProtoMessage()    {}
func (*InternalGetVodsByBroadcastIDsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{17}
}

func (m *InternalGetVodsByBroadcastIDsRequest) GetBroadcastIds() []string {
	if m != nil {
		return m.BroadcastIds
	}
	return nil
}

type PublicGetVodsByIDsRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
}

func (m *PublicGetVodsByIDsRequest) Reset()                    { *m = PublicGetVodsByIDsRequest{} }
func (m *PublicGetVodsByIDsRequest) String() string            { return proto.CompactTextString(m) }
func (*PublicGetVodsByIDsRequest) ProtoMessage()               {}
func (*PublicGetVodsByIDsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{18} }

func (m *PublicGetVodsByIDsRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

type InternalGetVodsByIDsRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
}

func (m *InternalGetVodsByIDsRequest) Reset()                    { *m = InternalGetVodsByIDsRequest{} }
func (m *InternalGetVodsByIDsRequest) String() string            { return proto.CompactTextString(m) }
func (*InternalGetVodsByIDsRequest) ProtoMessage()               {}
func (*InternalGetVodsByIDsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{19} }

func (m *InternalGetVodsByIDsRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

type InternalGetPrivateVodsByIDsRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
}

func (m *InternalGetPrivateVodsByIDsRequest) Reset()         { *m = InternalGetPrivateVodsByIDsRequest{} }
func (m *InternalGetPrivateVodsByIDsRequest) String() string { return proto.CompactTextString(m) }
func (*InternalGetPrivateVodsByIDsRequest) ProtoMessage()    {}
func (*InternalGetPrivateVodsByIDsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{20}
}

func (m *InternalGetPrivateVodsByIDsRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

type InternalGetPrivateAndDeletedVodsByIDsRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
}

func (m *InternalGetPrivateAndDeletedVodsByIDsRequest) Reset() {
	*m = InternalGetPrivateAndDeletedVodsByIDsRequest{}
}
func (m *InternalGetPrivateAndDeletedVodsByIDsRequest) String() string {
	return proto.CompactTextString(m)
}
func (*InternalGetPrivateAndDeletedVodsByIDsRequest) ProtoMessage() {}
func (*InternalGetPrivateAndDeletedVodsByIDsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{21}
}

func (m *InternalGetPrivateAndDeletedVodsByIDsRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

type GetVodsByIDsIncludeBannedUsersRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
}

func (m *GetVodsByIDsIncludeBannedUsersRequest) Reset()         { *m = GetVodsByIDsIncludeBannedUsersRequest{} }
func (m *GetVodsByIDsIncludeBannedUsersRequest) String() string { return proto.CompactTextString(m) }
func (*GetVodsByIDsIncludeBannedUsersRequest) ProtoMessage()    {}
func (*GetVodsByIDsIncludeBannedUsersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{22}
}

func (m *GetVodsByIDsIncludeBannedUsersRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

type PublicGetVodsByUsersRequest struct {
	// channel_ids is the ids of the channels we are making the request for
	ChannelIds []string `protobuf:"bytes,1,rep,name=channel_ids,json=channelIds" json:"channel_ids,omitempty"`
	// broadcast_types is the list of broadcast types that we want to filter by
	BroadcastTypes []VodType `protobuf:"varint,2,rep,packed,name=broadcast_types,json=broadcastTypes,enum=vodapi.VodType" json:"broadcast_types,omitempty"`
	// language is the language filter
	Language string `protobuf:"bytes,3,opt,name=language" json:"language,omitempty"`
	// sort is the sort format of the response objects
	Sort VodSort `protobuf:"varint,5,opt,name=sort,enum=vodapi.VodSort" json:"sort,omitempty"`
	// limit is the maximum number of response objects from the response list, used for pagination
	Limit int64 `protobuf:"varint,6,opt,name=limit" json:"limit,omitempty"`
	// offset is the offset into the response list, used for pagination
	Offset int64 `protobuf:"varint,7,opt,name=offset" json:"offset,omitempty"`
}

func (m *PublicGetVodsByUsersRequest) Reset()                    { *m = PublicGetVodsByUsersRequest{} }
func (m *PublicGetVodsByUsersRequest) String() string            { return proto.CompactTextString(m) }
func (*PublicGetVodsByUsersRequest) ProtoMessage()               {}
func (*PublicGetVodsByUsersRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{23} }

func (m *PublicGetVodsByUsersRequest) GetChannelIds() []string {
	if m != nil {
		return m.ChannelIds
	}
	return nil
}

func (m *PublicGetVodsByUsersRequest) GetBroadcastTypes() []VodType {
	if m != nil {
		return m.BroadcastTypes
	}
	return nil
}

func (m *PublicGetVodsByUsersRequest) GetLanguage() string {
	if m != nil {
		return m.Language
	}
	return ""
}

func (m *PublicGetVodsByUsersRequest) GetSort() VodSort {
	if m != nil {
		return m.Sort
	}
	return VodSort_INVALID_SORT
}

func (m *PublicGetVodsByUsersRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *PublicGetVodsByUsersRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type GetTopVodsRequest struct {
	// broadcast_types is the list of broadcast types that we want to filter by
	BroadcastTypes []VodType `protobuf:"varint,1,rep,packed,name=broadcast_types,json=broadcastTypes,enum=vodapi.VodType" json:"broadcast_types,omitempty"`
	// language is the language filter
	Language string `protobuf:"bytes,2,opt,name=language" json:"language,omitempty"`
	// game is the game filter
	Game string `protobuf:"bytes,3,opt,name=game" json:"game,omitempty"`
	// period is the period when we are making the request for
	Period string `protobuf:"bytes,4,opt,name=period" json:"period,omitempty"`
	// sort is the sort format of the response objects
	Sort VodSort `protobuf:"varint,5,opt,name=sort,enum=vodapi.VodSort" json:"sort,omitempty"`
	// limit is the maximum number of response objects from the response list, used for pagination
	Limit int64 `protobuf:"varint,6,opt,name=limit" json:"limit,omitempty"`
	// offset is the offset into the response list, used for pagination
	Offset int64 `protobuf:"varint,7,opt,name=offset" json:"offset,omitempty"`
}

func (m *GetTopVodsRequest) Reset()                    { *m = GetTopVodsRequest{} }
func (m *GetTopVodsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTopVodsRequest) ProtoMessage()               {}
func (*GetTopVodsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{24} }

func (m *GetTopVodsRequest) GetBroadcastTypes() []VodType {
	if m != nil {
		return m.BroadcastTypes
	}
	return nil
}

func (m *GetTopVodsRequest) GetLanguage() string {
	if m != nil {
		return m.Language
	}
	return ""
}

func (m *GetTopVodsRequest) GetGame() string {
	if m != nil {
		return m.Game
	}
	return ""
}

func (m *GetTopVodsRequest) GetPeriod() string {
	if m != nil {
		return m.Period
	}
	return ""
}

func (m *GetTopVodsRequest) GetSort() VodSort {
	if m != nil {
		return m.Sort
	}
	return VodSort_INVALID_SORT
}

func (m *GetTopVodsRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *GetTopVodsRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type ThumbnailRequest struct {
	// path is the path of the thumbnail
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	// offset is the offset into the thumbnail
	Offset *google_protobuf.DoubleValue `protobuf:"bytes,2,opt,name=offset" json:"offset,omitempty"`
}

func (m *ThumbnailRequest) Reset()                    { *m = ThumbnailRequest{} }
func (m *ThumbnailRequest) String() string            { return proto.CompactTextString(m) }
func (*ThumbnailRequest) ProtoMessage()               {}
func (*ThumbnailRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{25} }

func (m *ThumbnailRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *ThumbnailRequest) GetOffset() *google_protobuf.DoubleValue {
	if m != nil {
		return m.Offset
	}
	return nil
}

type ManagerUpdateVodRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// broadcast_type is the new broadcast type for the vod
	BroadcastType VodType `protobuf:"varint,2,opt,name=broadcast_type,json=broadcastType,enum=vodapi.VodType" json:"broadcast_type,omitempty"`
	// description is the new description value for the vod
	Description *google_protobuf.StringValue `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// game is the new game value for the vod
	Game *google_protobuf.StringValue `protobuf:"bytes,4,opt,name=game" json:"game,omitempty"`
	// communities is the new communities value for the vod
	Communities []string `protobuf:"bytes,5,rep,name=communities" json:"communities,omitempty"`
	// language is the new language value for the vod
	Language *google_protobuf.StringValue `protobuf:"bytes,6,opt,name=language" json:"language,omitempty"`
	// tag_list is the new tag_list value for the vod
	TagList []string `protobuf:"bytes,7,rep,name=tag_list,json=tagList" json:"tag_list,omitempty"`
	// thumbnail_path is the new thumbnail_path value for the vod
	ThumbnailPath *google_protobuf.StringValue `protobuf:"bytes,8,opt,name=thumbnail_path,json=thumbnailPath" json:"thumbnail_path,omitempty"`
	// title is the new title value for the vod
	Title *google_protobuf.StringValue `protobuf:"bytes,9,opt,name=title" json:"title,omitempty"`
	// viewable is the new viewable value for the vod
	Viewable VodViewable `protobuf:"varint,10,opt,name=viewable,enum=vodapi.VodViewable" json:"viewable,omitempty"`
	// viewable_at is the new viewable_at value for the vod
	ViewableAt *google_protobuf1.Timestamp `protobuf:"bytes,11,opt,name=viewable_at,json=viewableAt" json:"viewable_at,omitempty"`
	// broadcast_id is the new broadcast_id value for the vod
	BroadcastId *google_protobuf.StringValue `protobuf:"bytes,12,opt,name=broadcast_id,json=broadcastId" json:"broadcast_id,omitempty"`
	// offset is the new offset value for the vod
	Offset *google_protobuf.Int64Value `protobuf:"bytes,13,opt,name=offset" json:"offset,omitempty"`
	// status is the new status value for the vod
	Status VodStatus `protobuf:"varint,14,opt,name=status,enum=vodapi.VodStatus" json:"status,omitempty"`
	// duration is the new duration value for the vod
	Duration *google_protobuf.Int64Value `protobuf:"bytes,16,opt,name=duration" json:"duration,omitempty"`
	// show_formats is the new show_formats value for the vod
	ShowFormats map[string]*ShowFormatRequest `protobuf:"bytes,17,rep,name=show_formats,json=showFormats" json:"show_formats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,18,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	// uri is the uri of the vod
	Uri *google_protobuf.StringValue `protobuf:"bytes,19,opt,name=uri" json:"uri,omitempty"`
}

func (m *ManagerUpdateVodRequest) Reset()                    { *m = ManagerUpdateVodRequest{} }
func (m *ManagerUpdateVodRequest) String() string            { return proto.CompactTextString(m) }
func (*ManagerUpdateVodRequest) ProtoMessage()               {}
func (*ManagerUpdateVodRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{26} }

func (m *ManagerUpdateVodRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *ManagerUpdateVodRequest) GetBroadcastType() VodType {
	if m != nil {
		return m.BroadcastType
	}
	return VodType_INVALID_TYPE
}

func (m *ManagerUpdateVodRequest) GetDescription() *google_protobuf.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetGame() *google_protobuf.StringValue {
	if m != nil {
		return m.Game
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetCommunities() []string {
	if m != nil {
		return m.Communities
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetLanguage() *google_protobuf.StringValue {
	if m != nil {
		return m.Language
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetTagList() []string {
	if m != nil {
		return m.TagList
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetThumbnailPath() *google_protobuf.StringValue {
	if m != nil {
		return m.ThumbnailPath
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetTitle() *google_protobuf.StringValue {
	if m != nil {
		return m.Title
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetViewable() VodViewable {
	if m != nil {
		return m.Viewable
	}
	return VodViewable_INVALID_VIEWABLE
}

func (m *ManagerUpdateVodRequest) GetViewableAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.ViewableAt
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetBroadcastId() *google_protobuf.StringValue {
	if m != nil {
		return m.BroadcastId
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetOffset() *google_protobuf.Int64Value {
	if m != nil {
		return m.Offset
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetStatus() VodStatus {
	if m != nil {
		return m.Status
	}
	return VodStatus_INVALID_STATUS
}

func (m *ManagerUpdateVodRequest) GetDuration() *google_protobuf.Int64Value {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetShowFormats() map[string]*ShowFormatRequest {
	if m != nil {
		return m.ShowFormats
	}
	return nil
}

func (m *ManagerUpdateVodRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *ManagerUpdateVodRequest) GetUri() *google_protobuf.StringValue {
	if m != nil {
		return m.Uri
	}
	return nil
}

type UndeleteVodsRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
}

func (m *UndeleteVodsRequest) Reset()                    { *m = UndeleteVodsRequest{} }
func (m *UndeleteVodsRequest) String() string            { return proto.CompactTextString(m) }
func (*UndeleteVodsRequest) ProtoMessage()               {}
func (*UndeleteVodsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{27} }

func (m *UndeleteVodsRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

type SoftDeleteVodsRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
}

func (m *SoftDeleteVodsRequest) Reset()                    { *m = SoftDeleteVodsRequest{} }
func (m *SoftDeleteVodsRequest) String() string            { return proto.CompactTextString(m) }
func (*SoftDeleteVodsRequest) ProtoMessage()               {}
func (*SoftDeleteVodsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{28} }

func (m *SoftDeleteVodsRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

type InternalVodRemoveRecordsRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
}

func (m *InternalVodRemoveRecordsRequest) Reset()         { *m = InternalVodRemoveRecordsRequest{} }
func (m *InternalVodRemoveRecordsRequest) String() string { return proto.CompactTextString(m) }
func (*InternalVodRemoveRecordsRequest) ProtoMessage()    {}
func (*InternalVodRemoveRecordsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{29}
}

func (m *InternalVodRemoveRecordsRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

type HardDeleteVodsRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
}

func (m *HardDeleteVodsRequest) Reset()                    { *m = HardDeleteVodsRequest{} }
func (m *HardDeleteVodsRequest) String() string            { return proto.CompactTextString(m) }
func (*HardDeleteVodsRequest) ProtoMessage()               {}
func (*HardDeleteVodsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{30} }

func (m *HardDeleteVodsRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

type SoftDeleteVodsInIntervalRequest struct {
	// start_time_unix_seconds is the start time in unix seconds for the delete request
	StartTimeUnixSeconds int64 `protobuf:"varint,1,opt,name=start_time_unix_seconds,json=startTimeUnixSeconds" json:"start_time_unix_seconds,omitempty"`
	// end_time_unix_seconds is the end time in unix seconds for the delete request
	EndTimeUnixSeconds int64 `protobuf:"varint,2,opt,name=end_time_unix_seconds,json=endTimeUnixSeconds" json:"end_time_unix_seconds,omitempty"`
}

func (m *SoftDeleteVodsInIntervalRequest) Reset()         { *m = SoftDeleteVodsInIntervalRequest{} }
func (m *SoftDeleteVodsInIntervalRequest) String() string { return proto.CompactTextString(m) }
func (*SoftDeleteVodsInIntervalRequest) ProtoMessage()    {}
func (*SoftDeleteVodsInIntervalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{31}
}

func (m *SoftDeleteVodsInIntervalRequest) GetStartTimeUnixSeconds() int64 {
	if m != nil {
		return m.StartTimeUnixSeconds
	}
	return 0
}

func (m *SoftDeleteVodsInIntervalRequest) GetEndTimeUnixSeconds() int64 {
	if m != nil {
		return m.EndTimeUnixSeconds
	}
	return 0
}

type ManagerSoftDeleteVodsRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerSoftDeleteVodsRequest) Reset()                    { *m = ManagerSoftDeleteVodsRequest{} }
func (m *ManagerSoftDeleteVodsRequest) String() string            { return proto.CompactTextString(m) }
func (*ManagerSoftDeleteVodsRequest) ProtoMessage()               {}
func (*ManagerSoftDeleteVodsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{32} }

func (m *ManagerSoftDeleteVodsRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

func (m *ManagerSoftDeleteVodsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type YoutubeExportRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// title is the title of the youtube exported vod
	Title string `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
	// description is the description of the youtube exported vod
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// tag_list is the tag list of the youtube exported vod
	TagList []string `protobuf:"bytes,4,rep,name=tag_list,json=tagList" json:"tag_list,omitempty"`
	// private is whether the vod is private
	Private bool `protobuf:"varint,5,opt,name=private" json:"private,omitempty"`
	// do_split is whether the vod should be split up
	DoSplit bool `protobuf:"varint,6,opt,name=do_split,json=doSplit" json:"do_split,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,7,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *YoutubeExportRequest) Reset()                    { *m = YoutubeExportRequest{} }
func (m *YoutubeExportRequest) String() string            { return proto.CompactTextString(m) }
func (*YoutubeExportRequest) ProtoMessage()               {}
func (*YoutubeExportRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{33} }

func (m *YoutubeExportRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *YoutubeExportRequest) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *YoutubeExportRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *YoutubeExportRequest) GetTagList() []string {
	if m != nil {
		return m.TagList
	}
	return nil
}

func (m *YoutubeExportRequest) GetPrivate() bool {
	if m != nil {
		return m.Private
	}
	return false
}

func (m *YoutubeExportRequest) GetDoSplit() bool {
	if m != nil {
		return m.DoSplit
	}
	return false
}

func (m *YoutubeExportRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type FinalizeUploadRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
}

func (m *FinalizeUploadRequest) Reset()                    { *m = FinalizeUploadRequest{} }
func (m *FinalizeUploadRequest) String() string            { return proto.CompactTextString(m) }
func (*FinalizeUploadRequest) ProtoMessage()               {}
func (*FinalizeUploadRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{34} }

func (m *FinalizeUploadRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

type UpdateManifestRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// old_manifest is the old manifest
	OldManifest string `protobuf:"bytes,2,opt,name=old_manifest,json=oldManifest" json:"old_manifest,omitempty"`
	// new_manifest is the new manifest
	NewManifest string `protobuf:"bytes,3,opt,name=new_manifest,json=newManifest" json:"new_manifest,omitempty"`
}

func (m *UpdateManifestRequest) Reset()                    { *m = UpdateManifestRequest{} }
func (m *UpdateManifestRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateManifestRequest) ProtoMessage()               {}
func (*UpdateManifestRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{35} }

func (m *UpdateManifestRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *UpdateManifestRequest) GetOldManifest() string {
	if m != nil {
		return m.OldManifest
	}
	return ""
}

func (m *UpdateManifestRequest) GetNewManifest() string {
	if m != nil {
		return m.NewManifest
	}
	return ""
}

type ViewcountsUpdate struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// count is the view count of the vod
	Count int64 `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
}

func (m *ViewcountsUpdate) Reset()                    { *m = ViewcountsUpdate{} }
func (m *ViewcountsUpdate) String() string            { return proto.CompactTextString(m) }
func (*ViewcountsUpdate) ProtoMessage()               {}
func (*ViewcountsUpdate) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{36} }

func (m *ViewcountsUpdate) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *ViewcountsUpdate) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

type SetViewcountsRequest struct {
	// viewcounts is the view counts update list
	Viewcounts []*ViewcountsUpdate `protobuf:"bytes,1,rep,name=viewcounts" json:"viewcounts,omitempty"`
}

func (m *SetViewcountsRequest) Reset()                    { *m = SetViewcountsRequest{} }
func (m *SetViewcountsRequest) String() string            { return proto.CompactTextString(m) }
func (*SetViewcountsRequest) ProtoMessage()               {}
func (*SetViewcountsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{37} }

func (m *SetViewcountsRequest) GetViewcounts() []*ViewcountsUpdate {
	if m != nil {
		return m.Viewcounts
	}
	return nil
}

type GetPublicVodAggregationsByIDsRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
}

func (m *GetPublicVodAggregationsByIDsRequest) Reset()         { *m = GetPublicVodAggregationsByIDsRequest{} }
func (m *GetPublicVodAggregationsByIDsRequest) String() string { return proto.CompactTextString(m) }
func (*GetPublicVodAggregationsByIDsRequest) ProtoMessage()    {}
func (*GetPublicVodAggregationsByIDsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{38}
}

func (m *GetPublicVodAggregationsByIDsRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

type GetVodPopularityRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
}

func (m *GetVodPopularityRequest) Reset()                    { *m = GetVodPopularityRequest{} }
func (m *GetVodPopularityRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVodPopularityRequest) ProtoMessage()               {}
func (*GetVodPopularityRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{39} }

func (m *GetVodPopularityRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

type CreateErrorRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// error_code is the error code
	ErrorCode string `protobuf:"bytes,2,opt,name=error_code,json=errorCode" json:"error_code,omitempty"`
	// error_message is the error message
	ErrorMessage string `protobuf:"bytes,3,opt,name=error_message,json=errorMessage" json:"error_message,omitempty"`
}

func (m *CreateErrorRequest) Reset()                    { *m = CreateErrorRequest{} }
func (m *CreateErrorRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateErrorRequest) ProtoMessage()               {}
func (*CreateErrorRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{40} }

func (m *CreateErrorRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *CreateErrorRequest) GetErrorCode() string {
	if m != nil {
		return m.ErrorCode
	}
	return ""
}

func (m *CreateErrorRequest) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

type CreateThumbnailsRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// thumbnails is the list of thumbnails to create
	Thumbnails []*ThumbnailRequest `protobuf:"bytes,2,rep,name=thumbnails" json:"thumbnails,omitempty"`
}

func (m *CreateThumbnailsRequest) Reset()                    { *m = CreateThumbnailsRequest{} }
func (m *CreateThumbnailsRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateThumbnailsRequest) ProtoMessage()               {}
func (*CreateThumbnailsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{41} }

func (m *CreateThumbnailsRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *CreateThumbnailsRequest) GetThumbnails() []*ThumbnailRequest {
	if m != nil {
		return m.Thumbnails
	}
	return nil
}

type ManagerCreateCustomThumbnailUploadRequestRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// crop_x is the crop x coordinate
	CropX int64 `protobuf:"varint,2,opt,name=crop_x,json=cropX" json:"crop_x,omitempty"`
	// crop_y is the crop y coordinate
	CropY int64 `protobuf:"varint,3,opt,name=crop_y,json=cropY" json:"crop_y,omitempty"`
	// crop_w is the crop width
	CropW int64 `protobuf:"varint,4,opt,name=crop_w,json=cropW" json:"crop_w,omitempty"`
	// crop_h is the crop height
	CropH int64 `protobuf:"varint,5,opt,name=crop_h,json=cropH" json:"crop_h,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,6,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerCreateCustomThumbnailUploadRequestRequest) Reset() {
	*m = ManagerCreateCustomThumbnailUploadRequestRequest{}
}
func (m *ManagerCreateCustomThumbnailUploadRequestRequest) String() string {
	return proto.CompactTextString(m)
}
func (*ManagerCreateCustomThumbnailUploadRequestRequest) ProtoMessage() {}
func (*ManagerCreateCustomThumbnailUploadRequestRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{42}
}

func (m *ManagerCreateCustomThumbnailUploadRequestRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *ManagerCreateCustomThumbnailUploadRequestRequest) GetCropX() int64 {
	if m != nil {
		return m.CropX
	}
	return 0
}

func (m *ManagerCreateCustomThumbnailUploadRequestRequest) GetCropY() int64 {
	if m != nil {
		return m.CropY
	}
	return 0
}

func (m *ManagerCreateCustomThumbnailUploadRequestRequest) GetCropW() int64 {
	if m != nil {
		return m.CropW
	}
	return 0
}

func (m *ManagerCreateCustomThumbnailUploadRequestRequest) GetCropH() int64 {
	if m != nil {
		return m.CropH
	}
	return 0
}

func (m *ManagerCreateCustomThumbnailUploadRequestRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type ManagerDeleteThumbnailsRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// path is the path to delete
	Path string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,3,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerDeleteThumbnailsRequest) Reset()                    { *m = ManagerDeleteThumbnailsRequest{} }
func (m *ManagerDeleteThumbnailsRequest) String() string            { return proto.CompactTextString(m) }
func (*ManagerDeleteThumbnailsRequest) ProtoMessage()               {}
func (*ManagerDeleteThumbnailsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{43} }

func (m *ManagerDeleteThumbnailsRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *ManagerDeleteThumbnailsRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *ManagerDeleteThumbnailsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type DeleteThumbnailsRequest struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
}

func (m *DeleteThumbnailsRequest) Reset()                    { *m = DeleteThumbnailsRequest{} }
func (m *DeleteThumbnailsRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteThumbnailsRequest) ProtoMessage()               {}
func (*DeleteThumbnailsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{44} }

func (m *DeleteThumbnailsRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

type ManagerGetUserVodPropertiesRequest struct {
	// channel_id is the channel that we are getting properties for
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerGetUserVodPropertiesRequest) Reset()         { *m = ManagerGetUserVodPropertiesRequest{} }
func (m *ManagerGetUserVodPropertiesRequest) String() string { return proto.CompactTextString(m) }
func (*ManagerGetUserVodPropertiesRequest) ProtoMessage()    {}
func (*ManagerGetUserVodPropertiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{45}
}

func (m *ManagerGetUserVodPropertiesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *ManagerGetUserVodPropertiesRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type ManagerUpdateUserVodPropertiesRequest struct {
	// channel_id is the channel that we are updating properties for
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	// save_vods_forever is a flag to indicate if vods should be saved forever
	SaveVodsForever *google_protobuf.BoolValue `protobuf:"bytes,3,opt,name=save_vods_forever,json=saveVodsForever" json:"save_vods_forever,omitempty"`
	// vod_storage_days is how many days a vod should be stored
	VodStorageDays *google_protobuf.Int64Value `protobuf:"bytes,4,opt,name=vod_storage_days,json=vodStorageDays" json:"vod_storage_days,omitempty"`
	// can_upload_vod is a flag to indicate if the user can upload vods
	CanUploadVod *google_protobuf.BoolValue `protobuf:"bytes,5,opt,name=can_upload_vod,json=canUploadVod" json:"can_upload_vod,omitempty"`
	// youtube_exporting_disabled is a flag to indicate if the user can export to youtube
	YoutubeExportingDisabled *google_protobuf.BoolValue `protobuf:"bytes,6,opt,name=youtube_exporting_disabled,json=youtubeExportingDisabled" json:"youtube_exporting_disabled,omitempty"`
	// skip_upload_moderation is a flag to indicate if the user's vods skip moderation
	SkipUploadModeration *google_protobuf.BoolValue `protobuf:"bytes,7,opt,name=skip_upload_moderation,json=skipUploadModeration" json:"skip_upload_moderation,omitempty"`
	// skip_muting is a flag to indicate if the user's vods skip muting
	SkipMuting *google_protobuf.BoolValue `protobuf:"bytes,8,opt,name=skip_muting,json=skipMuting" json:"skip_muting,omitempty"`
	// can_upload_vod is a flag to indicate if the user can upload unlimited vods
	CanUploadUnlimited *google_protobuf.BoolValue `protobuf:"bytes,9,opt,name=can_upload_unlimited,json=canUploadUnlimited" json:"can_upload_unlimited,omitempty"`
}

func (m *ManagerUpdateUserVodPropertiesRequest) Reset()         { *m = ManagerUpdateUserVodPropertiesRequest{} }
func (m *ManagerUpdateUserVodPropertiesRequest) String() string { return proto.CompactTextString(m) }
func (*ManagerUpdateUserVodPropertiesRequest) ProtoMessage()    {}
func (*ManagerUpdateUserVodPropertiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{46}
}

func (m *ManagerUpdateUserVodPropertiesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *ManagerUpdateUserVodPropertiesRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *ManagerUpdateUserVodPropertiesRequest) GetSaveVodsForever() *google_protobuf.BoolValue {
	if m != nil {
		return m.SaveVodsForever
	}
	return nil
}

func (m *ManagerUpdateUserVodPropertiesRequest) GetVodStorageDays() *google_protobuf.Int64Value {
	if m != nil {
		return m.VodStorageDays
	}
	return nil
}

func (m *ManagerUpdateUserVodPropertiesRequest) GetCanUploadVod() *google_protobuf.BoolValue {
	if m != nil {
		return m.CanUploadVod
	}
	return nil
}

func (m *ManagerUpdateUserVodPropertiesRequest) GetYoutubeExportingDisabled() *google_protobuf.BoolValue {
	if m != nil {
		return m.YoutubeExportingDisabled
	}
	return nil
}

func (m *ManagerUpdateUserVodPropertiesRequest) GetSkipUploadModeration() *google_protobuf.BoolValue {
	if m != nil {
		return m.SkipUploadModeration
	}
	return nil
}

func (m *ManagerUpdateUserVodPropertiesRequest) GetSkipMuting() *google_protobuf.BoolValue {
	if m != nil {
		return m.SkipMuting
	}
	return nil
}

func (m *ManagerUpdateUserVodPropertiesRequest) GetCanUploadUnlimited() *google_protobuf.BoolValue {
	if m != nil {
		return m.CanUploadUnlimited
	}
	return nil
}

type ManagerGetUserVideoPrivacyPropertiesRequest struct {
	// channel_id is the channel that we are getting properties for
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerGetUserVideoPrivacyPropertiesRequest) Reset() {
	*m = ManagerGetUserVideoPrivacyPropertiesRequest{}
}
func (m *ManagerGetUserVideoPrivacyPropertiesRequest) String() string {
	return proto.CompactTextString(m)
}
func (*ManagerGetUserVideoPrivacyPropertiesRequest) ProtoMessage() {}
func (*ManagerGetUserVideoPrivacyPropertiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{47}
}

func (m *ManagerGetUserVideoPrivacyPropertiesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *ManagerGetUserVideoPrivacyPropertiesRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type ManagerUpdateUserVideoPrivacyPropertiesRequest struct {
	// channel_id is the channel that we are updating properties for
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// hide_archives is whether the user has archives hidden
	HideArchives *google_protobuf.BoolValue `protobuf:"bytes,2,opt,name=hide_archives,json=hideArchives" json:"hide_archives,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,3,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	// hide_archives_enabled is whether the user has archives hidden enabled
	HideArchivesEnabled *google_protobuf.BoolValue `protobuf:"bytes,4,opt,name=hide_archives_enabled,json=hideArchivesEnabled" json:"hide_archives_enabled,omitempty"`
}

func (m *ManagerUpdateUserVideoPrivacyPropertiesRequest) Reset() {
	*m = ManagerUpdateUserVideoPrivacyPropertiesRequest{}
}
func (m *ManagerUpdateUserVideoPrivacyPropertiesRequest) String() string {
	return proto.CompactTextString(m)
}
func (*ManagerUpdateUserVideoPrivacyPropertiesRequest) ProtoMessage() {}
func (*ManagerUpdateUserVideoPrivacyPropertiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{48}
}

func (m *ManagerUpdateUserVideoPrivacyPropertiesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *ManagerUpdateUserVideoPrivacyPropertiesRequest) GetHideArchives() *google_protobuf.BoolValue {
	if m != nil {
		return m.HideArchives
	}
	return nil
}

func (m *ManagerUpdateUserVideoPrivacyPropertiesRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *ManagerUpdateUserVideoPrivacyPropertiesRequest) GetHideArchivesEnabled() *google_protobuf.BoolValue {
	if m != nil {
		return m.HideArchivesEnabled
	}
	return nil
}

type TrackAppealRequest struct {
	// audible_magic_response_id is the id of the audible magic response
	AudibleMagicResponseId string `protobuf:"bytes,1,opt,name=audible_magic_response_id,json=audibleMagicResponseId" json:"audible_magic_response_id,omitempty"`
	// reason is the reason the track is being appealed
	Reason string `protobuf:"bytes,2,opt,name=reason" json:"reason,omitempty"`
}

func (m *TrackAppealRequest) Reset()                    { *m = TrackAppealRequest{} }
func (m *TrackAppealRequest) String() string            { return proto.CompactTextString(m) }
func (*TrackAppealRequest) ProtoMessage()               {}
func (*TrackAppealRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{49} }

func (m *TrackAppealRequest) GetAudibleMagicResponseId() string {
	if m != nil {
		return m.AudibleMagicResponseId
	}
	return ""
}

func (m *TrackAppealRequest) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type ManagerCreateVodAppealsRequest struct {
	// vod_id is the id of the vod that this appeal is for
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// city is the appeal city
	City string `protobuf:"bytes,2,opt,name=city" json:"city,omitempty"`
	// country is the appeal country
	Country string `protobuf:"bytes,3,opt,name=country" json:"country,omitempty"`
	// full_name is the appeal full name
	FullName string `protobuf:"bytes,4,opt,name=full_name,json=fullName" json:"full_name,omitempty"`
	// state is the appeal state
	State string `protobuf:"bytes,5,opt,name=state" json:"state,omitempty"`
	// street_address1 is the appeal street address 1
	StreetAddress1 string `protobuf:"bytes,6,opt,name=street_address1,json=streetAddress1" json:"street_address1,omitempty"`
	// street_address2 is the appeal street address 2
	StreetAddress2 string `protobuf:"bytes,7,opt,name=street_address2,json=streetAddress2" json:"street_address2,omitempty"`
	// zipcode is the appeal zipcode
	Zipcode string `protobuf:"bytes,8,opt,name=zipcode" json:"zipcode,omitempty"`
	// track_appeals is list of tracks that are being appealed
	TrackAppeals []*TrackAppealRequest `protobuf:"bytes,9,rep,name=track_appeals,json=trackAppeals" json:"track_appeals,omitempty"`
	// user_id is the user id making request (could be an editor or staff)
	UserId string `protobuf:"bytes,10,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *ManagerCreateVodAppealsRequest) Reset()                    { *m = ManagerCreateVodAppealsRequest{} }
func (m *ManagerCreateVodAppealsRequest) String() string            { return proto.CompactTextString(m) }
func (*ManagerCreateVodAppealsRequest) ProtoMessage()               {}
func (*ManagerCreateVodAppealsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{50} }

func (m *ManagerCreateVodAppealsRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *ManagerCreateVodAppealsRequest) GetCity() string {
	if m != nil {
		return m.City
	}
	return ""
}

func (m *ManagerCreateVodAppealsRequest) GetCountry() string {
	if m != nil {
		return m.Country
	}
	return ""
}

func (m *ManagerCreateVodAppealsRequest) GetFullName() string {
	if m != nil {
		return m.FullName
	}
	return ""
}

func (m *ManagerCreateVodAppealsRequest) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *ManagerCreateVodAppealsRequest) GetStreetAddress1() string {
	if m != nil {
		return m.StreetAddress1
	}
	return ""
}

func (m *ManagerCreateVodAppealsRequest) GetStreetAddress2() string {
	if m != nil {
		return m.StreetAddress2
	}
	return ""
}

func (m *ManagerCreateVodAppealsRequest) GetZipcode() string {
	if m != nil {
		return m.Zipcode
	}
	return ""
}

func (m *ManagerCreateVodAppealsRequest) GetTrackAppeals() []*TrackAppealRequest {
	if m != nil {
		return m.TrackAppeals
	}
	return nil
}

func (m *ManagerCreateVodAppealsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type GetVodAppealsRequest struct {
	// priority is whether this appeal is a priority
	Priority *google_protobuf.BoolValue `protobuf:"bytes,1,opt,name=priority" json:"priority,omitempty"`
	// resolved is whether this appeal is already resolved
	Resolved *google_protobuf.BoolValue `protobuf:"bytes,2,opt,name=resolved" json:"resolved,omitempty"`
	// limit is the maximum number of response objects from the response list, used for pagination
	Limit int64 `protobuf:"varint,3,opt,name=limit" json:"limit,omitempty"`
	// offset is the offset into the response list, used for pagination
	Offset int64 `protobuf:"varint,4,opt,name=offset" json:"offset,omitempty"`
	// vod_id is the id of the vod that this appeal is for
	VodId string `protobuf:"bytes,5,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// user_info is a string containing the user info for the appeal
	UserInfo string `protobuf:"bytes,6,opt,name=user_info,json=userInfo" json:"user_info,omitempty"`
}

func (m *GetVodAppealsRequest) Reset()                    { *m = GetVodAppealsRequest{} }
func (m *GetVodAppealsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVodAppealsRequest) ProtoMessage()               {}
func (*GetVodAppealsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{51} }

func (m *GetVodAppealsRequest) GetPriority() *google_protobuf.BoolValue {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *GetVodAppealsRequest) GetResolved() *google_protobuf.BoolValue {
	if m != nil {
		return m.Resolved
	}
	return nil
}

func (m *GetVodAppealsRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *GetVodAppealsRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *GetVodAppealsRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *GetVodAppealsRequest) GetUserInfo() string {
	if m != nil {
		return m.UserInfo
	}
	return ""
}

type ResolveTrackAppealRequest struct {
	// track_appeal_id is the track appeal id
	TrackAppealId string `protobuf:"bytes,1,opt,name=track_appeal_id,json=trackAppealId" json:"track_appeal_id,omitempty"`
	// action is the action being taken on this track appeal
	Action string `protobuf:"bytes,2,opt,name=action" json:"action,omitempty"`
}

func (m *ResolveTrackAppealRequest) Reset()                    { *m = ResolveTrackAppealRequest{} }
func (m *ResolveTrackAppealRequest) String() string            { return proto.CompactTextString(m) }
func (*ResolveTrackAppealRequest) ProtoMessage()               {}
func (*ResolveTrackAppealRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{52} }

func (m *ResolveTrackAppealRequest) GetTrackAppealId() string {
	if m != nil {
		return m.TrackAppealId
	}
	return ""
}

func (m *ResolveTrackAppealRequest) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

type ResolveVodAppealRequest struct {
	// vod_appeal_id is the vod appeal id
	VodAppealId string `protobuf:"bytes,1,opt,name=vod_appeal_id,json=vodAppealId" json:"vod_appeal_id,omitempty"`
}

func (m *ResolveVodAppealRequest) Reset()                    { *m = ResolveVodAppealRequest{} }
func (m *ResolveVodAppealRequest) String() string            { return proto.CompactTextString(m) }
func (*ResolveVodAppealRequest) ProtoMessage()               {}
func (*ResolveVodAppealRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{53} }

func (m *ResolveVodAppealRequest) GetVodAppealId() string {
	if m != nil {
		return m.VodAppealId
	}
	return ""
}

type CreateAudibleMagicResponseRequest struct {
	// vod_id is the id of the vod that this audible magic response request is for
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// title is the amr title
	Title string `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
	// performer is the amr performer
	Performer string `protobuf:"bytes,3,opt,name=performer" json:"performer,omitempty"`
	// genre is the amr genre
	Genre string `protobuf:"bytes,4,opt,name=genre" json:"genre,omitempty"`
	// artist is the amr artist
	Artist string `protobuf:"bytes,5,opt,name=artist" json:"artist,omitempty"`
	// album_title is the amr album title
	AlbumTitle string `protobuf:"bytes,6,opt,name=album_title,json=albumTitle" json:"album_title,omitempty"`
	// song is the amr song
	Song string `protobuf:"bytes,7,opt,name=song" json:"song,omitempty"`
	// isrc is the amr isrc
	Isrc string `protobuf:"bytes,8,opt,name=isrc" json:"isrc,omitempty"`
	// is_match is whether there is a match for this amr
	IsMatch bool `protobuf:"varint,9,opt,name=is_match,json=isMatch" json:"is_match,omitempty"`
	// match_offset_seconds is the match offset into the vod
	MatchOffsetSeconds int64 `protobuf:"varint,10,opt,name=match_offset_seconds,json=matchOffsetSeconds" json:"match_offset_seconds,omitempty"`
	// match_duration_seconds is the match duration
	MatchDurationSeconds int64 `protobuf:"varint,11,opt,name=match_duration_seconds,json=matchDurationSeconds" json:"match_duration_seconds,omitempty"`
	// scan_offset_seconds is the scan offset into the vod
	ScanOffsetSeconds int64 `protobuf:"varint,12,opt,name=scan_offset_seconds,json=scanOffsetSeconds" json:"scan_offset_seconds,omitempty"`
	// scan_duration_seconds is the scan duration
	ScanDurationSeconds int64 `protobuf:"varint,13,opt,name=scan_duration_seconds,json=scanDurationSeconds" json:"scan_duration_seconds,omitempty"`
	// mute_offset_seconds is the mute offset into the vod
	MuteOffsetSeconds int64 `protobuf:"varint,14,opt,name=mute_offset_seconds,json=muteOffsetSeconds" json:"mute_offset_seconds,omitempty"`
	// mute_duration_seconds is the mute duration
	MuteDurationSeconds int64 `protobuf:"varint,15,opt,name=mute_duration_seconds,json=muteDurationSeconds" json:"mute_duration_seconds,omitempty"`
	// audible_magic_item_id is the audible magic item id
	AudibleMagicItemId string `protobuf:"bytes,16,opt,name=audible_magic_item_id,json=audibleMagicItemId" json:"audible_magic_item_id,omitempty"`
}

func (m *CreateAudibleMagicResponseRequest) Reset()         { *m = CreateAudibleMagicResponseRequest{} }
func (m *CreateAudibleMagicResponseRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAudibleMagicResponseRequest) ProtoMessage()    {}
func (*CreateAudibleMagicResponseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{54}
}

func (m *CreateAudibleMagicResponseRequest) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *CreateAudibleMagicResponseRequest) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *CreateAudibleMagicResponseRequest) GetPerformer() string {
	if m != nil {
		return m.Performer
	}
	return ""
}

func (m *CreateAudibleMagicResponseRequest) GetGenre() string {
	if m != nil {
		return m.Genre
	}
	return ""
}

func (m *CreateAudibleMagicResponseRequest) GetArtist() string {
	if m != nil {
		return m.Artist
	}
	return ""
}

func (m *CreateAudibleMagicResponseRequest) GetAlbumTitle() string {
	if m != nil {
		return m.AlbumTitle
	}
	return ""
}

func (m *CreateAudibleMagicResponseRequest) GetSong() string {
	if m != nil {
		return m.Song
	}
	return ""
}

func (m *CreateAudibleMagicResponseRequest) GetIsrc() string {
	if m != nil {
		return m.Isrc
	}
	return ""
}

func (m *CreateAudibleMagicResponseRequest) GetIsMatch() bool {
	if m != nil {
		return m.IsMatch
	}
	return false
}

func (m *CreateAudibleMagicResponseRequest) GetMatchOffsetSeconds() int64 {
	if m != nil {
		return m.MatchOffsetSeconds
	}
	return 0
}

func (m *CreateAudibleMagicResponseRequest) GetMatchDurationSeconds() int64 {
	if m != nil {
		return m.MatchDurationSeconds
	}
	return 0
}

func (m *CreateAudibleMagicResponseRequest) GetScanOffsetSeconds() int64 {
	if m != nil {
		return m.ScanOffsetSeconds
	}
	return 0
}

func (m *CreateAudibleMagicResponseRequest) GetScanDurationSeconds() int64 {
	if m != nil {
		return m.ScanDurationSeconds
	}
	return 0
}

func (m *CreateAudibleMagicResponseRequest) GetMuteOffsetSeconds() int64 {
	if m != nil {
		return m.MuteOffsetSeconds
	}
	return 0
}

func (m *CreateAudibleMagicResponseRequest) GetMuteDurationSeconds() int64 {
	if m != nil {
		return m.MuteDurationSeconds
	}
	return 0
}

func (m *CreateAudibleMagicResponseRequest) GetAudibleMagicItemId() string {
	if m != nil {
		return m.AudibleMagicItemId
	}
	return ""
}

type CreateAudibleMagicResponsesRequest struct {
	// audible_magic_responses is the list of audible magic responses
	AudibleMagicResponses []*CreateAudibleMagicResponseRequest `protobuf:"bytes,1,rep,name=audible_magic_responses,json=audibleMagicResponses" json:"audible_magic_responses,omitempty"`
}

func (m *CreateAudibleMagicResponsesRequest) Reset()         { *m = CreateAudibleMagicResponsesRequest{} }
func (m *CreateAudibleMagicResponsesRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAudibleMagicResponsesRequest) ProtoMessage()    {}
func (*CreateAudibleMagicResponsesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{55}
}

func (m *CreateAudibleMagicResponsesRequest) GetAudibleMagicResponses() []*CreateAudibleMagicResponseRequest {
	if m != nil {
		return m.AudibleMagicResponses
	}
	return nil
}

type GetAudibleMagicResponsesRequest struct {
	// vod_ids is the ids of the vods that is being requested
	VodIds []string `protobuf:"bytes,1,rep,name=vod_ids,json=vodIds" json:"vod_ids,omitempty"`
}

func (m *GetAudibleMagicResponsesRequest) Reset()         { *m = GetAudibleMagicResponsesRequest{} }
func (m *GetAudibleMagicResponsesRequest) String() string { return proto.CompactTextString(m) }
func (*GetAudibleMagicResponsesRequest) ProtoMessage()    {}
func (*GetAudibleMagicResponsesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{56}
}

func (m *GetAudibleMagicResponsesRequest) GetVodIds() []string {
	if m != nil {
		return m.VodIds
	}
	return nil
}

type UpdateAudibleMagicResponseRequest struct {
	// audible_magic_response_id is the audible magic response id
	AudibleMagicResponseId string `protobuf:"bytes,1,opt,name=audible_magic_response_id,json=audibleMagicResponseId" json:"audible_magic_response_id,omitempty"`
	// title is the new title for the amr
	Title *google_protobuf.StringValue `protobuf:"bytes,3,opt,name=title" json:"title,omitempty"`
	// performer is the new performer for the amr
	Performer *google_protobuf.StringValue `protobuf:"bytes,4,opt,name=performer" json:"performer,omitempty"`
	// genre is the new genre for the amr
	Genre *google_protobuf.StringValue `protobuf:"bytes,5,opt,name=genre" json:"genre,omitempty"`
	// artist is the new artist for the amr
	Artist *google_protobuf.StringValue `protobuf:"bytes,6,opt,name=artist" json:"artist,omitempty"`
	// album_title is the new album title for the amr
	AlbumTitle *google_protobuf.StringValue `protobuf:"bytes,7,opt,name=album_title,json=albumTitle" json:"album_title,omitempty"`
	// song is the new song for the amr
	Song *google_protobuf.StringValue `protobuf:"bytes,8,opt,name=song" json:"song,omitempty"`
	// isrc is the new isrc for the amr
	Isrc *google_protobuf.StringValue `protobuf:"bytes,9,opt,name=isrc" json:"isrc,omitempty"`
	// is_match is the whether there is a match
	IsMatch bool `protobuf:"varint,10,opt,name=is_match,json=isMatch" json:"is_match,omitempty"`
	// match_offset_seconds is the match offset into the vod
	MatchOffsetSeconds *google_protobuf.Int64Value `protobuf:"bytes,11,opt,name=match_offset_seconds,json=matchOffsetSeconds" json:"match_offset_seconds,omitempty"`
	// match_duration_seconds is the match duration
	MatchDurationSeconds *google_protobuf.Int64Value `protobuf:"bytes,12,opt,name=match_duration_seconds,json=matchDurationSeconds" json:"match_duration_seconds,omitempty"`
	// scan_offset_seconds is the scan offset into the vod
	ScanOffsetSeconds *google_protobuf.Int64Value `protobuf:"bytes,13,opt,name=scan_offset_seconds,json=scanOffsetSeconds" json:"scan_offset_seconds,omitempty"`
	// scan_duration_seconds is the scan duration
	ScanDurationSeconds *google_protobuf.Int64Value `protobuf:"bytes,14,opt,name=scan_duration_seconds,json=scanDurationSeconds" json:"scan_duration_seconds,omitempty"`
	// mute_offset_seconds is the mute offset into the vod
	MuteOffsetSeconds *google_protobuf.Int64Value `protobuf:"bytes,15,opt,name=mute_offset_seconds,json=muteOffsetSeconds" json:"mute_offset_seconds,omitempty"`
	// mute_duration_seconds is the mute duration
	MuteDurationSeconds *google_protobuf.Int64Value `protobuf:"bytes,16,opt,name=mute_duration_seconds,json=muteDurationSeconds" json:"mute_duration_seconds,omitempty"`
	// audible_magic_item_id is the audible magic item id
	AudibleMagicItemId *google_protobuf.StringValue `protobuf:"bytes,17,opt,name=audible_magic_item_id,json=audibleMagicItemId" json:"audible_magic_item_id,omitempty"`
}

func (m *UpdateAudibleMagicResponseRequest) Reset()         { *m = UpdateAudibleMagicResponseRequest{} }
func (m *UpdateAudibleMagicResponseRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateAudibleMagicResponseRequest) ProtoMessage()    {}
func (*UpdateAudibleMagicResponseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{57}
}

func (m *UpdateAudibleMagicResponseRequest) GetAudibleMagicResponseId() string {
	if m != nil {
		return m.AudibleMagicResponseId
	}
	return ""
}

func (m *UpdateAudibleMagicResponseRequest) GetTitle() *google_protobuf.StringValue {
	if m != nil {
		return m.Title
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetPerformer() *google_protobuf.StringValue {
	if m != nil {
		return m.Performer
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetGenre() *google_protobuf.StringValue {
	if m != nil {
		return m.Genre
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetArtist() *google_protobuf.StringValue {
	if m != nil {
		return m.Artist
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetAlbumTitle() *google_protobuf.StringValue {
	if m != nil {
		return m.AlbumTitle
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetSong() *google_protobuf.StringValue {
	if m != nil {
		return m.Song
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetIsrc() *google_protobuf.StringValue {
	if m != nil {
		return m.Isrc
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetIsMatch() bool {
	if m != nil {
		return m.IsMatch
	}
	return false
}

func (m *UpdateAudibleMagicResponseRequest) GetMatchOffsetSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.MatchOffsetSeconds
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetMatchDurationSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.MatchDurationSeconds
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetScanOffsetSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.ScanOffsetSeconds
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetScanDurationSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.ScanDurationSeconds
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetMuteOffsetSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.MuteOffsetSeconds
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetMuteDurationSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.MuteDurationSeconds
	}
	return nil
}

func (m *UpdateAudibleMagicResponseRequest) GetAudibleMagicItemId() *google_protobuf.StringValue {
	if m != nil {
		return m.AudibleMagicItemId
	}
	return nil
}

type UpdateAudibleMagicResponsesRequest struct {
	// update_audible_magic_responses is the list of update audible magic responses
	UpdateAudibleMagicResponses []*UpdateAudibleMagicResponseRequest `protobuf:"bytes,1,rep,name=update_audible_magic_responses,json=updateAudibleMagicResponses" json:"update_audible_magic_responses,omitempty"`
}

func (m *UpdateAudibleMagicResponsesRequest) Reset()         { *m = UpdateAudibleMagicResponsesRequest{} }
func (m *UpdateAudibleMagicResponsesRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateAudibleMagicResponsesRequest) ProtoMessage()    {}
func (*UpdateAudibleMagicResponsesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{58}
}

func (m *UpdateAudibleMagicResponsesRequest) GetUpdateAudibleMagicResponses() []*UpdateAudibleMagicResponseRequest {
	if m != nil {
		return m.UpdateAudibleMagicResponses
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateUploadRequest)(nil), "vodapi.CreateUploadRequest")
	proto.RegisterType((*ShowFormatRequest)(nil), "vodapi.ShowFormatRequest")
	proto.RegisterType((*CreateArchiveRequest)(nil), "vodapi.CreateArchiveRequest")
	proto.RegisterType((*InternalCreateHighlightRequest)(nil), "vodapi.InternalCreateHighlightRequest")
	proto.RegisterType((*ManagerCreateHighlightRequest)(nil), "vodapi.ManagerCreateHighlightRequest")
	proto.RegisterType((*PublicGetVodByIDRequest)(nil), "vodapi.PublicGetVodByIDRequest")
	proto.RegisterType((*InternalGetVodByIDRequest)(nil), "vodapi.InternalGetVodByIDRequest")
	proto.RegisterType((*ManagerInternalGetVodByIDRequest)(nil), "vodapi.ManagerInternalGetVodByIDRequest")
	proto.RegisterType((*ManagerGetVodMuteInfoRequest)(nil), "vodapi.ManagerGetVodMuteInfoRequest")
	proto.RegisterType((*InternalGetVodMuteInfoRequest)(nil), "vodapi.InternalGetVodMuteInfoRequest")
	proto.RegisterType((*ManagerGetVodMuteInfosRequest)(nil), "vodapi.ManagerGetVodMuteInfosRequest")
	proto.RegisterType((*GetVodByIDIncludeBannedUsersRequest)(nil), "vodapi.GetVodByIDIncludeBannedUsersRequest")
	proto.RegisterType((*ManagerGetVodByIDRequest)(nil), "vodapi.ManagerGetVodByIDRequest")
	proto.RegisterType((*ManagerSearchVodsRequest)(nil), "vodapi.ManagerSearchVodsRequest")
	proto.RegisterType((*PublicGetVodsByUserRequest)(nil), "vodapi.PublicGetVodsByUserRequest")
	proto.RegisterType((*ManagerInternalGetVodsByUserRequest)(nil), "vodapi.ManagerInternalGetVodsByUserRequest")
	proto.RegisterType((*ManagerGetVodsByUserIncludeBannedUsersRequest)(nil), "vodapi.ManagerGetVodsByUserIncludeBannedUsersRequest")
	proto.RegisterType((*InternalGetVodsByBroadcastIDsRequest)(nil), "vodapi.InternalGetVodsByBroadcastIDsRequest")
	proto.RegisterType((*PublicGetVodsByIDsRequest)(nil), "vodapi.PublicGetVodsByIDsRequest")
	proto.RegisterType((*InternalGetVodsByIDsRequest)(nil), "vodapi.InternalGetVodsByIDsRequest")
	proto.RegisterType((*InternalGetPrivateVodsByIDsRequest)(nil), "vodapi.InternalGetPrivateVodsByIDsRequest")
	proto.RegisterType((*InternalGetPrivateAndDeletedVodsByIDsRequest)(nil), "vodapi.InternalGetPrivateAndDeletedVodsByIDsRequest")
	proto.RegisterType((*GetVodsByIDsIncludeBannedUsersRequest)(nil), "vodapi.GetVodsByIDsIncludeBannedUsersRequest")
	proto.RegisterType((*PublicGetVodsByUsersRequest)(nil), "vodapi.PublicGetVodsByUsersRequest")
	proto.RegisterType((*GetTopVodsRequest)(nil), "vodapi.GetTopVodsRequest")
	proto.RegisterType((*ThumbnailRequest)(nil), "vodapi.ThumbnailRequest")
	proto.RegisterType((*ManagerUpdateVodRequest)(nil), "vodapi.ManagerUpdateVodRequest")
	proto.RegisterType((*UndeleteVodsRequest)(nil), "vodapi.UndeleteVodsRequest")
	proto.RegisterType((*SoftDeleteVodsRequest)(nil), "vodapi.SoftDeleteVodsRequest")
	proto.RegisterType((*InternalVodRemoveRecordsRequest)(nil), "vodapi.InternalVodRemoveRecordsRequest")
	proto.RegisterType((*HardDeleteVodsRequest)(nil), "vodapi.HardDeleteVodsRequest")
	proto.RegisterType((*SoftDeleteVodsInIntervalRequest)(nil), "vodapi.SoftDeleteVodsInIntervalRequest")
	proto.RegisterType((*ManagerSoftDeleteVodsRequest)(nil), "vodapi.ManagerSoftDeleteVodsRequest")
	proto.RegisterType((*YoutubeExportRequest)(nil), "vodapi.YoutubeExportRequest")
	proto.RegisterType((*FinalizeUploadRequest)(nil), "vodapi.FinalizeUploadRequest")
	proto.RegisterType((*UpdateManifestRequest)(nil), "vodapi.UpdateManifestRequest")
	proto.RegisterType((*ViewcountsUpdate)(nil), "vodapi.ViewcountsUpdate")
	proto.RegisterType((*SetViewcountsRequest)(nil), "vodapi.SetViewcountsRequest")
	proto.RegisterType((*GetPublicVodAggregationsByIDsRequest)(nil), "vodapi.GetPublicVodAggregationsByIDsRequest")
	proto.RegisterType((*GetVodPopularityRequest)(nil), "vodapi.GetVodPopularityRequest")
	proto.RegisterType((*CreateErrorRequest)(nil), "vodapi.CreateErrorRequest")
	proto.RegisterType((*CreateThumbnailsRequest)(nil), "vodapi.CreateThumbnailsRequest")
	proto.RegisterType((*ManagerCreateCustomThumbnailUploadRequestRequest)(nil), "vodapi.ManagerCreateCustomThumbnailUploadRequestRequest")
	proto.RegisterType((*ManagerDeleteThumbnailsRequest)(nil), "vodapi.ManagerDeleteThumbnailsRequest")
	proto.RegisterType((*DeleteThumbnailsRequest)(nil), "vodapi.DeleteThumbnailsRequest")
	proto.RegisterType((*ManagerGetUserVodPropertiesRequest)(nil), "vodapi.ManagerGetUserVodPropertiesRequest")
	proto.RegisterType((*ManagerUpdateUserVodPropertiesRequest)(nil), "vodapi.ManagerUpdateUserVodPropertiesRequest")
	proto.RegisterType((*ManagerGetUserVideoPrivacyPropertiesRequest)(nil), "vodapi.ManagerGetUserVideoPrivacyPropertiesRequest")
	proto.RegisterType((*ManagerUpdateUserVideoPrivacyPropertiesRequest)(nil), "vodapi.ManagerUpdateUserVideoPrivacyPropertiesRequest")
	proto.RegisterType((*TrackAppealRequest)(nil), "vodapi.TrackAppealRequest")
	proto.RegisterType((*ManagerCreateVodAppealsRequest)(nil), "vodapi.ManagerCreateVodAppealsRequest")
	proto.RegisterType((*GetVodAppealsRequest)(nil), "vodapi.GetVodAppealsRequest")
	proto.RegisterType((*ResolveTrackAppealRequest)(nil), "vodapi.ResolveTrackAppealRequest")
	proto.RegisterType((*ResolveVodAppealRequest)(nil), "vodapi.ResolveVodAppealRequest")
	proto.RegisterType((*CreateAudibleMagicResponseRequest)(nil), "vodapi.CreateAudibleMagicResponseRequest")
	proto.RegisterType((*CreateAudibleMagicResponsesRequest)(nil), "vodapi.CreateAudibleMagicResponsesRequest")
	proto.RegisterType((*GetAudibleMagicResponsesRequest)(nil), "vodapi.GetAudibleMagicResponsesRequest")
	proto.RegisterType((*UpdateAudibleMagicResponseRequest)(nil), "vodapi.UpdateAudibleMagicResponseRequest")
	proto.RegisterType((*UpdateAudibleMagicResponsesRequest)(nil), "vodapi.UpdateAudibleMagicResponsesRequest")
}

func init() { proto.RegisterFile("requests.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 3084 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x5a, 0x4b, 0x73, 0x1b, 0xc7,
	0xf1, 0x2f, 0x00, 0x24, 0x01, 0x36, 0x48, 0x90, 0x5c, 0x92, 0x22, 0x24, 0x59, 0x12, 0xb5, 0xb2,
	0xff, 0x7f, 0x39, 0x89, 0x29, 0x8a, 0x56, 0x64, 0xc7, 0x89, 0x23, 0x93, 0xa2, 0x24, 0x23, 0x36,
	0x25, 0x7a, 0x29, 0xc9, 0x8f, 0xb8, 0x6a, 0x6b, 0x88, 0x19, 0x00, 0x1b, 0x2f, 0x76, 0x36, 0x33,
	0xb3, 0xa0, 0xe0, 0x7b, 0x2a, 0x07, 0x1f, 0x93, 0xaa, 0xe4, 0x0b, 0xe4, 0x33, 0xe4, 0x90, 0xaa,
	0x7c, 0x84, 0x7c, 0x84, 0x5c, 0x72, 0xb0, 0xcf, 0xa9, 0xca, 0x21, 0xb7, 0xd4, 0x3c, 0x76, 0xb1,
	0x8b, 0xe7, 0xd2, 0x8f, 0x54, 0x52, 0xb9, 0xed, 0x3c, 0xba, 0xa7, 0xa7, 0xbb, 0xe7, 0xd7, 0x3d,
	0x3d, 0x0b, 0x35, 0x46, 0x7e, 0x19, 0x11, 0x2e, 0xf8, 0x4e, 0xc8, 0xa8, 0xa0, 0xd6, 0x42, 0x8f,
	0x62, 0x14, 0x7a, 0x97, 0xae, 0xb6, 0x29, 0x6d, 0xfb, 0xe4, 0x96, 0xea, 0x3d, 0x8d, 0x5a, 0xb7,
	0xce, 0x18, 0x0a, 0x43, 0xc2, 0xcc, 0xbc, 0x4b, 0xd7, 0x86, 0xc7, 0x85, 0xd7, 0x25, 0x5c, 0xa0,
	0x6e, 0x68, 0x26, 0x2c, 0x35, 0x69, 0x90, 0xb0, 0xb5, 0xbf, 0x2a, 0xc1, 0xfa, 0x7d, 0x46, 0x90,
	0x20, 0xcf, 0x42, 0x9f, 0x22, 0xec, 0xe8, 0x55, 0xad, 0xbb, 0x50, 0x3b, 0x65, 0x14, 0xe1, 0x26,
	0xe2, 0xc2, 0x15, 0xfd, 0x90, 0xd4, 0x0b, 0xdb, 0x85, 0x9b, 0xb5, 0xbd, 0x95, 0x1d, 0x2d, 0xc7,
	0xce, 0x73, 0x8a, 0x9f, 0xf6, 0x43, 0xe2, 0x2c, 0x27, 0xd3, 0x64, 0xd3, 0xba, 0x0e, 0x4b, 0x03,
	0x3a, 0x0f, 0xd7, 0x8b, 0xdb, 0x85, 0x9b, 0x8b, 0x4e, 0x35, 0xe9, 0x6b, 0x60, 0xeb, 0x22, 0x54,
	0xe8, 0x59, 0x40, 0x98, 0x1c, 0x2e, 0xa9, 0xe1, 0xb2, 0x6a, 0x37, 0xb0, 0xb5, 0x0d, 0x55, 0x4c,
	0x78, 0x93, 0x79, 0xa1, 0xf0, 0x68, 0x50, 0x9f, 0xd3, 0xc4, 0xa9, 0x2e, 0x6b, 0x03, 0xe6, 0x85,
	0x27, 0x7c, 0x52, 0x9f, 0x57, 0x63, 0xba, 0x61, 0x59, 0x30, 0xd7, 0x46, 0x5d, 0x52, 0x5f, 0x50,
	0x9d, 0xea, 0x5b, 0xf2, 0x6a, 0xd2, 0x6e, 0x37, 0x0a, 0x3c, 0xe1, 0x11, 0x5e, 0x2f, 0x6f, 0x97,
	0x24, 0xaf, 0x54, 0x97, 0x75, 0x09, 0x2a, 0x3e, 0x0a, 0xda, 0x11, 0x6a, 0x93, 0x7a, 0x45, 0x51,
	0x26, 0x6d, 0x29, 0xa4, 0x40, 0x6d, 0xd7, 0xf7, 0xb8, 0xa8, 0x2f, 0x2a, 0xd2, 0xb2, 0x40, 0xed,
	0xf7, 0x3d, 0x2e, 0xac, 0x5b, 0x50, 0xe9, 0x79, 0xe4, 0x0c, 0x9d, 0xfa, 0xa4, 0x0e, 0x4a, 0x29,
	0xeb, 0x29, 0xa5, 0x3c, 0x37, 0x43, 0x4e, 0x32, 0xc9, 0xfa, 0x31, 0x54, 0xe3, 0x6f, 0x17, 0x89,
	0x7a, 0x75, 0xbb, 0x70, 0xb3, 0xba, 0x77, 0x69, 0x47, 0x1b, 0x6a, 0x27, 0x36, 0xd4, 0xce, 0xd3,
	0xd8, 0x50, 0x0e, 0xc4, 0xd3, 0xf7, 0x85, 0x14, 0x12, 0x47, 0x0c, 0x29, 0x7d, 0x2c, 0x6d, 0x17,
	0x6e, 0x96, 0x9c, 0xa4, 0x6d, 0xad, 0x42, 0x29, 0x62, 0x5e, 0x7d, 0x59, 0xc9, 0x2e, 0x3f, 0xe5,
	0xec, 0x2e, 0x0a, 0xbc, 0x16, 0xe1, 0xa2, 0x5e, 0xd3, 0x5b, 0x8a, 0xdb, 0xf6, 0x3f, 0x0a, 0xb0,
	0x76, 0xd2, 0xa1, 0x67, 0x0f, 0x29, 0xeb, 0x22, 0x11, 0x1b, 0xfa, 0x16, 0xac, 0x87, 0x3e, 0xea,
	0xcb, 0x8d, 0xba, 0x21, 0x23, 0x2d, 0xc2, 0x48, 0xd0, 0xd4, 0xd6, 0x2e, 0x39, 0x56, 0x3c, 0x74,
	0x9c, 0x8c, 0x48, 0x0b, 0x63, 0x8f, 0xcb, 0x01, 0x37, 0x90, 0x3a, 0x37, 0x16, 0x36, 0x7d, 0x8f,
	0xa5, 0xea, 0xeb, 0x50, 0x3e, 0xf5, 0x04, 0x43, 0x82, 0x28, 0x03, 0x97, 0x9c, 0xb8, 0x29, 0x25,
	0x6e, 0x85, 0x5c, 0x19, 0xb6, 0xe0, 0xc8, 0x4f, 0xeb, 0x26, 0xac, 0x76, 0xd1, 0x0b, 0xd7, 0xc3,
	0xcc, 0xf5, 0x02, 0x41, 0x58, 0x0f, 0xf9, 0xca, 0xb6, 0x25, 0xa7, 0xd6, 0x45, 0x2f, 0x1a, 0x98,
	0x35, 0x4c, 0xaf, 0x75, 0x01, 0x16, 0x9a, 0x14, 0x93, 0x26, 0x37, 0x66, 0x36, 0x2d, 0xeb, 0x2a,
	0x00, 0x23, 0x9c, 0xfa, 0x91, 0xd2, 0x51, 0x59, 0x8d, 0xa5, 0x7a, 0xec, 0xbf, 0x17, 0x61, 0x43,
	0xbb, 0xf8, 0x3e, 0x6b, 0x76, 0xbc, 0x1e, 0x89, 0xb7, 0x3e, 0xec, 0xab, 0x85, 0x51, 0x5f, 0xbd,
	0x0d, 0x1b, 0x49, 0x93, 0x30, 0x97, 0xd3, 0x96, 0x38, 0x43, 0x2c, 0xde, 0xf4, 0x7a, 0x6a, 0xec,
	0xc4, 0x0c, 0x49, 0x6b, 0x33, 0xd2, 0xa4, 0x0c, 0x13, 0xec, 0xd2, 0x40, 0x29, 0x60, 0x86, 0xb5,
	0xe3, 0xe9, 0x4f, 0x52, 0xee, 0x3d, 0x97, 0x76, 0xef, 0x2b, 0x00, 0xcd, 0x0e, 0x0a, 0x02, 0xe2,
	0x4b, 0x31, 0xb5, 0xe7, 0x2f, 0x9a, 0x9e, 0x06, 0xce, 0xb8, 0x48, 0x79, 0xbc, 0x8b, 0x54, 0xc6,
	0xbb, 0xc8, 0x62, 0xd6, 0x45, 0xa4, 0xe1, 0x30, 0xf1, 0x89, 0x20, 0x58, 0x79, 0x76, 0xc5, 0x89,
	0x9b, 0xd6, 0x0e, 0xac, 0x77, 0x50, 0x80, 0xcf, 0x50, 0x8f, 0xb8, 0x3e, 0x12, 0x24, 0x68, 0xf6,
	0xdd, 0x2e, 0x57, 0xbe, 0x5c, 0x72, 0xd6, 0xe2, 0xa1, 0xf7, 0xf5, 0xc8, 0x11, 0xb7, 0x7f, 0x55,
	0x82, 0xab, 0xca, 0x72, 0x01, 0xf2, 0xb5, 0xf2, 0xdf, 0xf5, 0xda, 0x1d, 0xdf, 0x6b, 0x77, 0x12,
	0xcf, 0xfb, 0x1e, 0xac, 0x71, 0x1a, 0xb1, 0x26, 0x71, 0x91, 0xb6, 0xcb, 0xc0, 0x06, 0x2b, 0x7a,
	0xc0, 0xd8, 0x6b, 0x08, 0x33, 0x8a, 0x59, 0xcc, 0x30, 0x3b, 0x2c, 0x0d, 0x76, 0x38, 0x6c, 0xd7,
	0xb9, 0x51, 0xbb, 0x7e, 0x02, 0x4b, 0xbc, 0x43, 0xcf, 0xdc, 0x96, 0x3a, 0x0b, 0xbc, 0x3e, 0xbf,
	0x5d, 0xba, 0x59, 0xdd, 0x7b, 0x23, 0x3e, 0xc7, 0xd3, 0x25, 0xdf, 0x19, 0x9c, 0x22, 0xfe, 0x20,
	0x10, 0xac, 0xef, 0x54, 0xf9, 0xa0, 0x67, 0x60, 0xc3, 0x85, 0xb4, 0x0d, 0xa7, 0x18, 0xe9, 0xd2,
	0xc7, 0xb0, 0x3a, 0xcc, 0x52, 0x6e, 0xeb, 0x33, 0xd2, 0x37, 0xfa, 0x90, 0x9f, 0xd6, 0x2d, 0x98,
	0xef, 0x21, 0x3f, 0xd2, 0xce, 0x57, 0xdd, 0xbb, 0x18, 0x0b, 0x3b, 0x72, 0xa6, 0x1d, 0x3d, 0xef,
	0xad, 0xe2, 0x9b, 0x05, 0xfb, 0x8f, 0x45, 0xb8, 0x72, 0x84, 0x02, 0xd4, 0x26, 0x6c, 0x82, 0x19,
	0x36, 0x41, 0x86, 0x96, 0x81, 0xee, 0xe7, 0x7b, 0x14, 0x8f, 0x42, 0x71, 0x71, 0x14, 0x8a, 0x63,
	0xd0, 0x2d, 0xa5, 0x40, 0x77, 0xbc, 0xff, 0xa6, 0x81, 0x76, 0x7e, 0x08, 0x68, 0x6f, 0xc0, 0x32,
	0x17, 0x88, 0x09, 0x97, 0x93, 0x26, 0x0d, 0xb0, 0x3e, 0xdc, 0x25, 0x67, 0x49, 0x75, 0x9e, 0xe8,
	0x3e, 0xeb, 0x1a, 0x54, 0x49, 0x80, 0x93, 0x29, 0x5a, 0x7f, 0x40, 0x02, 0x1c, 0x4f, 0x48, 0xc3,
	0x75, 0x25, 0x0b, 0xd7, 0xf2, 0xf0, 0xa8, 0x9d, 0x63, 0xf7, 0xb4, 0x6f, 0x3c, 0x7e, 0xd1, 0xf4,
	0x1c, 0xf4, 0xad, 0x2d, 0x28, 0x47, 0x5c, 0x3b, 0x16, 0x68, 0x58, 0x91, 0xcd, 0x06, 0xb6, 0x77,
	0x61, 0xeb, 0x38, 0x3a, 0xf5, 0xbd, 0xe6, 0x23, 0x22, 0x9e, 0x53, 0x7c, 0xd0, 0x6f, 0x1c, 0x4e,
	0x57, 0x99, 0xbd, 0x07, 0x17, 0x63, 0xc7, 0xc9, 0x4d, 0xe3, 0xc0, 0xb6, 0x31, 0xcf, 0x79, 0x49,
	0xd3, 0x92, 0x17, 0x33, 0x92, 0x3f, 0x86, 0x97, 0x0c, 0x4f, 0xcd, 0xeb, 0x28, 0x12, 0xa4, 0x11,
	0xb4, 0xe8, 0xd7, 0xe5, 0x77, 0x17, 0xae, 0x64, 0x85, 0xcb, 0xc7, 0xd0, 0xfe, 0x20, 0x71, 0xbd,
	0x2c, 0x19, 0x8f, 0xe9, 0xb6, 0xa0, 0xac, 0xe9, 0x78, 0xbd, 0xa0, 0x8c, 0xb6, 0xa0, 0x08, 0xf9,
	0x64, 0x51, 0x7e, 0x02, 0x37, 0x06, 0xfa, 0x69, 0x04, 0x4d, 0x3f, 0xc2, 0xe4, 0x40, 0xe2, 0x20,
	0x7e, 0xc6, 0x09, 0xe3, 0x33, 0x04, 0xfa, 0x19, 0xd4, 0x33, 0x02, 0x7d, 0x13, 0x25, 0xff, 0xbe,
	0x90, 0x30, 0x3b, 0x21, 0x12, 0xc0, 0x9e, 0x53, 0x9c, 0xac, 0x9f, 0x05, 0xec, 0xc2, 0x30, 0x60,
	0x5f, 0x80, 0x05, 0xae, 0x68, 0x62, 0x9e, 0xba, 0x25, 0x4f, 0x8f, 0xef, 0x75, 0x3d, 0x61, 0xa2,
	0xa6, 0x6e, 0xc8, 0xd9, 0xb4, 0xd5, 0xe2, 0x44, 0xa8, 0x43, 0x55, 0x72, 0x4c, 0x2b, 0x2d, 0xda,
	0x7c, 0x46, 0xb4, 0xdf, 0x95, 0xe0, 0x52, 0xda, 0x75, 0xf9, 0x41, 0x5f, 0x6a, 0x27, 0xa7, 0x70,
	0x6f, 0xc2, 0x4a, 0x36, 0xf3, 0xe3, 0xf5, 0xe2, 0x76, 0x69, 0x5c, 0xea, 0x57, 0xcb, 0xa4, 0x7e,
	0xd9, 0x7c, 0xaa, 0x34, 0x74, 0xcc, 0x5f, 0x85, 0x05, 0x2e, 0x90, 0x88, 0x74, 0xec, 0xaf, 0xed,
	0xad, 0xa5, 0x98, 0x9d, 0xa8, 0x01, 0xc7, 0x4c, 0xb0, 0x6e, 0xc0, 0x1c, 0xa7, 0x4c, 0xa8, 0x4d,
	0x65, 0x57, 0x3d, 0xa1, 0x4c, 0x38, 0x6a, 0x70, 0xa0, 0xaa, 0x85, 0xf1, 0xaa, 0x2a, 0x67, 0x54,
	0xb5, 0x2f, 0xd3, 0x69, 0x13, 0x93, 0x51, 0x4b, 0x10, 0xa6, 0x02, 0xe2, 0xf4, 0xb0, 0xbc, 0x1c,
	0x53, 0xec, 0x4b, 0x02, 0xeb, 0x3e, 0xac, 0x24, 0x2c, 0x4e, 0x49, 0x8b, 0x32, 0xa2, 0xb0, 0x64,
	0x3a, 0x8f, 0x64, 0xd5, 0x03, 0x45, 0x61, 0xff, 0x66, 0x0e, 0x6e, 0x8c, 0x3d, 0xee, 0xff, 0x09,
	0x26, 0xfa, 0x0e, 0xf4, 0x9e, 0x72, 0xd1, 0x4a, 0xda, 0x45, 0xad, 0x57, 0x61, 0x35, 0x94, 0x1e,
	0xca, 0x3b, 0x04, 0xbb, 0x67, 0x9e, 0xe8, 0x78, 0x81, 0x81, 0xe6, 0x95, 0xa4, 0xff, 0x43, 0xd5,
	0x3d, 0xc6, 0x76, 0xf0, 0x2d, 0xd8, 0xae, 0x7a, 0x5e, 0xdb, 0x59, 0xaf, 0x41, 0x45, 0x3b, 0x28,
	0xe1, 0xf5, 0x25, 0xa5, 0xed, 0x31, 0x3e, 0x9c, 0x4c, 0x39, 0x87, 0xc3, 0xdb, 0x7f, 0x2a, 0xc2,
	0x6b, 0x19, 0x5c, 0x32, 0xde, 0x30, 0x19, 0xdf, 0xfe, 0x07, 0x8f, 0xf0, 0x24, 0x57, 0xb2, 0xdf,
	0x83, 0x97, 0x47, 0xce, 0xd2, 0x41, 0x92, 0xea, 0x1d, 0x26, 0x3a, 0xbb, 0x01, 0xcb, 0xe9, 0xac,
	0x30, 0x0e, 0x39, 0x4b, 0xa9, 0xb4, 0x90, 0xdb, 0x77, 0xe0, 0xe2, 0x10, 0x72, 0xa6, 0x38, 0x4c,
	0x0a, 0x57, 0xf6, 0x5d, 0xb8, 0x3c, 0x22, 0x42, 0x1e, 0xba, 0xb7, 0xc1, 0x4e, 0xd1, 0x1d, 0x33,
	0xaf, 0x87, 0x04, 0xc9, 0x4f, 0xfe, 0x08, 0x7e, 0x30, 0x4a, 0xbe, 0x1f, 0xe0, 0x43, 0x9d, 0xb3,
	0xe7, 0x67, 0xf4, 0x0e, 0xbc, 0x92, 0x96, 0x7b, 0xb2, 0xdf, 0x4d, 0xe4, 0xf0, 0x65, 0x01, 0x2e,
	0x8f, 0x09, 0x39, 0x09, 0xe1, 0x35, 0xa8, 0x0e, 0x1c, 0x36, 0x26, 0x86, 0xc4, 0x63, 0xf9, 0x7f,
	0x0d, 0xa4, 0xd9, 0x5f, 0x15, 0x60, 0xed, 0x11, 0x11, 0x4f, 0x69, 0x98, 0x0e, 0xf8, 0x63, 0xc4,
	0x2f, 0x9c, 0x5f, 0xfc, 0xe2, 0x90, 0xf8, 0xe3, 0x32, 0xec, 0x0b, 0xb0, 0x10, 0x12, 0xe6, 0xd1,
	0xf8, 0x5a, 0x63, 0x5a, 0xdf, 0xc5, 0x56, 0x3f, 0x85, 0xd5, 0xa7, 0x9d, 0xa8, 0x7b, 0x1a, 0x20,
	0xcf, 0x8f, 0x37, 0x6a, 0xc1, 0x5c, 0x88, 0x44, 0xc7, 0x60, 0x8e, 0xfa, 0xb6, 0xee, 0x24, 0xf4,
	0xfa, 0x66, 0xf2, 0xd2, 0x08, 0xaa, 0x1e, 0xd2, 0xe8, 0xd4, 0x27, 0xcf, 0xe5, 0xad, 0x24, 0xe1,
	0xfe, 0x45, 0x05, 0xb6, 0x0c, 0xea, 0x3d, 0x0b, 0xb1, 0x76, 0xfc, 0x19, 0xc9, 0xd8, 0x68, 0x51,
	0xaa, 0x98, 0xab, 0x28, 0xf5, 0xd3, 0xec, 0x5d, 0xa6, 0x34, 0x41, 0xca, 0x13, 0xc1, 0xbc, 0xa0,
	0xad, 0xa5, 0xcc, 0xdc, 0x74, 0x76, 0x8d, 0x1d, 0xe6, 0x72, 0x10, 0x8e, 0x2d, 0x3e, 0xcd, 0x8f,
	0x16, 0x9f, 0xde, 0x4c, 0xd9, 0x7d, 0x21, 0x07, 0xdf, 0xf1, 0xa5, 0xa9, 0x72, 0xf6, 0xae, 0x73,
	0x1f, 0x6a, 0x22, 0xb6, 0x98, 0xab, 0xec, 0x54, 0xc9, 0xc1, 0x7a, 0x39, 0xa1, 0x39, 0x96, 0xe6,
	0xdc, 0x8b, 0xef, 0x70, 0x8b, 0x39, 0x68, 0xcd, 0x0d, 0xef, 0xdf, 0x5b, 0x13, 0xbb, 0x37, 0x74,
	0xc1, 0x5f, 0xca, 0x63, 0xd0, 0xf4, 0xf5, 0xff, 0xf5, 0xc4, 0x63, 0x97, 0x15, 0xe9, 0xe5, 0x11,
	0xd2, 0x46, 0x20, 0xee, 0xde, 0xc9, 0x38, 0x6c, 0x2a, 0xfe, 0xd5, 0x66, 0xc5, 0xbf, 0x37, 0x52,
	0x97, 0xfd, 0xd5, 0xd9, 0x2b, 0x0c, 0xca, 0x35, 0x27, 0x43, 0x75, 0x89, 0x35, 0x55, 0x97, 0xd8,
	0x8d, 0x57, 0x9a, 0x70, 0x5e, 0x66, 0x14, 0x24, 0x52, 0xa1, 0xd3, 0xca, 0x64, 0x61, 0x3b, 0xba,
	0x74, 0xb2, 0x9e, 0x43, 0x7d, 0x72, 0xe2, 0x77, 0x59, 0xa7, 0xd8, 0x81, 0xf5, 0x67, 0x81, 0x2e,
	0x36, 0xa5, 0x71, 0x75, 0x62, 0xc0, 0xd9, 0x85, 0xcd, 0x13, 0xda, 0x12, 0x87, 0xf9, 0x29, 0xde,
	0x82, 0x6b, 0x71, 0xb4, 0x54, 0x9a, 0xeb, 0xd2, 0x1e, 0x71, 0x54, 0x8a, 0x97, 0x6b, 0xb5, 0x77,
	0x11, 0xc3, 0xe7, 0x58, 0xed, 0x8b, 0x02, 0x5c, 0xcb, 0x0a, 0xd8, 0x08, 0xe2, 0x4a, 0x66, 0x4c,
	0xfc, 0x43, 0xd8, 0xd2, 0xa5, 0x0f, 0xe1, 0x75, 0x89, 0x1b, 0x05, 0xde, 0x8b, 0xa4, 0xc2, 0xa1,
	0xcb, 0xaf, 0x1b, 0x6a, 0x58, 0x9e, 0x81, 0x67, 0x81, 0xf7, 0x22, 0xae, 0x75, 0xdc, 0x86, 0x4d,
	0x12, 0xe0, 0x31, 0x44, 0x45, 0x5d, 0xb3, 0x25, 0x01, 0x1e, 0x22, 0xb1, 0x8f, 0x93, 0x8a, 0xc0,
	0xf9, 0x94, 0x36, 0xf9, 0xfa, 0xfb, 0x97, 0x02, 0x6c, 0x7c, 0x4c, 0x23, 0x11, 0x9d, 0x92, 0x07,
	0x2f, 0x42, 0x19, 0x61, 0xa6, 0x43, 0x77, 0x52, 0x18, 0x2a, 0xa6, 0x0b, 0x43, 0xdb, 0xa3, 0xc0,
	0x3c, 0x54, 0x64, 0x4a, 0x83, 0xdd, 0x5c, 0x16, 0xec, 0xea, 0x50, 0x0e, 0x75, 0xce, 0xa3, 0x82,
	0x5e, 0xc5, 0x89, 0x9b, 0x92, 0x08, 0x53, 0x97, 0x87, 0xbe, 0x89, 0x74, 0x15, 0xa7, 0x8c, 0xe9,
	0x89, 0x6c, 0xa6, 0x37, 0x54, 0xce, 0x6c, 0x68, 0x07, 0x36, 0x1f, 0x7a, 0x01, 0xf2, 0xbd, 0xcf,
	0x87, 0x5e, 0x42, 0x26, 0xd4, 0x12, 0x04, 0x6c, 0xea, 0x63, 0x78, 0x64, 0x8a, 0xa7, 0x33, 0x14,
	0x70, 0x1d, 0x96, 0xa8, 0x8f, 0xdd, 0xa4, 0xf4, 0x6a, 0x0a, 0x6a, 0xd4, 0xc7, 0x31, 0x03, 0x39,
	0x25, 0x20, 0x67, 0x83, 0x29, 0x46, 0x1d, 0x01, 0x39, 0x8b, 0xa7, 0xd8, 0xf7, 0x60, 0x55, 0x82,
	0x69, 0x93, 0x46, 0x81, 0xe0, 0x7a, 0xfd, 0x29, 0x1a, 0x57, 0xd3, 0x8c, 0x5b, 0xe8, 0x86, 0x7d,
	0x0c, 0x1b, 0x27, 0x44, 0x0c, 0x78, 0x0c, 0x12, 0x18, 0x05, 0xb0, 0xba, 0x53, 0x39, 0x41, 0x75,
	0xaf, 0x9e, 0x00, 0xdc, 0xd0, 0x92, 0x4e, 0x6a, 0xae, 0x7d, 0x0f, 0x5e, 0x96, 0xd9, 0xa7, 0x4a,
	0xfe, 0x9e, 0x53, 0xbc, 0xdf, 0x6e, 0x33, 0xd2, 0x56, 0x68, 0x96, 0x33, 0xfb, 0xdc, 0x85, 0x2d,
	0x9d, 0x34, 0x1e, 0xd3, 0x30, 0xf2, 0x11, 0xf3, 0x44, 0x7f, 0x86, 0xee, 0x29, 0x58, 0xba, 0x98,
	0xf9, 0x80, 0x31, 0xca, 0x66, 0x28, 0xfe, 0x0a, 0x00, 0x91, 0xd3, 0xdc, 0x26, 0xc5, 0xb1, 0xfb,
	0x2d, 0xaa, 0x9e, 0xfb, 0x14, 0xab, 0xfa, 0xa3, 0x1e, 0xee, 0x12, 0xce, 0x07, 0x39, 0xe4, 0x92,
	0xea, 0x3c, 0xd2, 0x7d, 0xf6, 0x2f, 0x60, 0x4b, 0x2f, 0x98, 0xe4, 0x43, 0x33, 0x4a, 0x4d, 0x52,
	0x9f, 0x49, 0x54, 0xd5, 0xa9, 0x6c, 0x4a, 0x9f, 0xc3, 0x59, 0x95, 0x93, 0x9a, 0x6b, 0xff, 0xb9,
	0x00, 0xbb, 0x99, 0x8a, 0xed, 0xfd, 0x88, 0x0b, 0xda, 0x4d, 0x68, 0x32, 0xde, 0x39, 0x43, 0x8a,
	0x4d, 0x58, 0x68, 0x32, 0x1a, 0xba, 0x2f, 0x12, 0x27, 0x60, 0x34, 0xfc, 0x28, 0xe9, 0xee, 0xc7,
	0x85, 0x26, 0xd9, 0xfa, 0x38, 0xe9, 0x3e, 0x33, 0x85, 0x26, 0xd5, 0xfd, 0x61, 0xd2, 0xdd, 0x31,
	0xef, 0x32, 0xaa, 0xfb, 0xdd, 0xf4, 0x49, 0x5a, 0xc8, 0x9c, 0x24, 0x0c, 0x57, 0x8d, 0xfc, 0x1a,
	0x68, 0x72, 0xeb, 0x2c, 0xce, 0x2d, 0x8b, 0xa9, 0xdc, 0x32, 0xb5, 0x4a, 0x69, 0xb8, 0x3c, 0x7b,
	0x3e, 0xf6, 0xf6, 0xa7, 0x60, 0x0f, 0x6e, 0xd9, 0xf2, 0x76, 0x22, 0x5d, 0x8e, 0xd1, 0x90, 0x30,
	0x99, 0x90, 0xe5, 0xbc, 0x5a, 0x4f, 0x04, 0xc4, 0x2f, 0xe7, 0xe0, 0x95, 0x4c, 0x78, 0xfe, 0xb6,
	0x57, 0xb0, 0x1e, 0xc2, 0x1a, 0x47, 0x3d, 0xe2, 0xf6, 0x28, 0xe6, 0x32, 0x41, 0x20, 0x3d, 0xc2,
	0x26, 0x3e, 0x2f, 0x1d, 0x50, 0xea, 0xeb, 0xc8, 0xbd, 0x22, 0x89, 0x24, 0xd8, 0x3f, 0xd4, 0x24,
	0xd6, 0x03, 0x58, 0x95, 0xea, 0xe1, 0x82, 0x32, 0xd4, 0x26, 0x2e, 0x46, 0x7d, 0x6e, 0x32, 0xdb,
	0xa9, 0x49, 0x4a, 0xad, 0x27, 0xd3, 0x1c, 0x45, 0x73, 0x88, 0xfa, 0xdc, 0x7a, 0x07, 0x6a, 0x4d,
	0x14, 0xb8, 0x91, 0x72, 0x47, 0x29, 0x94, 0x72, 0x8f, 0xe9, 0xb2, 0x2c, 0x35, 0x51, 0xa0, 0xfd,
	0xf7, 0x39, 0xc5, 0xd6, 0x47, 0x70, 0xa9, 0xaf, 0x43, 0x88, 0x4b, 0x54, 0x0c, 0xf1, 0x82, 0xb6,
	0x8b, 0x3d, 0x2e, 0xb3, 0x3c, 0x6c, 0x92, 0xe2, 0x69, 0xdc, 0xea, 0xfd, 0x74, 0x00, 0xf2, 0x82,
	0xf6, 0xa1, 0xa1, 0xb5, 0x8e, 0xe1, 0x02, 0xff, 0xcc, 0x0b, 0x63, 0xe1, 0xba, 0x14, 0x93, 0xd4,
	0xd3, 0xcb, 0x74, 0xae, 0x1b, 0x92, 0x52, 0x0b, 0x79, 0x94, 0xd0, 0xc9, 0x7c, 0x55, 0x71, 0xec,
	0x46, 0x72, 0xa1, 0x89, 0xe5, 0xc3, 0x01, 0x1b, 0x90, 0xd3, 0x8f, 0xd4, 0x6c, 0xeb, 0x7d, 0xd8,
	0x48, 0xa9, 0x2a, 0x0a, 0xd4, 0xb5, 0x8b, 0xe0, 0x89, 0x05, 0xc4, 0x01, 0x17, 0x2b, 0x51, 0xd8,
	0xb3, 0x98, 0xca, 0x26, 0xf0, 0xfd, 0x21, 0x3f, 0xf6, 0x30, 0xa1, 0xea, 0xfa, 0xdf, 0xec, 0x7f,
	0x7b, 0x0e, 0xfd, 0xcf, 0x02, 0xec, 0x8c, 0x3a, 0xf4, 0x37, 0x59, 0xea, 0x1e, 0x2c, 0x77, 0x3c,
	0x9c, 0x3c, 0xf7, 0x71, 0x93, 0x20, 0x4e, 0x75, 0x18, 0x49, 0x60, 0x9e, 0x01, 0xf9, 0x44, 0x30,
	0xb0, 0x1e, 0xc3, 0x66, 0x86, 0xb3, 0x4b, 0x02, 0xed, 0x44, 0x73, 0x33, 0x57, 0x58, 0x4f, 0xaf,
	0xf0, 0x40, 0x93, 0xd9, 0x6d, 0xb0, 0x9e, 0x32, 0xd4, 0xfc, 0x6c, 0x3f, 0x0c, 0xc9, 0x20, 0x5f,
	0xfb, 0x11, 0x5c, 0x44, 0x11, 0xf6, 0xe4, 0x95, 0xa5, 0x8b, 0xda, 0x5e, 0xd3, 0x65, 0x84, 0x87,
	0x34, 0xe0, 0xa9, 0x87, 0xcb, 0x0b, 0x66, 0xc2, 0x91, 0x1c, 0x77, 0xcc, 0xb0, 0xae, 0xf8, 0x33,
	0x82, 0x78, 0xf2, 0x90, 0x66, 0x5a, 0xf6, 0x5f, 0x8b, 0x09, 0x58, 0x6a, 0xb0, 0x97, 0x11, 0x54,
	0x2d, 0x9a, 0x03, 0x2c, 0x9b, 0x9e, 0xe8, 0xc7, 0x60, 0x29, 0xbf, 0x65, 0x46, 0xa4, 0x82, 0x32,
	0xeb, 0xc7, 0x3f, 0x56, 0x98, 0xa6, 0x75, 0x19, 0x16, 0x5b, 0x91, 0xef, 0xeb, 0x17, 0x7b, 0x5d,
	0x38, 0xa8, 0xc8, 0x8e, 0xc7, 0xe6, 0xd1, 0x4e, 0xde, 0x5b, 0x92, 0x7f, 0x2a, 0x54, 0xc3, 0xfa,
	0x7f, 0x58, 0xe1, 0x82, 0x11, 0x22, 0x5c, 0x84, 0x31, 0x23, 0x9c, 0xdf, 0x36, 0x38, 0x5f, 0xd3,
	0xdd, 0xfb, 0xa6, 0x77, 0x74, 0xe2, 0x9e, 0x49, 0xad, 0xb2, 0x13, 0xf7, 0xa4, 0x78, 0x9f, 0x7b,
	0xa1, 0x0a, 0xc3, 0xba, 0x84, 0x17, 0x37, 0xa5, 0x67, 0x08, 0xa9, 0x6f, 0x17, 0xe9, 0xbd, 0xab,
	0x5f, 0x2e, 0xa4, 0xdd, 0xe2, 0x80, 0x39, 0x62, 0x0c, 0x67, 0x49, 0x0c, 0xfa, 0xf8, 0xe4, 0x57,
	0xbc, 0xaf, 0x0a, 0xb0, 0xa1, 0xb3, 0x8b, 0x21, 0xb5, 0xde, 0x85, 0x4a, 0xc8, 0x3c, 0x2a, 0xb3,
	0x0d, 0xa5, 0xd8, 0xe9, 0x5e, 0x92, 0xcc, 0x95, 0x74, 0xea, 0xdf, 0x82, 0x1e, 0xc1, 0x39, 0xfc,
	0x37, 0x99, 0x7b, 0xce, 0xb7, 0x9d, 0x81, 0xd1, 0xe7, 0xd3, 0x46, 0xbf, 0x0c, 0x8b, 0x7a, 0x9b,
	0x41, 0x8b, 0x1a, 0x6b, 0x54, 0xd4, 0x46, 0x83, 0x16, 0xb5, 0x7f, 0x0e, 0x17, 0x1d, 0xbd, 0xda,
	0x18, 0xdf, 0xfd, 0x3f, 0x58, 0x49, 0x6b, 0x78, 0xe0, 0x4e, 0xcb, 0x29, 0x3d, 0x6a, 0x47, 0x45,
	0xcd, 0xd4, 0x8b, 0xaf, 0x69, 0xd9, 0x6f, 0xc3, 0x96, 0x61, 0x9e, 0xa8, 0x32, 0x66, 0x6d, 0xc3,
	0xb2, 0x94, 0x75, 0x98, 0x71, 0xb5, 0x17, 0x4f, 0x6c, 0x60, 0xfb, 0x6f, 0x73, 0x70, 0xdd, 0xfc,
	0x83, 0x31, 0xe6, 0x80, 0x7c, 0xad, 0xbb, 0xc3, 0x4b, 0xb0, 0x18, 0x12, 0x26, 0x2f, 0xca, 0x26,
	0x0c, 0x2e, 0x3a, 0x83, 0x0e, 0x49, 0xd3, 0x26, 0x01, 0x4b, 0x1e, 0xa2, 0x55, 0x43, 0xed, 0x8e,
	0x09, 0x79, 0x97, 0x30, 0x2f, 0x66, 0xba, 0x65, 0x5d, 0x83, 0x2a, 0xf2, 0x4f, 0xa3, 0xae, 0x9b,
	0x7e, 0xb8, 0x07, 0xd5, 0xf5, 0x34, 0xfe, 0xc1, 0x88, 0xd3, 0xa0, 0x6d, 0x1c, 0x5b, 0x7d, 0xcb,
	0x3e, 0x8f, 0xb3, 0xa6, 0xf1, 0x65, 0xf5, 0x2d, 0x6f, 0x1e, 0x1e, 0x77, 0xbb, 0x48, 0x34, 0x3b,
	0x0a, 0xdd, 0x2b, 0x4e, 0xd9, 0xe3, 0x47, 0xb2, 0x69, 0xed, 0xc2, 0x86, 0xea, 0x77, 0xb5, 0x89,
	0x93, 0x5b, 0x1b, 0xe8, 0x5b, 0x9b, 0x1a, 0x7b, 0xa2, 0x86, 0xe2, 0x8b, 0xde, 0x1d, 0xb8, 0xa0,
	0x29, 0xe2, 0xf2, 0x40, 0x42, 0xa3, 0x7f, 0xbb, 0xd0, 0xfc, 0x0e, 0xcd, 0x60, 0x4c, 0xb5, 0x03,
	0xeb, 0x5c, 0x46, 0x9b, 0xa1, 0x65, 0xf4, 0xbf, 0x43, 0x6b, 0x72, 0x28, 0xbb, 0xca, 0x1e, 0x6c,
	0xaa, 0xf9, 0x23, 0x8b, 0x2c, 0x2b, 0x0a, 0xc5, 0x6c, 0xcc, 0x1a, 0xdd, 0x48, 0x90, 0xe1, 0x35,
	0x6a, 0x7a, 0x0d, 0x39, 0x34, 0xb2, 0x86, 0x9a, 0x3f, 0xb2, 0xc6, 0x8a, 0x5e, 0x43, 0x0e, 0x0e,
	0xaf, 0x71, 0x1b, 0x36, 0xb3, 0x68, 0xeb, 0x09, 0xd2, 0x95, 0xbe, 0xb1, 0xaa, 0xf4, 0x6d, 0xa5,
	0x91, 0xb6, 0x21, 0x48, 0xb7, 0x81, 0xed, 0x5f, 0x17, 0xc0, 0x9e, 0xec, 0x65, 0xc9, 0xd1, 0x47,
	0xb0, 0x35, 0x1e, 0xc7, 0xe3, 0x8b, 0xcf, 0xab, 0x31, 0xee, 0xcc, 0x74, 0x59, 0x67, 0x73, 0x1c,
	0xe0, 0xab, 0x62, 0xc3, 0x23, 0x22, 0xa6, 0x4a, 0x31, 0xf1, 0x3e, 0xf4, 0x87, 0x0a, 0x5c, 0xd7,
	0x11, 0x77, 0xda, 0x59, 0xf9, 0x06, 0xc1, 0x28, 0x29, 0xf0, 0x95, 0xf2, 0x17, 0xf8, 0xde, 0x4a,
	0x9f, 0xb6, 0x3c, 0x75, 0xd0, 0xd4, 0x59, 0xdc, 0x8b, 0xcf, 0xe2, 0x7c, 0x9e, 0xf5, 0xf4, 0x49,
	0xbd, 0x93, 0x9c, 0xd4, 0x3c, 0xc5, 0xd1, 0xf8, 0x1c, 0xbf, 0x9d, 0x3d, 0xc7, 0xe5, 0x1c, 0xa4,
	0xe9, 0x53, 0xbe, 0x6b, 0x4e, 0x79, 0x9e, 0xa2, 0xa9, 0xc6, 0x80, 0x5d, 0x83, 0x01, 0x79, 0x4a,
	0xa5, 0xa3, 0x08, 0x01, 0x59, 0x84, 0x38, 0x9a, 0x80, 0x10, 0xd5, 0xd9, 0xc9, 0xf9, 0x38, 0xf8,
	0xf8, 0x60, 0x22, 0x7c, 0x2c, 0xcd, 0x66, 0x38, 0x1e, 0x5b, 0xde, 0x1b, 0x8f, 0x2d, 0x39, 0x8a,
	0xa8, 0x63, 0x80, 0xe7, 0xc9, 0x24, 0xe0, 0xa9, 0xcd, 0x66, 0x37, 0x16, 0x95, 0xde, 0x1b, 0x8f,
	0x4a, 0x2b, 0x39, 0xa4, 0x1b, 0x85, 0xac, 0x27, 0x93, 0x20, 0x2b, 0x47, 0x3d, 0x77, 0x2c, 0x9e,
	0x3d, 0x99, 0x84, 0x67, 0x6b, 0x39, 0x7c, 0x67, 0x1c, 0xda, 0xfd, 0xb6, 0x00, 0xf6, 0x64, 0x9c,
	0x48, 0x70, 0x26, 0x80, 0xab, 0x91, 0x9a, 0xe5, 0xe6, 0x04, 0xbd, 0x99, 0xd8, 0xe3, 0x5c, 0x8e,
	0x26, 0x2f, 0x7b, 0x50, 0xf9, 0xc4, 0xfc, 0xaa, 0x7c, 0xba, 0xa0, 0xb6, 0xf2, 0xfa, 0xbf, 0x02,
	0x00, 0x00, 0xff, 0xff, 0x38, 0x80, 0x41, 0x90, 0xcb, 0x2c, 0x00, 0x00,
}
