// Code generated by protoc-gen-twirp v5.4.2, DO NOT EDIT.
// source: service.proto

/*
Package vodapi is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.4.2.

It is generated from these files:
	responses.proto
	requests.proto
	service.proto
	consts.proto
*/
package vodapi

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ================
// VodApi Interface
// ================

type VodApi interface {
	// CreateUpload will create a vod upload
	CreateUpload(context.Context, *CreateUploadRequest) (*CreateUploadResponse, error)

	// CreateArchive will create a vod archive
	CreateArchive(context.Context, *CreateArchiveRequest) (*CreateArchiveResponse, error)

	// InternalCreateHighlight will create a highlight
	// NOTE: this endpoint is only used for an integration tests in the vod workers and should be removed when
	// that test is updated to hit visage directly.  The jira to track this is http://jira.twitch.com/browse/xxx-xxx
	InternalCreateHighlight(context.Context, *InternalCreateHighlightRequest) (*InternalCreateHighlightResponse, error)

	// ManagerCreateHighlight will create a highlight
	ManagerCreateHighlight(context.Context, *ManagerCreateHighlightRequest) (*ManagerCreateHighlightResponse, error)

	// PublicGetVodByID gets a single vod by id, will not get hidden or processing vods
	PublicGetVodByID(context.Context, *PublicGetVodByIDRequest) (*PublicGetVodByIDResponse, error)

	// InternalGetVodByID gets a single vod by id, will get hidden and processing vods
	InternalGetVodByID(context.Context, *InternalGetVodByIDRequest) (*InternalGetVodByIDResponse, error)

	// ManagerInternalGetVodByID gets a single vod by id, will get hidden and processing vods and populate all user information
	ManagerInternalGetVodByID(context.Context, *ManagerInternalGetVodByIDRequest) (*ManagerInternalGetVodByIDResponse, error)

	// ManagerGetVodMuteInfo gets the muting and appeal information for a vod
	ManagerGetVodMuteInfo(context.Context, *ManagerGetVodMuteInfoRequest) (*ManagerGetVodMuteInfoResponse, error)

	// InternalGetVodMuteInfo gets the muting and appeal information for a vod
	InternalGetVodMuteInfo(context.Context, *InternalGetVodMuteInfoRequest) (*InternalGetVodMuteInfoResponse, error)

	// ManagerGetVodMuteInfos gets the muting and appeal information for vods
	ManagerGetVodMuteInfos(context.Context, *ManagerGetVodMuteInfosRequest) (*ManagerGetVodMuteInfosResponse, error)

	// GetVodByIDIncludeBannedUsers gets a single vod by id even if the user is banned
	GetVodByIDIncludeBannedUsers(context.Context, *GetVodByIDIncludeBannedUsersRequest) (*GetVodByIDIncludeBannedUsersResponse, error)

	// ManagerGetVodByID gets a single vod by id populating user information, but does not include hidden or processing vods
	ManagerGetVodByID(context.Context, *ManagerGetVodByIDRequest) (*ManagerGetVodByIDResponse, error)

	// ManagerSearchVods searches for vods matching a search string
	ManagerSearchVods(context.Context, *ManagerSearchVodsRequest) (*ManagerSearchVodsResponse, error)

	// PublicGetVodsByUser gets vods by a user, omitting hidden and processing vods
	PublicGetVodsByUser(context.Context, *PublicGetVodsByUserRequest) (*PublicGetVodsByUserResponse, error)

	// ManagerInternalGetVodsByUser gets vods by a user, including hidden, processing and full user info
	ManagerInternalGetVodsByUser(context.Context, *ManagerInternalGetVodsByUserRequest) (*ManagerInternalGetVodsByUserResponse, error)

	// ManagerGetVodsByUserIncludeBannedUsers gets vods by a user even if the user is banned
	ManagerGetVodsByUserIncludeBannedUsers(context.Context, *ManagerGetVodsByUserIncludeBannedUsersRequest) (*ManagerGetVodsByUserIncludeBannedUsersResponse, error)

	// InternalGetVodsByBroadcastIDs gets vods by broadcast ids including hidden and processing
	InternalGetVodsByBroadcastIDs(context.Context, *InternalGetVodsByBroadcastIDsRequest) (*InternalGetVodsByBroadcastIDsResponse, error)

	// PublicGetVodsByIDs gets vods by ids will omit hidden and processing
	PublicGetVodsByIDs(context.Context, *PublicGetVodsByIDsRequest) (*PublicGetVodsByIDsResponse, error)

	// InternalGetVodsByIDs gets vods by ids including hidden, processing, and deleted
	InternalGetVodsByIDs(context.Context, *InternalGetVodsByIDsRequest) (*InternalGetVodsByIDsResponse, error)

	// InternalGetPrivateVodsByIDs gets vods by ids including unpublished vods
	InternalGetPrivateVodsByIDs(context.Context, *InternalGetPrivateVodsByIDsRequest) (*InternalGetPrivateVodsByIDsResponse, error)

	// InternalGetPrivateAndDeletedVodsByIDs gets vods by ids including unpublished and deleted vods
	InternalGetPrivateAndDeletedVodsByIDs(context.Context, *InternalGetPrivateAndDeletedVodsByIDsRequest) (*InternalGetPrivateAndDeletedVodsByIDsResponse, error)

	// GetVodsByIDsIncludeBannedUsers gets vods by ids even if the user is banned
	GetVodsByIDsIncludeBannedUsers(context.Context, *GetVodsByIDsIncludeBannedUsersRequest) (*GetVodsByIDsIncludeBannedUsersResponse, error)

	// ManagerGetVodsByUserIncludeBannedUsers gets vods by a user even if the user is banned
	PublicGetVodsByUsers(context.Context, *PublicGetVodsByUsersRequest) (*PublicGetVodsByUsersResponse, error)

	// GetTopVods gets the top vods for twitch
	GetTopVods(context.Context, *GetTopVodsRequest) (*GetTopVodsResponse, error)

	// ManagerUpdateVod updates the fields on a vod
	ManagerUpdateVod(context.Context, *ManagerUpdateVodRequest) (*ManagerUpdateVodResponse, error)

	// UndeleteVods removes the deleted flag on a vod
	UndeleteVods(context.Context, *UndeleteVodsRequest) (*UndeleteVodsResponse, error)

	// SoftDeleteVods marks a vod as deleted
	SoftDeleteVods(context.Context, *SoftDeleteVodsRequest) (*SoftDeleteVodsResponse, error)

	// InternalVodRemoveRecords removes the vod records from the database
	InternalVodRemoveRecords(context.Context, *InternalVodRemoveRecordsRequest) (*InternalVodRemoveRecordsResponse, error)

	// HardDeleteVods removes the underlying vod manifest and ts data
	HardDeleteVods(context.Context, *HardDeleteVodsRequest) (*HardDeleteVodsResponse, error)

	// SoftDeleteVodsInInterval marks vods within a certain interval to be deleted
	SoftDeleteVodsInInterval(context.Context, *SoftDeleteVodsInIntervalRequest) (*SoftDeleteVodsInIntervalResponse, error)

	// ManagerSoftDeleteVods marks a vod as deleted if the user owns or can edit the vod
	ManagerSoftDeleteVods(context.Context, *ManagerSoftDeleteVodsRequest) (*ManagerSoftDeleteVodsResponse, error)

	// YoutubeExport sends a vod to youtube
	YoutubeExport(context.Context, *YoutubeExportRequest) (*YoutubeExportResponse, error)

	// FinalizeUpload finishes a vod upload
	FinalizeUpload(context.Context, *FinalizeUploadRequest) (*FinalizeUploadResponse, error)

	// UpdateManifest updates the vod manifest
	UpdateManifest(context.Context, *UpdateManifestRequest) (*UpdateManifestResponse, error)

	// SetViewcounts sets the view counts for a vod
	SetViewcounts(context.Context, *SetViewcountsRequest) (*SetViewcountsResponse, error)

	// GetPublicVodAggregationsByIDs gets an aggregated representation of multiple vods
	GetPublicVodAggregationsByIDs(context.Context, *GetPublicVodAggregationsByIDsRequest) (*PublicVodAggregationsByIDsResponse, error)

	// GetVodPopularity gets whether the vod is popular
	GetVodPopularity(context.Context, *GetVodPopularityRequest) (*VodPopularityResponse, error)

	// CreateError creates an error associated with a vod when uploading
	CreateError(context.Context, *CreateErrorRequest) (*CreateErrorResponse, error)

	// CreateThumbnails creates vod thumbnails
	CreateThumbnails(context.Context, *CreateThumbnailsRequest) (*CreateThumbnailsResponse, error)

	// ManagerCreateCustomThumbnailUploadRequest creates a request to upload a new vod thumbnail
	ManagerCreateCustomThumbnailUploadRequest(context.Context, *ManagerCreateCustomThumbnailUploadRequestRequest) (*CreateCustomThumbnailUploadRequestResponse, error)

	// ManagerDeleteThumbnails deletes vod thumbnails if the user owns or can edit the vod
	ManagerDeleteThumbnails(context.Context, *ManagerDeleteThumbnailsRequest) (*ManagerDeleteThumbnailsResponse, error)

	// DeleteThumbnails deletes vod thumbnails
	DeleteThumbnails(context.Context, *DeleteThumbnailsRequest) (*DeleteThumbnailsResponse, error)

	// ManagerGetUserVodProperties gets the user vod properties
	ManagerGetUserVodProperties(context.Context, *ManagerGetUserVodPropertiesRequest) (*UserVodPropertiesResponse, error)

	// ManagerGetUserVodProperties updates the user vod properties
	ManagerUpdateUserVodProperties(context.Context, *ManagerUpdateUserVodPropertiesRequest) (*UserVodPropertiesResponse, error)

	// ManagerGetUserVodProperties gets the user video properties
	ManagerGetUserVideoPrivacyProperties(context.Context, *ManagerGetUserVideoPrivacyPropertiesRequest) (*UserVideoPrivacyPropertiesResponse, error)

	// ManagerGetUserVodProperties updates the user video properties
	ManagerUpdateUserVideoPrivacyProperties(context.Context, *ManagerUpdateUserVideoPrivacyPropertiesRequest) (*UserVideoPrivacyPropertiesResponse, error)

	// ManagerCreateVodAppeals creates vod appeals
	ManagerCreateVodAppeals(context.Context, *ManagerCreateVodAppealsRequest) (*CreateVodAppealsResponse, error)

	// GetVodAppeals gets vod appeals
	GetVodAppeals(context.Context, *GetVodAppealsRequest) (*VodAppealsResponse, error)

	// ResolveTrackAppeal resolves a track appeal
	ResolveTrackAppeal(context.Context, *ResolveTrackAppealRequest) (*ResolveTrackAppealResponse, error)

	// ResolveVodAppeal resolves a vod appeal
	ResolveVodAppeal(context.Context, *ResolveVodAppealRequest) (*ResolveVodAppealResponse, error)

	// CreateAudibleMagicResponses creates audible magic response objects for vods
	CreateAudibleMagicResponses(context.Context, *CreateAudibleMagicResponsesRequest) (*AudibleMagicResponsesResponse, error)

	// GetAudibleMagicResponses gets the audible magic response objects for vods
	GetAudibleMagicResponses(context.Context, *GetAudibleMagicResponsesRequest) (*AudibleMagicResponsesResponse, error)

	// UpdateAudibleMagicResponses updates the audible magic response objects for vods
	UpdateAudibleMagicResponses(context.Context, *UpdateAudibleMagicResponsesRequest) (*AudibleMagicResponsesResponse, error)
}

// ======================
// VodApi Protobuf Client
// ======================

type vodApiProtobufClient struct {
	client HTTPClient
	urls   [53]string
}

// NewVodApiProtobufClient creates a Protobuf client that implements the VodApi interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewVodApiProtobufClient(addr string, client HTTPClient) VodApi {
	prefix := urlBase(addr) + VodApiPathPrefix
	urls := [53]string{
		prefix + "CreateUpload",
		prefix + "CreateArchive",
		prefix + "InternalCreateHighlight",
		prefix + "ManagerCreateHighlight",
		prefix + "PublicGetVodByID",
		prefix + "InternalGetVodByID",
		prefix + "ManagerInternalGetVodByID",
		prefix + "ManagerGetVodMuteInfo",
		prefix + "InternalGetVodMuteInfo",
		prefix + "ManagerGetVodMuteInfos",
		prefix + "GetVodByIDIncludeBannedUsers",
		prefix + "ManagerGetVodByID",
		prefix + "ManagerSearchVods",
		prefix + "PublicGetVodsByUser",
		prefix + "ManagerInternalGetVodsByUser",
		prefix + "ManagerGetVodsByUserIncludeBannedUsers",
		prefix + "InternalGetVodsByBroadcastIDs",
		prefix + "PublicGetVodsByIDs",
		prefix + "InternalGetVodsByIDs",
		prefix + "InternalGetPrivateVodsByIDs",
		prefix + "InternalGetPrivateAndDeletedVodsByIDs",
		prefix + "GetVodsByIDsIncludeBannedUsers",
		prefix + "PublicGetVodsByUsers",
		prefix + "GetTopVods",
		prefix + "ManagerUpdateVod",
		prefix + "UndeleteVods",
		prefix + "SoftDeleteVods",
		prefix + "InternalVodRemoveRecords",
		prefix + "HardDeleteVods",
		prefix + "SoftDeleteVodsInInterval",
		prefix + "ManagerSoftDeleteVods",
		prefix + "YoutubeExport",
		prefix + "FinalizeUpload",
		prefix + "UpdateManifest",
		prefix + "SetViewcounts",
		prefix + "GetPublicVodAggregationsByIDs",
		prefix + "GetVodPopularity",
		prefix + "CreateError",
		prefix + "CreateThumbnails",
		prefix + "ManagerCreateCustomThumbnailUploadRequest",
		prefix + "ManagerDeleteThumbnails",
		prefix + "DeleteThumbnails",
		prefix + "ManagerGetUserVodProperties",
		prefix + "ManagerUpdateUserVodProperties",
		prefix + "ManagerGetUserVideoPrivacyProperties",
		prefix + "ManagerUpdateUserVideoPrivacyProperties",
		prefix + "ManagerCreateVodAppeals",
		prefix + "GetVodAppeals",
		prefix + "ResolveTrackAppeal",
		prefix + "ResolveVodAppeal",
		prefix + "CreateAudibleMagicResponses",
		prefix + "GetAudibleMagicResponses",
		prefix + "UpdateAudibleMagicResponses",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &vodApiProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &vodApiProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *vodApiProtobufClient) CreateUpload(ctx context.Context, in *CreateUploadRequest) (*CreateUploadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "CreateUpload")
	out := new(CreateUploadResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) CreateArchive(ctx context.Context, in *CreateArchiveRequest) (*CreateArchiveResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "CreateArchive")
	out := new(CreateArchiveResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) InternalCreateHighlight(ctx context.Context, in *InternalCreateHighlightRequest) (*InternalCreateHighlightResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalCreateHighlight")
	out := new(InternalCreateHighlightResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerCreateHighlight(ctx context.Context, in *ManagerCreateHighlightRequest) (*ManagerCreateHighlightResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateHighlight")
	out := new(ManagerCreateHighlightResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) PublicGetVodByID(ctx context.Context, in *PublicGetVodByIDRequest) (*PublicGetVodByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodByID")
	out := new(PublicGetVodByIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) InternalGetVodByID(ctx context.Context, in *InternalGetVodByIDRequest) (*InternalGetVodByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodByID")
	out := new(InternalGetVodByIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerInternalGetVodByID(ctx context.Context, in *ManagerInternalGetVodByIDRequest) (*ManagerInternalGetVodByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerInternalGetVodByID")
	out := new(ManagerInternalGetVodByIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerGetVodMuteInfo(ctx context.Context, in *ManagerGetVodMuteInfoRequest) (*ManagerGetVodMuteInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodMuteInfo")
	out := new(ManagerGetVodMuteInfoResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) InternalGetVodMuteInfo(ctx context.Context, in *InternalGetVodMuteInfoRequest) (*InternalGetVodMuteInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodMuteInfo")
	out := new(InternalGetVodMuteInfoResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerGetVodMuteInfos(ctx context.Context, in *ManagerGetVodMuteInfosRequest) (*ManagerGetVodMuteInfosResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodMuteInfos")
	out := new(ManagerGetVodMuteInfosResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) GetVodByIDIncludeBannedUsers(ctx context.Context, in *GetVodByIDIncludeBannedUsersRequest) (*GetVodByIDIncludeBannedUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetVodByIDIncludeBannedUsers")
	out := new(GetVodByIDIncludeBannedUsersResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerGetVodByID(ctx context.Context, in *ManagerGetVodByIDRequest) (*ManagerGetVodByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodByID")
	out := new(ManagerGetVodByIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerSearchVods(ctx context.Context, in *ManagerSearchVodsRequest) (*ManagerSearchVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerSearchVods")
	out := new(ManagerSearchVodsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) PublicGetVodsByUser(ctx context.Context, in *PublicGetVodsByUserRequest) (*PublicGetVodsByUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByUser")
	out := new(PublicGetVodsByUserResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerInternalGetVodsByUser(ctx context.Context, in *ManagerInternalGetVodsByUserRequest) (*ManagerInternalGetVodsByUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerInternalGetVodsByUser")
	out := new(ManagerInternalGetVodsByUserResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerGetVodsByUserIncludeBannedUsers(ctx context.Context, in *ManagerGetVodsByUserIncludeBannedUsersRequest) (*ManagerGetVodsByUserIncludeBannedUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodsByUserIncludeBannedUsers")
	out := new(ManagerGetVodsByUserIncludeBannedUsersResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) InternalGetVodsByBroadcastIDs(ctx context.Context, in *InternalGetVodsByBroadcastIDsRequest) (*InternalGetVodsByBroadcastIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodsByBroadcastIDs")
	out := new(InternalGetVodsByBroadcastIDsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) PublicGetVodsByIDs(ctx context.Context, in *PublicGetVodsByIDsRequest) (*PublicGetVodsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByIDs")
	out := new(PublicGetVodsByIDsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) InternalGetVodsByIDs(ctx context.Context, in *InternalGetVodsByIDsRequest) (*InternalGetVodsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodsByIDs")
	out := new(InternalGetVodsByIDsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) InternalGetPrivateVodsByIDs(ctx context.Context, in *InternalGetPrivateVodsByIDsRequest) (*InternalGetPrivateVodsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetPrivateVodsByIDs")
	out := new(InternalGetPrivateVodsByIDsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) InternalGetPrivateAndDeletedVodsByIDs(ctx context.Context, in *InternalGetPrivateAndDeletedVodsByIDsRequest) (*InternalGetPrivateAndDeletedVodsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetPrivateAndDeletedVodsByIDs")
	out := new(InternalGetPrivateAndDeletedVodsByIDsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) GetVodsByIDsIncludeBannedUsers(ctx context.Context, in *GetVodsByIDsIncludeBannedUsersRequest) (*GetVodsByIDsIncludeBannedUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetVodsByIDsIncludeBannedUsers")
	out := new(GetVodsByIDsIncludeBannedUsersResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[21], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) PublicGetVodsByUsers(ctx context.Context, in *PublicGetVodsByUsersRequest) (*PublicGetVodsByUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByUsers")
	out := new(PublicGetVodsByUsersResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[22], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) GetTopVods(ctx context.Context, in *GetTopVodsRequest) (*GetTopVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetTopVods")
	out := new(GetTopVodsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[23], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerUpdateVod(ctx context.Context, in *ManagerUpdateVodRequest) (*ManagerUpdateVodResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateVod")
	out := new(ManagerUpdateVodResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[24], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) UndeleteVods(ctx context.Context, in *UndeleteVodsRequest) (*UndeleteVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "UndeleteVods")
	out := new(UndeleteVodsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[25], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) SoftDeleteVods(ctx context.Context, in *SoftDeleteVodsRequest) (*SoftDeleteVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "SoftDeleteVods")
	out := new(SoftDeleteVodsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[26], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) InternalVodRemoveRecords(ctx context.Context, in *InternalVodRemoveRecordsRequest) (*InternalVodRemoveRecordsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalVodRemoveRecords")
	out := new(InternalVodRemoveRecordsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[27], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) HardDeleteVods(ctx context.Context, in *HardDeleteVodsRequest) (*HardDeleteVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteVods")
	out := new(HardDeleteVodsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[28], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) SoftDeleteVodsInInterval(ctx context.Context, in *SoftDeleteVodsInIntervalRequest) (*SoftDeleteVodsInIntervalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "SoftDeleteVodsInInterval")
	out := new(SoftDeleteVodsInIntervalResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[29], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerSoftDeleteVods(ctx context.Context, in *ManagerSoftDeleteVodsRequest) (*ManagerSoftDeleteVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerSoftDeleteVods")
	out := new(ManagerSoftDeleteVodsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[30], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) YoutubeExport(ctx context.Context, in *YoutubeExportRequest) (*YoutubeExportResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "YoutubeExport")
	out := new(YoutubeExportResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[31], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) FinalizeUpload(ctx context.Context, in *FinalizeUploadRequest) (*FinalizeUploadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "FinalizeUpload")
	out := new(FinalizeUploadResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[32], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) UpdateManifest(ctx context.Context, in *UpdateManifestRequest) (*UpdateManifestResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateManifest")
	out := new(UpdateManifestResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[33], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) SetViewcounts(ctx context.Context, in *SetViewcountsRequest) (*SetViewcountsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "SetViewcounts")
	out := new(SetViewcountsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[34], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) GetPublicVodAggregationsByIDs(ctx context.Context, in *GetPublicVodAggregationsByIDsRequest) (*PublicVodAggregationsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetPublicVodAggregationsByIDs")
	out := new(PublicVodAggregationsByIDsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[35], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) GetVodPopularity(ctx context.Context, in *GetVodPopularityRequest) (*VodPopularityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetVodPopularity")
	out := new(VodPopularityResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[36], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) CreateError(ctx context.Context, in *CreateErrorRequest) (*CreateErrorResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "CreateError")
	out := new(CreateErrorResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[37], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) CreateThumbnails(ctx context.Context, in *CreateThumbnailsRequest) (*CreateThumbnailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "CreateThumbnails")
	out := new(CreateThumbnailsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[38], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerCreateCustomThumbnailUploadRequest(ctx context.Context, in *ManagerCreateCustomThumbnailUploadRequestRequest) (*CreateCustomThumbnailUploadRequestResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateCustomThumbnailUploadRequest")
	out := new(CreateCustomThumbnailUploadRequestResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[39], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerDeleteThumbnails(ctx context.Context, in *ManagerDeleteThumbnailsRequest) (*ManagerDeleteThumbnailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerDeleteThumbnails")
	out := new(ManagerDeleteThumbnailsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[40], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) DeleteThumbnails(ctx context.Context, in *DeleteThumbnailsRequest) (*DeleteThumbnailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteThumbnails")
	out := new(DeleteThumbnailsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[41], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerGetUserVodProperties(ctx context.Context, in *ManagerGetUserVodPropertiesRequest) (*UserVodPropertiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetUserVodProperties")
	out := new(UserVodPropertiesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[42], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerUpdateUserVodProperties(ctx context.Context, in *ManagerUpdateUserVodPropertiesRequest) (*UserVodPropertiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateUserVodProperties")
	out := new(UserVodPropertiesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[43], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerGetUserVideoPrivacyProperties(ctx context.Context, in *ManagerGetUserVideoPrivacyPropertiesRequest) (*UserVideoPrivacyPropertiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetUserVideoPrivacyProperties")
	out := new(UserVideoPrivacyPropertiesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[44], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerUpdateUserVideoPrivacyProperties(ctx context.Context, in *ManagerUpdateUserVideoPrivacyPropertiesRequest) (*UserVideoPrivacyPropertiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateUserVideoPrivacyProperties")
	out := new(UserVideoPrivacyPropertiesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[45], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ManagerCreateVodAppeals(ctx context.Context, in *ManagerCreateVodAppealsRequest) (*CreateVodAppealsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateVodAppeals")
	out := new(CreateVodAppealsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[46], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) GetVodAppeals(ctx context.Context, in *GetVodAppealsRequest) (*VodAppealsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetVodAppeals")
	out := new(VodAppealsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[47], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ResolveTrackAppeal(ctx context.Context, in *ResolveTrackAppealRequest) (*ResolveTrackAppealResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ResolveTrackAppeal")
	out := new(ResolveTrackAppealResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[48], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) ResolveVodAppeal(ctx context.Context, in *ResolveVodAppealRequest) (*ResolveVodAppealResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ResolveVodAppeal")
	out := new(ResolveVodAppealResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[49], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) CreateAudibleMagicResponses(ctx context.Context, in *CreateAudibleMagicResponsesRequest) (*AudibleMagicResponsesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAudibleMagicResponses")
	out := new(AudibleMagicResponsesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[50], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) GetAudibleMagicResponses(ctx context.Context, in *GetAudibleMagicResponsesRequest) (*AudibleMagicResponsesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetAudibleMagicResponses")
	out := new(AudibleMagicResponsesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[51], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiProtobufClient) UpdateAudibleMagicResponses(ctx context.Context, in *UpdateAudibleMagicResponsesRequest) (*AudibleMagicResponsesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAudibleMagicResponses")
	out := new(AudibleMagicResponsesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[52], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ==================
// VodApi JSON Client
// ==================

type vodApiJSONClient struct {
	client HTTPClient
	urls   [53]string
}

// NewVodApiJSONClient creates a JSON client that implements the VodApi interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewVodApiJSONClient(addr string, client HTTPClient) VodApi {
	prefix := urlBase(addr) + VodApiPathPrefix
	urls := [53]string{
		prefix + "CreateUpload",
		prefix + "CreateArchive",
		prefix + "InternalCreateHighlight",
		prefix + "ManagerCreateHighlight",
		prefix + "PublicGetVodByID",
		prefix + "InternalGetVodByID",
		prefix + "ManagerInternalGetVodByID",
		prefix + "ManagerGetVodMuteInfo",
		prefix + "InternalGetVodMuteInfo",
		prefix + "ManagerGetVodMuteInfos",
		prefix + "GetVodByIDIncludeBannedUsers",
		prefix + "ManagerGetVodByID",
		prefix + "ManagerSearchVods",
		prefix + "PublicGetVodsByUser",
		prefix + "ManagerInternalGetVodsByUser",
		prefix + "ManagerGetVodsByUserIncludeBannedUsers",
		prefix + "InternalGetVodsByBroadcastIDs",
		prefix + "PublicGetVodsByIDs",
		prefix + "InternalGetVodsByIDs",
		prefix + "InternalGetPrivateVodsByIDs",
		prefix + "InternalGetPrivateAndDeletedVodsByIDs",
		prefix + "GetVodsByIDsIncludeBannedUsers",
		prefix + "PublicGetVodsByUsers",
		prefix + "GetTopVods",
		prefix + "ManagerUpdateVod",
		prefix + "UndeleteVods",
		prefix + "SoftDeleteVods",
		prefix + "InternalVodRemoveRecords",
		prefix + "HardDeleteVods",
		prefix + "SoftDeleteVodsInInterval",
		prefix + "ManagerSoftDeleteVods",
		prefix + "YoutubeExport",
		prefix + "FinalizeUpload",
		prefix + "UpdateManifest",
		prefix + "SetViewcounts",
		prefix + "GetPublicVodAggregationsByIDs",
		prefix + "GetVodPopularity",
		prefix + "CreateError",
		prefix + "CreateThumbnails",
		prefix + "ManagerCreateCustomThumbnailUploadRequest",
		prefix + "ManagerDeleteThumbnails",
		prefix + "DeleteThumbnails",
		prefix + "ManagerGetUserVodProperties",
		prefix + "ManagerUpdateUserVodProperties",
		prefix + "ManagerGetUserVideoPrivacyProperties",
		prefix + "ManagerUpdateUserVideoPrivacyProperties",
		prefix + "ManagerCreateVodAppeals",
		prefix + "GetVodAppeals",
		prefix + "ResolveTrackAppeal",
		prefix + "ResolveVodAppeal",
		prefix + "CreateAudibleMagicResponses",
		prefix + "GetAudibleMagicResponses",
		prefix + "UpdateAudibleMagicResponses",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &vodApiJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &vodApiJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *vodApiJSONClient) CreateUpload(ctx context.Context, in *CreateUploadRequest) (*CreateUploadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "CreateUpload")
	out := new(CreateUploadResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) CreateArchive(ctx context.Context, in *CreateArchiveRequest) (*CreateArchiveResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "CreateArchive")
	out := new(CreateArchiveResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) InternalCreateHighlight(ctx context.Context, in *InternalCreateHighlightRequest) (*InternalCreateHighlightResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalCreateHighlight")
	out := new(InternalCreateHighlightResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerCreateHighlight(ctx context.Context, in *ManagerCreateHighlightRequest) (*ManagerCreateHighlightResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateHighlight")
	out := new(ManagerCreateHighlightResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) PublicGetVodByID(ctx context.Context, in *PublicGetVodByIDRequest) (*PublicGetVodByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodByID")
	out := new(PublicGetVodByIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) InternalGetVodByID(ctx context.Context, in *InternalGetVodByIDRequest) (*InternalGetVodByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodByID")
	out := new(InternalGetVodByIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerInternalGetVodByID(ctx context.Context, in *ManagerInternalGetVodByIDRequest) (*ManagerInternalGetVodByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerInternalGetVodByID")
	out := new(ManagerInternalGetVodByIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerGetVodMuteInfo(ctx context.Context, in *ManagerGetVodMuteInfoRequest) (*ManagerGetVodMuteInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodMuteInfo")
	out := new(ManagerGetVodMuteInfoResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) InternalGetVodMuteInfo(ctx context.Context, in *InternalGetVodMuteInfoRequest) (*InternalGetVodMuteInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodMuteInfo")
	out := new(InternalGetVodMuteInfoResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerGetVodMuteInfos(ctx context.Context, in *ManagerGetVodMuteInfosRequest) (*ManagerGetVodMuteInfosResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodMuteInfos")
	out := new(ManagerGetVodMuteInfosResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) GetVodByIDIncludeBannedUsers(ctx context.Context, in *GetVodByIDIncludeBannedUsersRequest) (*GetVodByIDIncludeBannedUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetVodByIDIncludeBannedUsers")
	out := new(GetVodByIDIncludeBannedUsersResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerGetVodByID(ctx context.Context, in *ManagerGetVodByIDRequest) (*ManagerGetVodByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodByID")
	out := new(ManagerGetVodByIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerSearchVods(ctx context.Context, in *ManagerSearchVodsRequest) (*ManagerSearchVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerSearchVods")
	out := new(ManagerSearchVodsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) PublicGetVodsByUser(ctx context.Context, in *PublicGetVodsByUserRequest) (*PublicGetVodsByUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByUser")
	out := new(PublicGetVodsByUserResponse)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerInternalGetVodsByUser(ctx context.Context, in *ManagerInternalGetVodsByUserRequest) (*ManagerInternalGetVodsByUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerInternalGetVodsByUser")
	out := new(ManagerInternalGetVodsByUserResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerGetVodsByUserIncludeBannedUsers(ctx context.Context, in *ManagerGetVodsByUserIncludeBannedUsersRequest) (*ManagerGetVodsByUserIncludeBannedUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodsByUserIncludeBannedUsers")
	out := new(ManagerGetVodsByUserIncludeBannedUsersResponse)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) InternalGetVodsByBroadcastIDs(ctx context.Context, in *InternalGetVodsByBroadcastIDsRequest) (*InternalGetVodsByBroadcastIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodsByBroadcastIDs")
	out := new(InternalGetVodsByBroadcastIDsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) PublicGetVodsByIDs(ctx context.Context, in *PublicGetVodsByIDsRequest) (*PublicGetVodsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByIDs")
	out := new(PublicGetVodsByIDsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) InternalGetVodsByIDs(ctx context.Context, in *InternalGetVodsByIDsRequest) (*InternalGetVodsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodsByIDs")
	out := new(InternalGetVodsByIDsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) InternalGetPrivateVodsByIDs(ctx context.Context, in *InternalGetPrivateVodsByIDsRequest) (*InternalGetPrivateVodsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetPrivateVodsByIDs")
	out := new(InternalGetPrivateVodsByIDsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) InternalGetPrivateAndDeletedVodsByIDs(ctx context.Context, in *InternalGetPrivateAndDeletedVodsByIDsRequest) (*InternalGetPrivateAndDeletedVodsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetPrivateAndDeletedVodsByIDs")
	out := new(InternalGetPrivateAndDeletedVodsByIDsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) GetVodsByIDsIncludeBannedUsers(ctx context.Context, in *GetVodsByIDsIncludeBannedUsersRequest) (*GetVodsByIDsIncludeBannedUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetVodsByIDsIncludeBannedUsers")
	out := new(GetVodsByIDsIncludeBannedUsersResponse)
	err := doJSONRequest(ctx, c.client, c.urls[21], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) PublicGetVodsByUsers(ctx context.Context, in *PublicGetVodsByUsersRequest) (*PublicGetVodsByUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByUsers")
	out := new(PublicGetVodsByUsersResponse)
	err := doJSONRequest(ctx, c.client, c.urls[22], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) GetTopVods(ctx context.Context, in *GetTopVodsRequest) (*GetTopVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetTopVods")
	out := new(GetTopVodsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[23], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerUpdateVod(ctx context.Context, in *ManagerUpdateVodRequest) (*ManagerUpdateVodResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateVod")
	out := new(ManagerUpdateVodResponse)
	err := doJSONRequest(ctx, c.client, c.urls[24], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) UndeleteVods(ctx context.Context, in *UndeleteVodsRequest) (*UndeleteVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "UndeleteVods")
	out := new(UndeleteVodsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[25], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) SoftDeleteVods(ctx context.Context, in *SoftDeleteVodsRequest) (*SoftDeleteVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "SoftDeleteVods")
	out := new(SoftDeleteVodsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[26], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) InternalVodRemoveRecords(ctx context.Context, in *InternalVodRemoveRecordsRequest) (*InternalVodRemoveRecordsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "InternalVodRemoveRecords")
	out := new(InternalVodRemoveRecordsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[27], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) HardDeleteVods(ctx context.Context, in *HardDeleteVodsRequest) (*HardDeleteVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteVods")
	out := new(HardDeleteVodsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[28], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) SoftDeleteVodsInInterval(ctx context.Context, in *SoftDeleteVodsInIntervalRequest) (*SoftDeleteVodsInIntervalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "SoftDeleteVodsInInterval")
	out := new(SoftDeleteVodsInIntervalResponse)
	err := doJSONRequest(ctx, c.client, c.urls[29], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerSoftDeleteVods(ctx context.Context, in *ManagerSoftDeleteVodsRequest) (*ManagerSoftDeleteVodsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerSoftDeleteVods")
	out := new(ManagerSoftDeleteVodsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[30], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) YoutubeExport(ctx context.Context, in *YoutubeExportRequest) (*YoutubeExportResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "YoutubeExport")
	out := new(YoutubeExportResponse)
	err := doJSONRequest(ctx, c.client, c.urls[31], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) FinalizeUpload(ctx context.Context, in *FinalizeUploadRequest) (*FinalizeUploadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "FinalizeUpload")
	out := new(FinalizeUploadResponse)
	err := doJSONRequest(ctx, c.client, c.urls[32], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) UpdateManifest(ctx context.Context, in *UpdateManifestRequest) (*UpdateManifestResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateManifest")
	out := new(UpdateManifestResponse)
	err := doJSONRequest(ctx, c.client, c.urls[33], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) SetViewcounts(ctx context.Context, in *SetViewcountsRequest) (*SetViewcountsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "SetViewcounts")
	out := new(SetViewcountsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[34], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) GetPublicVodAggregationsByIDs(ctx context.Context, in *GetPublicVodAggregationsByIDsRequest) (*PublicVodAggregationsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetPublicVodAggregationsByIDs")
	out := new(PublicVodAggregationsByIDsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[35], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) GetVodPopularity(ctx context.Context, in *GetVodPopularityRequest) (*VodPopularityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetVodPopularity")
	out := new(VodPopularityResponse)
	err := doJSONRequest(ctx, c.client, c.urls[36], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) CreateError(ctx context.Context, in *CreateErrorRequest) (*CreateErrorResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "CreateError")
	out := new(CreateErrorResponse)
	err := doJSONRequest(ctx, c.client, c.urls[37], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) CreateThumbnails(ctx context.Context, in *CreateThumbnailsRequest) (*CreateThumbnailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "CreateThumbnails")
	out := new(CreateThumbnailsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[38], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerCreateCustomThumbnailUploadRequest(ctx context.Context, in *ManagerCreateCustomThumbnailUploadRequestRequest) (*CreateCustomThumbnailUploadRequestResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateCustomThumbnailUploadRequest")
	out := new(CreateCustomThumbnailUploadRequestResponse)
	err := doJSONRequest(ctx, c.client, c.urls[39], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerDeleteThumbnails(ctx context.Context, in *ManagerDeleteThumbnailsRequest) (*ManagerDeleteThumbnailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerDeleteThumbnails")
	out := new(ManagerDeleteThumbnailsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[40], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) DeleteThumbnails(ctx context.Context, in *DeleteThumbnailsRequest) (*DeleteThumbnailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteThumbnails")
	out := new(DeleteThumbnailsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[41], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerGetUserVodProperties(ctx context.Context, in *ManagerGetUserVodPropertiesRequest) (*UserVodPropertiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetUserVodProperties")
	out := new(UserVodPropertiesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[42], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerUpdateUserVodProperties(ctx context.Context, in *ManagerUpdateUserVodPropertiesRequest) (*UserVodPropertiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateUserVodProperties")
	out := new(UserVodPropertiesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[43], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerGetUserVideoPrivacyProperties(ctx context.Context, in *ManagerGetUserVideoPrivacyPropertiesRequest) (*UserVideoPrivacyPropertiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetUserVideoPrivacyProperties")
	out := new(UserVideoPrivacyPropertiesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[44], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerUpdateUserVideoPrivacyProperties(ctx context.Context, in *ManagerUpdateUserVideoPrivacyPropertiesRequest) (*UserVideoPrivacyPropertiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateUserVideoPrivacyProperties")
	out := new(UserVideoPrivacyPropertiesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[45], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ManagerCreateVodAppeals(ctx context.Context, in *ManagerCreateVodAppealsRequest) (*CreateVodAppealsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateVodAppeals")
	out := new(CreateVodAppealsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[46], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) GetVodAppeals(ctx context.Context, in *GetVodAppealsRequest) (*VodAppealsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetVodAppeals")
	out := new(VodAppealsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[47], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ResolveTrackAppeal(ctx context.Context, in *ResolveTrackAppealRequest) (*ResolveTrackAppealResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ResolveTrackAppeal")
	out := new(ResolveTrackAppealResponse)
	err := doJSONRequest(ctx, c.client, c.urls[48], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) ResolveVodAppeal(ctx context.Context, in *ResolveVodAppealRequest) (*ResolveVodAppealResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "ResolveVodAppeal")
	out := new(ResolveVodAppealResponse)
	err := doJSONRequest(ctx, c.client, c.urls[49], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) CreateAudibleMagicResponses(ctx context.Context, in *CreateAudibleMagicResponsesRequest) (*AudibleMagicResponsesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAudibleMagicResponses")
	out := new(AudibleMagicResponsesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[50], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) GetAudibleMagicResponses(ctx context.Context, in *GetAudibleMagicResponsesRequest) (*AudibleMagicResponsesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "GetAudibleMagicResponses")
	out := new(AudibleMagicResponsesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[51], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vodApiJSONClient) UpdateAudibleMagicResponses(ctx context.Context, in *UpdateAudibleMagicResponsesRequest) (*AudibleMagicResponsesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAudibleMagicResponses")
	out := new(AudibleMagicResponsesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[52], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =====================
// VodApi Server Handler
// =====================

type vodApiServer struct {
	VodApi
	hooks *twirp.ServerHooks
}

func NewVodApiServer(svc VodApi, hooks *twirp.ServerHooks) TwirpServer {
	return &vodApiServer{
		VodApi: svc,
		hooks:  hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *vodApiServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// VodApiPathPrefix is used for all URL paths on a twirp VodApi server.
// Requests are always: POST VodApiPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const VodApiPathPrefix = "/twirp/vodapi.VodApi/"

func (s *vodApiServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "vodapi")
	ctx = ctxsetters.WithServiceName(ctx, "VodApi")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/vodapi.VodApi/CreateUpload":
		s.serveCreateUpload(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/CreateArchive":
		s.serveCreateArchive(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/InternalCreateHighlight":
		s.serveInternalCreateHighlight(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerCreateHighlight":
		s.serveManagerCreateHighlight(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/PublicGetVodByID":
		s.servePublicGetVodByID(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/InternalGetVodByID":
		s.serveInternalGetVodByID(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerInternalGetVodByID":
		s.serveManagerInternalGetVodByID(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerGetVodMuteInfo":
		s.serveManagerGetVodMuteInfo(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/InternalGetVodMuteInfo":
		s.serveInternalGetVodMuteInfo(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerGetVodMuteInfos":
		s.serveManagerGetVodMuteInfos(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/GetVodByIDIncludeBannedUsers":
		s.serveGetVodByIDIncludeBannedUsers(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerGetVodByID":
		s.serveManagerGetVodByID(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerSearchVods":
		s.serveManagerSearchVods(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/PublicGetVodsByUser":
		s.servePublicGetVodsByUser(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerInternalGetVodsByUser":
		s.serveManagerInternalGetVodsByUser(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerGetVodsByUserIncludeBannedUsers":
		s.serveManagerGetVodsByUserIncludeBannedUsers(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/InternalGetVodsByBroadcastIDs":
		s.serveInternalGetVodsByBroadcastIDs(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/PublicGetVodsByIDs":
		s.servePublicGetVodsByIDs(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/InternalGetVodsByIDs":
		s.serveInternalGetVodsByIDs(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/InternalGetPrivateVodsByIDs":
		s.serveInternalGetPrivateVodsByIDs(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/InternalGetPrivateAndDeletedVodsByIDs":
		s.serveInternalGetPrivateAndDeletedVodsByIDs(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/GetVodsByIDsIncludeBannedUsers":
		s.serveGetVodsByIDsIncludeBannedUsers(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/PublicGetVodsByUsers":
		s.servePublicGetVodsByUsers(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/GetTopVods":
		s.serveGetTopVods(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerUpdateVod":
		s.serveManagerUpdateVod(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/UndeleteVods":
		s.serveUndeleteVods(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/SoftDeleteVods":
		s.serveSoftDeleteVods(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/InternalVodRemoveRecords":
		s.serveInternalVodRemoveRecords(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/HardDeleteVods":
		s.serveHardDeleteVods(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/SoftDeleteVodsInInterval":
		s.serveSoftDeleteVodsInInterval(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerSoftDeleteVods":
		s.serveManagerSoftDeleteVods(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/YoutubeExport":
		s.serveYoutubeExport(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/FinalizeUpload":
		s.serveFinalizeUpload(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/UpdateManifest":
		s.serveUpdateManifest(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/SetViewcounts":
		s.serveSetViewcounts(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/GetPublicVodAggregationsByIDs":
		s.serveGetPublicVodAggregationsByIDs(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/GetVodPopularity":
		s.serveGetVodPopularity(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/CreateError":
		s.serveCreateError(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/CreateThumbnails":
		s.serveCreateThumbnails(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerCreateCustomThumbnailUploadRequest":
		s.serveManagerCreateCustomThumbnailUploadRequest(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerDeleteThumbnails":
		s.serveManagerDeleteThumbnails(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/DeleteThumbnails":
		s.serveDeleteThumbnails(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerGetUserVodProperties":
		s.serveManagerGetUserVodProperties(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerUpdateUserVodProperties":
		s.serveManagerUpdateUserVodProperties(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerGetUserVideoPrivacyProperties":
		s.serveManagerGetUserVideoPrivacyProperties(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerUpdateUserVideoPrivacyProperties":
		s.serveManagerUpdateUserVideoPrivacyProperties(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ManagerCreateVodAppeals":
		s.serveManagerCreateVodAppeals(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/GetVodAppeals":
		s.serveGetVodAppeals(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ResolveTrackAppeal":
		s.serveResolveTrackAppeal(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/ResolveVodAppeal":
		s.serveResolveVodAppeal(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/CreateAudibleMagicResponses":
		s.serveCreateAudibleMagicResponses(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/GetAudibleMagicResponses":
		s.serveGetAudibleMagicResponses(ctx, resp, req)
		return
	case "/twirp/vodapi.VodApi/UpdateAudibleMagicResponses":
		s.serveUpdateAudibleMagicResponses(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *vodApiServer) serveCreateUpload(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateUploadJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateUploadProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveCreateUploadJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateUpload")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateUploadRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateUploadResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.CreateUpload(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateUploadResponse and nil error while calling CreateUpload. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveCreateUploadProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateUpload")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateUploadRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateUploadResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.CreateUpload(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateUploadResponse and nil error while calling CreateUpload. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveCreateArchive(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateArchiveJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateArchiveProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveCreateArchiveJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateArchive")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateArchiveRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateArchiveResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.CreateArchive(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateArchiveResponse and nil error while calling CreateArchive. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveCreateArchiveProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateArchive")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateArchiveRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateArchiveResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.CreateArchive(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateArchiveResponse and nil error while calling CreateArchive. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalCreateHighlight(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveInternalCreateHighlightJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInternalCreateHighlightProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveInternalCreateHighlightJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalCreateHighlight")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(InternalCreateHighlightRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalCreateHighlightResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalCreateHighlight(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalCreateHighlightResponse and nil error while calling InternalCreateHighlight. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalCreateHighlightProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalCreateHighlight")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InternalCreateHighlightRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalCreateHighlightResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalCreateHighlight(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalCreateHighlightResponse and nil error while calling InternalCreateHighlight. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerCreateHighlight(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerCreateHighlightJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerCreateHighlightProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerCreateHighlightJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateHighlight")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerCreateHighlightRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerCreateHighlightResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerCreateHighlight(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerCreateHighlightResponse and nil error while calling ManagerCreateHighlight. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerCreateHighlightProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateHighlight")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerCreateHighlightRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerCreateHighlightResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerCreateHighlight(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerCreateHighlightResponse and nil error while calling ManagerCreateHighlight. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) servePublicGetVodByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePublicGetVodByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePublicGetVodByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) servePublicGetVodByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PublicGetVodByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PublicGetVodByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.PublicGetVodByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublicGetVodByIDResponse and nil error while calling PublicGetVodByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) servePublicGetVodByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(PublicGetVodByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PublicGetVodByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.PublicGetVodByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublicGetVodByIDResponse and nil error while calling PublicGetVodByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetVodByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveInternalGetVodByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInternalGetVodByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveInternalGetVodByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(InternalGetVodByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetVodByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetVodByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetVodByIDResponse and nil error while calling InternalGetVodByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetVodByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InternalGetVodByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetVodByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetVodByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetVodByIDResponse and nil error while calling InternalGetVodByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerInternalGetVodByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerInternalGetVodByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerInternalGetVodByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerInternalGetVodByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerInternalGetVodByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerInternalGetVodByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerInternalGetVodByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerInternalGetVodByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerInternalGetVodByIDResponse and nil error while calling ManagerInternalGetVodByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerInternalGetVodByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerInternalGetVodByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerInternalGetVodByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerInternalGetVodByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerInternalGetVodByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerInternalGetVodByIDResponse and nil error while calling ManagerInternalGetVodByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetVodMuteInfo(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerGetVodMuteInfoJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerGetVodMuteInfoProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerGetVodMuteInfoJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodMuteInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerGetVodMuteInfoRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerGetVodMuteInfoResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetVodMuteInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerGetVodMuteInfoResponse and nil error while calling ManagerGetVodMuteInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetVodMuteInfoProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodMuteInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerGetVodMuteInfoRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerGetVodMuteInfoResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetVodMuteInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerGetVodMuteInfoResponse and nil error while calling ManagerGetVodMuteInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetVodMuteInfo(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveInternalGetVodMuteInfoJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInternalGetVodMuteInfoProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveInternalGetVodMuteInfoJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodMuteInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(InternalGetVodMuteInfoRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetVodMuteInfoResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetVodMuteInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetVodMuteInfoResponse and nil error while calling InternalGetVodMuteInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetVodMuteInfoProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodMuteInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InternalGetVodMuteInfoRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetVodMuteInfoResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetVodMuteInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetVodMuteInfoResponse and nil error while calling InternalGetVodMuteInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetVodMuteInfos(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerGetVodMuteInfosJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerGetVodMuteInfosProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerGetVodMuteInfosJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodMuteInfos")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerGetVodMuteInfosRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerGetVodMuteInfosResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetVodMuteInfos(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerGetVodMuteInfosResponse and nil error while calling ManagerGetVodMuteInfos. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetVodMuteInfosProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodMuteInfos")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerGetVodMuteInfosRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerGetVodMuteInfosResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetVodMuteInfos(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerGetVodMuteInfosResponse and nil error while calling ManagerGetVodMuteInfos. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetVodByIDIncludeBannedUsers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetVodByIDIncludeBannedUsersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetVodByIDIncludeBannedUsersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveGetVodByIDIncludeBannedUsersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetVodByIDIncludeBannedUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetVodByIDIncludeBannedUsersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetVodByIDIncludeBannedUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetVodByIDIncludeBannedUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetVodByIDIncludeBannedUsersResponse and nil error while calling GetVodByIDIncludeBannedUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetVodByIDIncludeBannedUsersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetVodByIDIncludeBannedUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetVodByIDIncludeBannedUsersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetVodByIDIncludeBannedUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetVodByIDIncludeBannedUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetVodByIDIncludeBannedUsersResponse and nil error while calling GetVodByIDIncludeBannedUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetVodByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerGetVodByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerGetVodByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerGetVodByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerGetVodByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerGetVodByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetVodByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerGetVodByIDResponse and nil error while calling ManagerGetVodByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetVodByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerGetVodByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerGetVodByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetVodByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerGetVodByIDResponse and nil error while calling ManagerGetVodByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerSearchVods(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerSearchVodsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerSearchVodsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerSearchVodsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerSearchVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerSearchVodsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerSearchVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerSearchVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerSearchVodsResponse and nil error while calling ManagerSearchVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerSearchVodsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerSearchVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerSearchVodsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerSearchVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerSearchVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerSearchVodsResponse and nil error while calling ManagerSearchVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) servePublicGetVodsByUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePublicGetVodsByUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePublicGetVodsByUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) servePublicGetVodsByUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PublicGetVodsByUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PublicGetVodsByUserResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.PublicGetVodsByUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublicGetVodsByUserResponse and nil error while calling PublicGetVodsByUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) servePublicGetVodsByUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(PublicGetVodsByUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PublicGetVodsByUserResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.PublicGetVodsByUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublicGetVodsByUserResponse and nil error while calling PublicGetVodsByUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerInternalGetVodsByUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerInternalGetVodsByUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerInternalGetVodsByUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerInternalGetVodsByUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerInternalGetVodsByUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerInternalGetVodsByUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerInternalGetVodsByUserResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerInternalGetVodsByUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerInternalGetVodsByUserResponse and nil error while calling ManagerInternalGetVodsByUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerInternalGetVodsByUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerInternalGetVodsByUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerInternalGetVodsByUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerInternalGetVodsByUserResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerInternalGetVodsByUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerInternalGetVodsByUserResponse and nil error while calling ManagerInternalGetVodsByUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetVodsByUserIncludeBannedUsers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerGetVodsByUserIncludeBannedUsersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerGetVodsByUserIncludeBannedUsersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerGetVodsByUserIncludeBannedUsersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodsByUserIncludeBannedUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerGetVodsByUserIncludeBannedUsersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerGetVodsByUserIncludeBannedUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetVodsByUserIncludeBannedUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerGetVodsByUserIncludeBannedUsersResponse and nil error while calling ManagerGetVodsByUserIncludeBannedUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetVodsByUserIncludeBannedUsersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetVodsByUserIncludeBannedUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerGetVodsByUserIncludeBannedUsersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerGetVodsByUserIncludeBannedUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetVodsByUserIncludeBannedUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerGetVodsByUserIncludeBannedUsersResponse and nil error while calling ManagerGetVodsByUserIncludeBannedUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetVodsByBroadcastIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveInternalGetVodsByBroadcastIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInternalGetVodsByBroadcastIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveInternalGetVodsByBroadcastIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodsByBroadcastIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(InternalGetVodsByBroadcastIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetVodsByBroadcastIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetVodsByBroadcastIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetVodsByBroadcastIDsResponse and nil error while calling InternalGetVodsByBroadcastIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetVodsByBroadcastIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodsByBroadcastIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InternalGetVodsByBroadcastIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetVodsByBroadcastIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetVodsByBroadcastIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetVodsByBroadcastIDsResponse and nil error while calling InternalGetVodsByBroadcastIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) servePublicGetVodsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePublicGetVodsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePublicGetVodsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) servePublicGetVodsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PublicGetVodsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PublicGetVodsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.PublicGetVodsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublicGetVodsByIDsResponse and nil error while calling PublicGetVodsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) servePublicGetVodsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(PublicGetVodsByIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PublicGetVodsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.PublicGetVodsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublicGetVodsByIDsResponse and nil error while calling PublicGetVodsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetVodsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveInternalGetVodsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInternalGetVodsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveInternalGetVodsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(InternalGetVodsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetVodsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetVodsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetVodsByIDsResponse and nil error while calling InternalGetVodsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetVodsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetVodsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InternalGetVodsByIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetVodsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetVodsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetVodsByIDsResponse and nil error while calling InternalGetVodsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetPrivateVodsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveInternalGetPrivateVodsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInternalGetPrivateVodsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveInternalGetPrivateVodsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetPrivateVodsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(InternalGetPrivateVodsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetPrivateVodsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetPrivateVodsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetPrivateVodsByIDsResponse and nil error while calling InternalGetPrivateVodsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetPrivateVodsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetPrivateVodsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InternalGetPrivateVodsByIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetPrivateVodsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetPrivateVodsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetPrivateVodsByIDsResponse and nil error while calling InternalGetPrivateVodsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetPrivateAndDeletedVodsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveInternalGetPrivateAndDeletedVodsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInternalGetPrivateAndDeletedVodsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveInternalGetPrivateAndDeletedVodsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetPrivateAndDeletedVodsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(InternalGetPrivateAndDeletedVodsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetPrivateAndDeletedVodsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetPrivateAndDeletedVodsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetPrivateAndDeletedVodsByIDsResponse and nil error while calling InternalGetPrivateAndDeletedVodsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalGetPrivateAndDeletedVodsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalGetPrivateAndDeletedVodsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InternalGetPrivateAndDeletedVodsByIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalGetPrivateAndDeletedVodsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalGetPrivateAndDeletedVodsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalGetPrivateAndDeletedVodsByIDsResponse and nil error while calling InternalGetPrivateAndDeletedVodsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetVodsByIDsIncludeBannedUsers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetVodsByIDsIncludeBannedUsersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetVodsByIDsIncludeBannedUsersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveGetVodsByIDsIncludeBannedUsersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetVodsByIDsIncludeBannedUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetVodsByIDsIncludeBannedUsersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetVodsByIDsIncludeBannedUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetVodsByIDsIncludeBannedUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetVodsByIDsIncludeBannedUsersResponse and nil error while calling GetVodsByIDsIncludeBannedUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetVodsByIDsIncludeBannedUsersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetVodsByIDsIncludeBannedUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetVodsByIDsIncludeBannedUsersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetVodsByIDsIncludeBannedUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetVodsByIDsIncludeBannedUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetVodsByIDsIncludeBannedUsersResponse and nil error while calling GetVodsByIDsIncludeBannedUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) servePublicGetVodsByUsers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePublicGetVodsByUsersJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePublicGetVodsByUsersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) servePublicGetVodsByUsersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PublicGetVodsByUsersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PublicGetVodsByUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.PublicGetVodsByUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublicGetVodsByUsersResponse and nil error while calling PublicGetVodsByUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) servePublicGetVodsByUsersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublicGetVodsByUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(PublicGetVodsByUsersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PublicGetVodsByUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.PublicGetVodsByUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublicGetVodsByUsersResponse and nil error while calling PublicGetVodsByUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetTopVods(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTopVodsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTopVodsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveGetTopVodsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTopVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTopVodsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTopVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetTopVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTopVodsResponse and nil error while calling GetTopVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetTopVodsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTopVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetTopVodsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTopVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetTopVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTopVodsResponse and nil error while calling GetTopVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerUpdateVod(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerUpdateVodJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerUpdateVodProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerUpdateVodJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateVod")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerUpdateVodRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerUpdateVodResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerUpdateVod(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerUpdateVodResponse and nil error while calling ManagerUpdateVod. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerUpdateVodProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateVod")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerUpdateVodRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerUpdateVodResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerUpdateVod(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerUpdateVodResponse and nil error while calling ManagerUpdateVod. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveUndeleteVods(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUndeleteVodsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUndeleteVodsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveUndeleteVodsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UndeleteVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UndeleteVodsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UndeleteVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.UndeleteVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UndeleteVodsResponse and nil error while calling UndeleteVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveUndeleteVodsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UndeleteVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UndeleteVodsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UndeleteVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.UndeleteVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UndeleteVodsResponse and nil error while calling UndeleteVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveSoftDeleteVods(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSoftDeleteVodsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSoftDeleteVodsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveSoftDeleteVodsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SoftDeleteVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SoftDeleteVodsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SoftDeleteVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.SoftDeleteVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SoftDeleteVodsResponse and nil error while calling SoftDeleteVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveSoftDeleteVodsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SoftDeleteVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SoftDeleteVodsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SoftDeleteVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.SoftDeleteVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SoftDeleteVodsResponse and nil error while calling SoftDeleteVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalVodRemoveRecords(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveInternalVodRemoveRecordsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInternalVodRemoveRecordsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveInternalVodRemoveRecordsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalVodRemoveRecords")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(InternalVodRemoveRecordsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalVodRemoveRecordsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalVodRemoveRecords(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalVodRemoveRecordsResponse and nil error while calling InternalVodRemoveRecords. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveInternalVodRemoveRecordsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalVodRemoveRecords")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InternalVodRemoveRecordsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InternalVodRemoveRecordsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.InternalVodRemoveRecords(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalVodRemoveRecordsResponse and nil error while calling InternalVodRemoveRecords. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveHardDeleteVods(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHardDeleteVodsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHardDeleteVodsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveHardDeleteVodsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HardDeleteVodsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HardDeleteVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.HardDeleteVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HardDeleteVodsResponse and nil error while calling HardDeleteVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveHardDeleteVodsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HardDeleteVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HardDeleteVodsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HardDeleteVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.HardDeleteVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HardDeleteVodsResponse and nil error while calling HardDeleteVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveSoftDeleteVodsInInterval(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSoftDeleteVodsInIntervalJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSoftDeleteVodsInIntervalProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveSoftDeleteVodsInIntervalJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SoftDeleteVodsInInterval")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SoftDeleteVodsInIntervalRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SoftDeleteVodsInIntervalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.SoftDeleteVodsInInterval(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SoftDeleteVodsInIntervalResponse and nil error while calling SoftDeleteVodsInInterval. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveSoftDeleteVodsInIntervalProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SoftDeleteVodsInInterval")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SoftDeleteVodsInIntervalRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SoftDeleteVodsInIntervalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.SoftDeleteVodsInInterval(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SoftDeleteVodsInIntervalResponse and nil error while calling SoftDeleteVodsInInterval. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerSoftDeleteVods(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerSoftDeleteVodsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerSoftDeleteVodsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerSoftDeleteVodsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerSoftDeleteVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerSoftDeleteVodsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerSoftDeleteVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerSoftDeleteVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerSoftDeleteVodsResponse and nil error while calling ManagerSoftDeleteVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerSoftDeleteVodsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerSoftDeleteVods")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerSoftDeleteVodsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerSoftDeleteVodsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerSoftDeleteVods(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerSoftDeleteVodsResponse and nil error while calling ManagerSoftDeleteVods. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveYoutubeExport(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveYoutubeExportJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveYoutubeExportProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveYoutubeExportJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "YoutubeExport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(YoutubeExportRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *YoutubeExportResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.YoutubeExport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *YoutubeExportResponse and nil error while calling YoutubeExport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveYoutubeExportProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "YoutubeExport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(YoutubeExportRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *YoutubeExportResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.YoutubeExport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *YoutubeExportResponse and nil error while calling YoutubeExport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveFinalizeUpload(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFinalizeUploadJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFinalizeUploadProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveFinalizeUploadJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FinalizeUpload")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FinalizeUploadRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FinalizeUploadResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.FinalizeUpload(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FinalizeUploadResponse and nil error while calling FinalizeUpload. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveFinalizeUploadProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FinalizeUpload")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FinalizeUploadRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FinalizeUploadResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.FinalizeUpload(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FinalizeUploadResponse and nil error while calling FinalizeUpload. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveUpdateManifest(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateManifestJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateManifestProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveUpdateManifestJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateManifest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateManifestRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateManifestResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.UpdateManifest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateManifestResponse and nil error while calling UpdateManifest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveUpdateManifestProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateManifest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateManifestRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateManifestResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.UpdateManifest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateManifestResponse and nil error while calling UpdateManifest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveSetViewcounts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetViewcountsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetViewcountsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveSetViewcountsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetViewcounts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetViewcountsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetViewcountsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.SetViewcounts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetViewcountsResponse and nil error while calling SetViewcounts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveSetViewcountsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetViewcounts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetViewcountsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetViewcountsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.SetViewcounts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetViewcountsResponse and nil error while calling SetViewcounts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetPublicVodAggregationsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPublicVodAggregationsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPublicVodAggregationsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveGetPublicVodAggregationsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPublicVodAggregationsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPublicVodAggregationsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PublicVodAggregationsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetPublicVodAggregationsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublicVodAggregationsByIDsResponse and nil error while calling GetPublicVodAggregationsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetPublicVodAggregationsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPublicVodAggregationsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPublicVodAggregationsByIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PublicVodAggregationsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetPublicVodAggregationsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublicVodAggregationsByIDsResponse and nil error while calling GetPublicVodAggregationsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetVodPopularity(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetVodPopularityJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetVodPopularityProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveGetVodPopularityJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetVodPopularity")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetVodPopularityRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *VodPopularityResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetVodPopularity(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VodPopularityResponse and nil error while calling GetVodPopularity. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetVodPopularityProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetVodPopularity")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetVodPopularityRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *VodPopularityResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetVodPopularity(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VodPopularityResponse and nil error while calling GetVodPopularity. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveCreateError(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateErrorJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateErrorProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveCreateErrorJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateError")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateErrorRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateErrorResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.CreateError(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateErrorResponse and nil error while calling CreateError. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveCreateErrorProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateError")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateErrorRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateErrorResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.CreateError(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateErrorResponse and nil error while calling CreateError. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveCreateThumbnails(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateThumbnailsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateThumbnailsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveCreateThumbnailsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateThumbnails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateThumbnailsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateThumbnailsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.CreateThumbnails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateThumbnailsResponse and nil error while calling CreateThumbnails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveCreateThumbnailsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateThumbnails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateThumbnailsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateThumbnailsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.CreateThumbnails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateThumbnailsResponse and nil error while calling CreateThumbnails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerCreateCustomThumbnailUploadRequest(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerCreateCustomThumbnailUploadRequestJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerCreateCustomThumbnailUploadRequestProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerCreateCustomThumbnailUploadRequestJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateCustomThumbnailUploadRequest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerCreateCustomThumbnailUploadRequestRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateCustomThumbnailUploadRequestResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerCreateCustomThumbnailUploadRequest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCustomThumbnailUploadRequestResponse and nil error while calling ManagerCreateCustomThumbnailUploadRequest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerCreateCustomThumbnailUploadRequestProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateCustomThumbnailUploadRequest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerCreateCustomThumbnailUploadRequestRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateCustomThumbnailUploadRequestResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerCreateCustomThumbnailUploadRequest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCustomThumbnailUploadRequestResponse and nil error while calling ManagerCreateCustomThumbnailUploadRequest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerDeleteThumbnails(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerDeleteThumbnailsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerDeleteThumbnailsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerDeleteThumbnailsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerDeleteThumbnails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerDeleteThumbnailsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerDeleteThumbnailsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerDeleteThumbnails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerDeleteThumbnailsResponse and nil error while calling ManagerDeleteThumbnails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerDeleteThumbnailsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerDeleteThumbnails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerDeleteThumbnailsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerDeleteThumbnailsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerDeleteThumbnails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerDeleteThumbnailsResponse and nil error while calling ManagerDeleteThumbnails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveDeleteThumbnails(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteThumbnailsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteThumbnailsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveDeleteThumbnailsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteThumbnails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteThumbnailsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteThumbnailsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.DeleteThumbnails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteThumbnailsResponse and nil error while calling DeleteThumbnails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveDeleteThumbnailsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteThumbnails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteThumbnailsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteThumbnailsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.DeleteThumbnails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteThumbnailsResponse and nil error while calling DeleteThumbnails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetUserVodProperties(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerGetUserVodPropertiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerGetUserVodPropertiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerGetUserVodPropertiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetUserVodProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerGetUserVodPropertiesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UserVodPropertiesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetUserVodProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserVodPropertiesResponse and nil error while calling ManagerGetUserVodProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetUserVodPropertiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetUserVodProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerGetUserVodPropertiesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UserVodPropertiesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetUserVodProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserVodPropertiesResponse and nil error while calling ManagerGetUserVodProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerUpdateUserVodProperties(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerUpdateUserVodPropertiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerUpdateUserVodPropertiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerUpdateUserVodPropertiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateUserVodProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerUpdateUserVodPropertiesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UserVodPropertiesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerUpdateUserVodProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserVodPropertiesResponse and nil error while calling ManagerUpdateUserVodProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerUpdateUserVodPropertiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateUserVodProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerUpdateUserVodPropertiesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UserVodPropertiesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerUpdateUserVodProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserVodPropertiesResponse and nil error while calling ManagerUpdateUserVodProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetUserVideoPrivacyProperties(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerGetUserVideoPrivacyPropertiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerGetUserVideoPrivacyPropertiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerGetUserVideoPrivacyPropertiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetUserVideoPrivacyProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerGetUserVideoPrivacyPropertiesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UserVideoPrivacyPropertiesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetUserVideoPrivacyProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserVideoPrivacyPropertiesResponse and nil error while calling ManagerGetUserVideoPrivacyProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerGetUserVideoPrivacyPropertiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerGetUserVideoPrivacyProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerGetUserVideoPrivacyPropertiesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UserVideoPrivacyPropertiesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerGetUserVideoPrivacyProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserVideoPrivacyPropertiesResponse and nil error while calling ManagerGetUserVideoPrivacyProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerUpdateUserVideoPrivacyProperties(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerUpdateUserVideoPrivacyPropertiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerUpdateUserVideoPrivacyPropertiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerUpdateUserVideoPrivacyPropertiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateUserVideoPrivacyProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerUpdateUserVideoPrivacyPropertiesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UserVideoPrivacyPropertiesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerUpdateUserVideoPrivacyProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserVideoPrivacyPropertiesResponse and nil error while calling ManagerUpdateUserVideoPrivacyProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerUpdateUserVideoPrivacyPropertiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerUpdateUserVideoPrivacyProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerUpdateUserVideoPrivacyPropertiesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UserVideoPrivacyPropertiesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerUpdateUserVideoPrivacyProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserVideoPrivacyPropertiesResponse and nil error while calling ManagerUpdateUserVideoPrivacyProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerCreateVodAppeals(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveManagerCreateVodAppealsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveManagerCreateVodAppealsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveManagerCreateVodAppealsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateVodAppeals")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ManagerCreateVodAppealsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateVodAppealsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerCreateVodAppeals(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateVodAppealsResponse and nil error while calling ManagerCreateVodAppeals. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveManagerCreateVodAppealsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ManagerCreateVodAppeals")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ManagerCreateVodAppealsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateVodAppealsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ManagerCreateVodAppeals(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateVodAppealsResponse and nil error while calling ManagerCreateVodAppeals. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetVodAppeals(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetVodAppealsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetVodAppealsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveGetVodAppealsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetVodAppeals")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetVodAppealsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *VodAppealsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetVodAppeals(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VodAppealsResponse and nil error while calling GetVodAppeals. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetVodAppealsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetVodAppeals")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetVodAppealsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *VodAppealsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetVodAppeals(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VodAppealsResponse and nil error while calling GetVodAppeals. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveResolveTrackAppeal(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveResolveTrackAppealJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveResolveTrackAppealProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveResolveTrackAppealJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResolveTrackAppeal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ResolveTrackAppealRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResolveTrackAppealResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ResolveTrackAppeal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResolveTrackAppealResponse and nil error while calling ResolveTrackAppeal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveResolveTrackAppealProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResolveTrackAppeal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ResolveTrackAppealRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResolveTrackAppealResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ResolveTrackAppeal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResolveTrackAppealResponse and nil error while calling ResolveTrackAppeal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveResolveVodAppeal(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveResolveVodAppealJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveResolveVodAppealProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveResolveVodAppealJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResolveVodAppeal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ResolveVodAppealRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResolveVodAppealResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ResolveVodAppeal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResolveVodAppealResponse and nil error while calling ResolveVodAppeal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveResolveVodAppealProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResolveVodAppeal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ResolveVodAppealRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResolveVodAppealResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.ResolveVodAppeal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResolveVodAppealResponse and nil error while calling ResolveVodAppeal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveCreateAudibleMagicResponses(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateAudibleMagicResponsesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateAudibleMagicResponsesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveCreateAudibleMagicResponsesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAudibleMagicResponses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateAudibleMagicResponsesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AudibleMagicResponsesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.CreateAudibleMagicResponses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AudibleMagicResponsesResponse and nil error while calling CreateAudibleMagicResponses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveCreateAudibleMagicResponsesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAudibleMagicResponses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateAudibleMagicResponsesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AudibleMagicResponsesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.CreateAudibleMagicResponses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AudibleMagicResponsesResponse and nil error while calling CreateAudibleMagicResponses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetAudibleMagicResponses(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAudibleMagicResponsesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAudibleMagicResponsesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveGetAudibleMagicResponsesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAudibleMagicResponses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAudibleMagicResponsesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AudibleMagicResponsesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetAudibleMagicResponses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AudibleMagicResponsesResponse and nil error while calling GetAudibleMagicResponses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveGetAudibleMagicResponsesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAudibleMagicResponses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAudibleMagicResponsesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AudibleMagicResponsesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.GetAudibleMagicResponses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AudibleMagicResponsesResponse and nil error while calling GetAudibleMagicResponses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveUpdateAudibleMagicResponses(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateAudibleMagicResponsesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateAudibleMagicResponsesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *vodApiServer) serveUpdateAudibleMagicResponsesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAudibleMagicResponses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateAudibleMagicResponsesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AudibleMagicResponsesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.UpdateAudibleMagicResponses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AudibleMagicResponsesResponse and nil error while calling UpdateAudibleMagicResponses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) serveUpdateAudibleMagicResponsesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAudibleMagicResponses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateAudibleMagicResponsesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AudibleMagicResponsesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.VodApi.UpdateAudibleMagicResponses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AudibleMagicResponsesResponse and nil error while calling UpdateAudibleMagicResponses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *vodApiServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *vodApiServer) ProtocGenTwirpVersion() string {
	return "v5.4.2"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.4.2")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1195 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x5b, 0x6f, 0x1c, 0x35,
	0x14, 0x66, 0x5f, 0x2a, 0x64, 0x9a, 0x52, 0x86, 0x5b, 0xbb, 0x9b, 0x84, 0x24, 0xcd, 0xa5, 0x6d,
	0x2e, 0x0f, 0x2d, 0xad, 0x78, 0x4d, 0x9a, 0x90, 0xac, 0xaa, 0xa0, 0xd0, 0x5c, 0x10, 0x95, 0x2a,
	0xe1, 0x9d, 0x71, 0x76, 0x2d, 0x26, 0xe3, 0xc1, 0xf6, 0x2c, 0x0d, 0x48, 0x48, 0x3c, 0xf2, 0xc4,
	0x1b, 0x12, 0x82, 0x1f, 0x8b, 0x76, 0x66, 0xec, 0x39, 0xbe, 0xcd, 0x6e, 0x44, 0x1f, 0xd7, 0xdf,
	0xe7, 0xef, 0x3b, 0xc7, 0x97, 0xb3, 0xc7, 0x83, 0xe6, 0x04, 0xe1, 0x63, 0x1a, 0x93, 0x9d, 0x9c,
	0x33, 0xc9, 0xa2, 0x5b, 0x63, 0x96, 0xe0, 0x9c, 0x76, 0x3f, 0xe4, 0x44, 0xe4, 0x2c, 0x13, 0x44,
	0x54, 0x40, 0xf7, 0x0e, 0x27, 0x3f, 0x15, 0x44, 0xc8, 0xfa, 0xf7, 0x93, 0x7f, 0x37, 0xd1, 0xad,
	0x0b, 0x96, 0xec, 0xe6, 0x34, 0x7a, 0x89, 0x6e, 0xbf, 0xe0, 0x04, 0x4b, 0x72, 0x9e, 0xa7, 0x0c,
	0x27, 0x51, 0x6f, 0xa7, 0x12, 0xd9, 0x81, 0xa3, 0xaf, 0xaa, 0xe9, 0xdd, 0x79, 0x3f, 0x58, 0x99,
	0xad, 0xbc, 0x17, 0x7d, 0x83, 0xe6, 0x2a, 0x64, 0x97, 0xc7, 0x23, 0x3a, 0x26, 0x91, 0x35, 0xa1,
	0x1e, 0x56, 0x72, 0x0b, 0x01, 0x54, 0xeb, 0xa5, 0xe8, 0xf3, 0x7e, 0x26, 0x09, 0xcf, 0x70, 0x5a,
	0x51, 0x8e, 0xe8, 0x70, 0x94, 0xd2, 0xe1, 0x48, 0x46, 0xeb, 0x6a, 0x6e, 0x80, 0xa0, 0x3c, 0x36,
	0xa6, 0xf2, 0xb4, 0x1b, 0x45, 0x9f, 0x1d, 0xe3, 0x0c, 0x0f, 0x09, 0xb7, 0xcd, 0xd6, 0x94, 0x88,
	0x1f, 0x57, 0x5e, 0xeb, 0xd3, 0x68, 0xda, 0xea, 0x3b, 0x74, 0xf7, 0xa4, 0x18, 0xa4, 0x34, 0x3e,
	0x24, 0xf2, 0x82, 0x25, 0x7b, 0xd7, 0xfd, 0xfd, 0xe8, 0x0b, 0x35, 0xdb, 0x46, 0x94, 0xfc, 0x52,
	0x98, 0xa0, 0x85, 0xdf, 0xa0, 0x48, 0x25, 0x0a, 0xa4, 0x97, 0xed, 0x45, 0x70, 0xc5, 0x57, 0xda,
	0x28, 0x5a, 0x9e, 0xa3, 0xfb, 0x75, 0x6e, 0x1e, 0x97, 0x87, 0x56, 0xfa, 0x61, 0xb3, 0x47, 0x33,
	0x30, 0xb5, 0xe7, 0x25, 0xfa, 0xb4, 0xa6, 0x55, 0xf0, 0x71, 0x21, 0x49, 0x3f, 0xbb, 0x64, 0xd1,
	0xaa, 0xa5, 0x62, 0xc2, 0xca, 0x6b, 0x6d, 0x0a, 0x0b, 0x6e, 0xbf, 0x19, 0x87, 0x36, 0x5a, 0xf3,
	0xaf, 0x8d, 0xed, 0xb4, 0x3e, 0x8d, 0xe6, 0x39, 0x69, 0x26, 0x45, 0x44, 0xed, 0xd1, 0x8a, 0xd0,
	0x49, 0x73, 0x68, 0xda, 0xea, 0x57, 0x34, 0xdf, 0xac, 0x6a, 0x3f, 0x8b, 0xd3, 0x22, 0x21, 0x7b,
	0x38, 0xcb, 0x48, 0x72, 0x2e, 0x08, 0x17, 0xd1, 0xa6, 0x52, 0x6a, 0x63, 0x29, 0xdb, 0xad, 0xd9,
	0xc8, 0xda, 0xfc, 0x35, 0xfa, 0xc8, 0x08, 0xb0, 0x3c, 0x26, 0x4b, 0xde, 0xd8, 0xe1, 0xf1, 0x58,
	0x6e, 0x61, 0x78, 0xb4, 0x4f, 0x09, 0xe6, 0xf1, 0xe8, 0x82, 0x25, 0xc2, 0xd1, 0x6e, 0xa0, 0x90,
	0x36, 0x64, 0x68, 0xed, 0x1f, 0xd0, 0xc7, 0xf0, 0x8e, 0x89, 0xbd, 0xeb, 0x49, 0x66, 0xd1, 0x8a,
	0xef, 0x02, 0xd6, 0xa0, 0xd2, 0x7f, 0xd0, 0xca, 0x81, 0xdb, 0xe2, 0x3d, 0xfb, 0xca, 0x6a, 0xb3,
	0xf5, 0x86, 0x58, 0x9e, 0x5b, 0xb3, 0x91, 0xb5, 0xf9, 0xdf, 0x1d, 0xb4, 0x6e, 0x2c, 0x6d, 0x4d,
	0xf1, 0x1c, 0x8f, 0x67, 0xde, 0xad, 0x08, 0xf2, 0x55, 0x44, 0xcf, 0x6f, 0x3a, 0x4d, 0xc7, 0xf6,
	0x1b, 0x5a, 0x70, 0xc2, 0xdf, 0xe3, 0x0c, 0x27, 0x31, 0x16, 0xb2, 0xbf, 0x2f, 0xa2, 0x2d, 0xff,
	0x2d, 0xb3, 0x68, 0x2a, 0x90, 0xed, 0x19, 0xd9, 0xb0, 0x80, 0x5a, 0x3b, 0x37, 0x31, 0x5d, 0x0e,
	0xec, 0x2a, 0x70, 0x5a, 0x69, 0xa3, 0x68, 0xf9, 0x18, 0x7d, 0xe2, 0x44, 0x32, 0x31, 0x78, 0x10,
	0x8c, 0x13, 0x58, 0xac, 0xb6, 0x93, 0xb4, 0xc9, 0x5b, 0xd4, 0x03, 0x8c, 0x13, 0x4e, 0xc7, 0x58,
	0x92, 0xc6, 0xeb, 0xb1, 0x47, 0xc6, 0x26, 0x29, 0xcb, 0xcd, 0x99, 0xb8, 0xda, 0xf9, 0xaf, 0x0e,
	0x5a, 0x73, 0x99, 0xbb, 0x59, 0xb2, 0x4f, 0x52, 0x22, 0x49, 0xd2, 0x04, 0xf1, 0x65, 0x58, 0xd8,
	0x43, 0x57, 0xe1, 0x3c, 0xbb, 0xe1, 0x2c, 0x1d, 0xd8, 0xef, 0x1d, 0xb4, 0x08, 0x57, 0xcb, 0x73,
	0xd4, 0xb7, 0xcd, 0xe2, 0x16, 0xe2, 0xa9, 0x50, 0x76, 0x66, 0xa5, 0xc3, 0xbd, 0xf7, 0x14, 0x05,
	0xb0, 0xf7, 0x3e, 0xd4, 0xd9, 0x7b, 0x3f, 0x49, 0x9b, 0x1c, 0x20, 0x74, 0x48, 0xe4, 0x19, 0xcb,
	0xcb, 0x7a, 0x78, 0x1f, 0x04, 0x59, 0x8f, 0x29, 0xc1, 0xae, 0x0f, 0x82, 0x0d, 0x4a, 0x7d, 0x75,
	0xcf, 0xf3, 0xa4, 0xda, 0xec, 0xa6, 0x41, 0xb1, 0x11, 0xa7, 0x41, 0x71, 0x09, 0x5a, 0xf8, 0x25,
	0xba, 0x7d, 0x9e, 0x25, 0xe5, 0x46, 0x95, 0x11, 0xea, 0x7e, 0x13, 0x8e, 0x3a, 0xfd, 0xa6, 0x09,
	0x6a, 0xb1, 0x6f, 0xd1, 0x9d, 0x53, 0x76, 0x29, 0xf7, 0x1b, 0x39, 0xdd, 0x52, 0x9a, 0xe3, 0x4a,
	0x70, 0x31, 0x04, 0x6b, 0x49, 0x86, 0xee, 0xa9, 0xb3, 0x55, 0x06, 0x7e, 0xc5, 0x26, 0x1d, 0x69,
	0xcc, 0x78, 0x22, 0x22, 0xa7, 0x97, 0xb4, 0x19, 0xca, 0xe6, 0xe1, 0x74, 0x22, 0xcc, 0xe1, 0x08,
	0xf3, 0xc4, 0x97, 0x83, 0x39, 0xee, 0xe4, 0x60, 0xc3, 0x30, 0x07, 0x33, 0xbf, 0x7e, 0x56, 0x06,
	0x32, 0xc6, 0x69, 0x93, 0x43, 0x88, 0xe1, 0xe4, 0x10, 0x26, 0x7a, 0x5a, 0x34, 0x6b, 0x3b, 0xec,
	0x16, 0xcd, 0xbf, 0x2b, 0x6b, 0x53, 0x58, 0xf0, 0x7d, 0xf1, 0x3d, 0x2b, 0x64, 0x31, 0x20, 0x07,
	0x6f, 0x73, 0xc6, 0x65, 0xf3, 0xbe, 0x30, 0x86, 0x9d, 0xf7, 0x85, 0x85, 0xc2, 0xb5, 0xff, 0x9a,
	0x66, 0x38, 0xa5, 0xbf, 0xa8, 0xe7, 0x8f, 0x9e, 0x62, 0x8e, 0x3b, 0x6b, 0x6f, 0xc3, 0x50, 0xb2,
	0x3a, 0xf6, 0xc7, 0x38, 0xa3, 0x97, 0x44, 0xc8, 0x46, 0xd2, 0x1c, 0x77, 0x24, 0x6d, 0x18, 0x66,
	0x7d, 0x4a, 0xe4, 0x05, 0x25, 0x3f, 0xc7, 0xac, 0xc8, 0xa4, 0x68, 0xb2, 0x36, 0x86, 0x9d, 0xac,
	0x2d, 0x14, 0xf4, 0x1e, 0x0b, 0x93, 0xb2, 0x59, 0xd6, 0x91, 0xc9, 0x2b, 0x70, 0x38, 0xe4, 0x64,
	0x88, 0x25, 0x65, 0x59, 0x5d, 0x9b, 0x61, 0x9b, 0x17, 0xa6, 0x29, 0xbf, 0xc7, 0x66, 0x65, 0xf2,
	0x53, 0xb5, 0xf9, 0x19, 0xba, 0x5b, 0xd5, 0xae, 0x13, 0x96, 0x17, 0x29, 0xe6, 0x54, 0x5e, 0x37,
	0x85, 0xc5, 0x46, 0x9c, 0x94, 0x2c, 0x54, 0xab, 0x1e, 0xa1, 0x0f, 0xaa, 0xc7, 0xd6, 0x01, 0xe7,
	0x8c, 0x47, 0x5d, 0xf3, 0x61, 0x59, 0x0e, 0x2a, 0xad, 0x9e, 0x17, 0x83, 0x85, 0xaf, 0x02, 0xce,
	0x46, 0xc5, 0xd5, 0x20, 0xc3, 0x34, 0x15, 0x4d, 0x7c, 0x36, 0xe2, 0x14, 0x3e, 0x97, 0xa0, 0x85,
	0xff, 0xe9, 0xa0, 0x47, 0xc6, 0xbb, 0xf0, 0x45, 0x21, 0x24, 0xbb, 0xd2, 0x5c, 0xe3, 0xa0, 0x45,
	0x5f, 0x79, 0x9f, 0x92, 0x6d, 0x53, 0x54, 0x2c, 0x4f, 0xcc, 0x58, 0xda, 0xa7, 0xc0, 0x97, 0x76,
	0xed, 0x54, 0x5d, 0x3c, 0x90, 0xbd, 0xfd, 0xd6, 0xb0, 0x09, 0xce, 0x4b, 0x3b, 0xc8, 0x83, 0x8b,
	0xec, 0xd8, 0xe8, 0x45, 0x0e, 0xe9, 0x2f, 0x85, 0x09, 0x5a, 0x38, 0x43, 0xbd, 0xa6, 0xe3, 0x9c,
	0xfc, 0x35, 0x4e, 0x0e, 0x0c, 0x67, 0x39, 0xe1, 0x92, 0x12, 0xd0, 0xf9, 0xb4, 0x90, 0x9c, 0x87,
	0x82, 0x87, 0xa1, 0xfd, 0x24, 0x5a, 0x34, 0xfe, 0xeb, 0x5c, 0xcb, 0x6d, 0xef, 0x7f, 0xe2, 0xff,
	0x73, 0xfd, 0xa3, 0x83, 0x56, 0xad, 0x0c, 0x68, 0x42, 0x58, 0xd9, 0x08, 0xc5, 0xd7, 0xc0, 0xfc,
	0x69, 0x20, 0x5f, 0x2f, 0xdb, 0xb9, 0xcf, 0x6d, 0x54, 0x1d, 0xcb, 0x9f, 0x1d, 0xb4, 0xe1, 0xa6,
	0xe6, 0x0f, 0xe7, 0x79, 0x78, 0x2d, 0xde, 0x61, 0x44, 0x44, 0x1f, 0xe5, 0xea, 0x06, 0x94, 0x1f,
	0xba, 0x72, 0x82, 0x3d, 0x47, 0xd9, 0x26, 0x04, 0xee, 0x33, 0x24, 0x80, 0x46, 0x66, 0xae, 0x2a,
	0x57, 0x4a, 0x7c, 0xde, 0xac, 0x62, 0x96, 0x64, 0x17, 0x94, 0x30, 0x57, 0xec, 0x0d, 0x8a, 0x5e,
	0x11, 0xc1, 0xd2, 0x31, 0x39, 0xe3, 0x38, 0xfe, 0xb1, 0x22, 0x34, 0xaf, 0x0e, 0x17, 0x73, 0x5e,
	0x1d, 0x3e, 0x0a, 0xbc, 0x6f, 0x35, 0xae, 0xdd, 0x9b, 0xfb, 0x66, 0x23, 0xce, 0x22, 0xb8, 0x04,
	0xf0, 0x3d, 0xa8, 0x57, 0x7f, 0xbb, 0x2b, 0x12, 0x3a, 0x48, 0xc9, 0x31, 0x1e, 0xd2, 0x58, 0xe1,
	0xe0, 0xbe, 0xb5, 0x90, 0x9c, 0x26, 0x20, 0xc0, 0x02, 0xa5, 0xea, 0xde, 0x21, 0x91, 0x7e, 0xc3,
	0x0d, 0xb0, 0x07, 0xef, 0xc6, 0x8d, 0xa3, 0x5e, 0x75, 0x4c, 0xa7, 0x64, 0xd8, 0x42, 0xba, 0xa9,
	0xe7, 0xde, 0xfb, 0xaf, 0xeb, 0x2f, 0xb9, 0x83, 0x5b, 0xe5, 0xf7, 0xda, 0xa7, 0xff, 0x05, 0x00,
	0x00, 0xff, 0xff, 0x8d, 0xf3, 0x90, 0x2a, 0xe9, 0x15, 0x00, 0x00,
}
