#!/bin/bash

DATA_DIR="data/"
TIME_LIMIT=90

echo "Please make sure you have connected our device and on the correct hotspot 'br'"
adb devices

DT=`date "+%Y-%m-%dT%H:%M:%S%z"`
read -p "Please provide a location: " LOCATION

DIR="${DATA_DIR}${DT}_${LOCATION}"

mkdir -p "${DIR}"

adb shell pm list packages > ${DIR}/installed_packages.txt

echo "saved installed packages":
echo ""

function recordApp {
    NAME=$1
    PKG=$2

    read -p "Ready to record ${NAME}? <enter>"
    echo "################################################################################"
    echo "# start now!                                                                    "
    echo "################################################################################"
    adb shell monkey -p ${PKG} 1
    FILENAME=${NAME}_${DT}.mp4
    adb shell screenrecord --time-limit ${TIME_LIMIT} /sdcard/${FILENAME}
    echo "saving ${DIR}/${FILENAME}"
    adb shell am force-stop ${PKG}

    adb pull /sdcard/${FILENAME} ${DIR}
    echo "saved saving ${DIR}/${FILENAME}"
}

recordApp "nimo" "com.huya.nimo"
recordApp "twitch" "tv.twitch.android.qa"
recordApp "youtube" "com.google.android.youtube"
