create external schema mgst_s3 
from data catalog 
database 'mgst_s3' 
iam_role 'arn:aws:iam::424255581144:role/esports-experience-tahoe-replica-s3-access'
create external database if not exists;

create external table mgst_s3.user_hw_total(
    user_id bigint,
    hours_watched float
)
stored as parquet
location 's3://rudolph-spark/user_hw_total/';

create external table mgst_s3.user_top_channel(
    user_id bigint,
    channel_id bigint,
    rank bigint,
    hours_watched float
)
stored as parquet
location 's3://rudolph-spark/user_top_channel/';

create external table mgst_s3.user_top_game(
    user_id bigint,
    game_name VARCHAR(255),
    rank bigint,
    hours_watched float
)
stored as parquet
location 's3://rudolph-spark/user_top_game/';

grant all on external schema mgst_s3 to mode_ro;
grant select on all tables in schema mgst_s3 to mode_ro;