provider "aws" {
  region = var.region
}

resource "aws_emr_security_configuration" "spark" {
  name = "emr-spark"

  configuration = <<EOF
{
  "AuthorizationConfiguration": {
    "EmrFsConfiguration": {
      "RoleMappings": [{
        "Role": "arn:aws:iam::331582574546:role/TahoeReadReplicaStopgap",
        "IdentifierType": "Prefix",
        "Identifiers": [ "s3://sheik-331582574546/" ]
      }, {
        "Role": "arn:aws:iam::424255581144:role/esports-experience-tahoe-replica-s3-access",
        "IdentifierType": "Prefix",
        "Identifiers": [ "s3://science-tahoe/" ]
      }]
    }
  }
}
EOF
}

resource "aws_emr_cluster" "cluster" {
  name          = "emr-spark"
  release_label = "emr-5.28.0"
  applications  = ["Spark"]

  termination_protection            = false
  keep_job_flow_alive_when_no_steps = true

  ec2_attributes {
    subnet_id                         = "subnet-08f4a6a3f6b358ff8"
    instance_profile                  = "arn:aws:iam::424255581144:instance-profile/esports-experience-tahoe-replica-s3-access"
    key_name                          = "twitch-mgst-tahoe-ssh"
  }

  master_instance_group {
    instance_type = "m5.2xlarge"
  }

  core_instance_group {
    instance_type  = "m5.2xlarge"
    instance_count = 30

    ebs_config {
      size                 = "256"
      type                 = "gp2"
      volumes_per_instance = 1
    }

    autoscaling_policy = <<EOF
{
"Constraints": {
  "MinCapacity": 10,
  "MaxCapacity": 100
},
"Rules": [
  {
    "Name": "ScaleOutMemoryPercentage",
    "Description": "Scale out if YARNMemoryAvailablePercentage is less than 15",
    "Action": {
      "SimpleScalingPolicyConfiguration": {
        "AdjustmentType": "CHANGE_IN_CAPACITY",
        "ScalingAdjustment": 5,
        "CoolDown": 120
      }
    },
    "Trigger": {
      "CloudWatchAlarmDefinition": {
        "ComparisonOperator": "LESS_THAN",
        "EvaluationPeriods": 1,
        "MetricName": "YARNMemoryAvailablePercentage",
        "Namespace": "AWS/ElasticMapReduce",
        "Period": 120,
        "Statistic": "AVERAGE",
        "Threshold": 15.0,
        "Unit": "PERCENT"
      }
    }
  }
]
}
EOF
  }

  ebs_root_volume_size = 100

  security_configuration = aws_emr_security_configuration.spark.name

  service_role     = "arn:aws:iam::424255581144:role/EMR_DefaultRole"
  autoscaling_role = "arn:aws:iam::424255581144:role/EMR_AutoScaling_DefaultRole"
}

output "master" {
  value = aws_emr_cluster.cluster.master_public_dns
}
