#!/bin/bash
set -e
set -x

SSH_PRIVATE_KEY=${SSH_PRIVATE_KEY:-~/.ssh/id_rsa}
JOB_NAME=stark
BEBO_ENV=local
DOCKER_UID=$(id -u docker)

cp ${SSH_PRIVATE_KEY} ./ssh_private_key

docker build --build-arg "DOCKER_UID=$DOCKER_UID" -t ${JOB_NAME}:${BEBO_ENV} --rm .

rm ./ssh_private_key

docker rm -f ${JOB_NAME} || true

docker ps | grep etcd || docker run --init -d --rm --network host -v /data/etcd:/data/etcd -e "ETCD_ADVERTISE_CLIENT_URLS=http://$(hostname).aws.bebo-dev.com:2379" -e "ETCD_LISTEN_CLIENT_URLS=http://0.0.0.0:2379" -e "ETCD_DATA_DIR=/data/etcd" --name etcd quay.io/coreos/etcd:v3.1

docker run -it --rm \
    --network="host" \
    --name ${JOB_NAME} \
    -e "BEBO_ENV=${BEBO_ENV}" \
    -v /srv/salt:/srv/salt \
    -v /etc/salt/pki/master:/etc/salt/pki/master \
    -v /etc/stark/salt/cache:/var/cachce/salt/master \
    -v /srv/secure-files:/srv/secure-files \
    -v /srv/pillar:/srv/pillar \
    -v /data/dispatcher:/data/dispatcher \
    -v /etc/salt/ssl:/etc/salt/ssl \
    --user $DOCKER_UID \
    ${JOB_NAME}:${BEBO_ENV}
