import botocore

from models import EC2Model
from starkutil import StarkStates

from logger import log

class ServerController:
    def __init__(self, clusters, ec2, etcd_api):
        self.update_clusters(clusters)
        self.ec2 = ec2
        self.etcd_api = etcd_api

    def update_clusters(self, clusters):
        self.cluster_names = [s.name for s in clusters]

    def update_state(self): #TODO use instance_ids instead of hostname for primary key
        """
        Retrieves the current state from AWS and etcd and updates the objects in etcd.
        """

        aws_instances = self.ec2._get_all_boxes()
        etcd_servers = EC2Model.get_all()
        etcd_hostnames = [model.hostname for model in etcd_servers]

        aws_instances_as_models = {}
        for instance in aws_instances:
            model = EC2Model.from_ec2_info(instance)
            if not model:
                self.cleanup_empty_hostname(instance)
                continue

            if self.is_valid_cluster(model.hostname):
                aws_instances_as_models[model.hostname] = model
                if model.hostname not in etcd_hostnames:
                    log.info('Adding {} as an EC2 state exist, but no ETCD state does -- {}'.format(model.hostname, model))
                    model.save()

        ec2_hostnames = [hostname for hostname in aws_instances_as_models]

        for etcd_server in etcd_servers:
            if etcd_server.hostname not in ec2_hostnames:
                if etcd_server.stark_state is StarkStates.CREATING:
                    continue
                log.warn('Server not in AWS -- removing {}'.format(etcd_server))
                etcd_server.delete(etcd_server.hostname) #confusing way to delete...

        for server in EC2Model.get_all(): #complete state
            if server.hostname in aws_instances_as_models:
                server.update_keys(aws_instances_as_models[server.hostname])
                server.update_health()
                server.update_resolved_ip()

    def is_valid_cluster(self, hostname):
        split_hostname = hostname.split("-")
        if len(split_hostname) > 1:
            cluster = split_hostname[1]
            if cluster in self.cluster_names:
                return True
        return False

    def cleanup_empty_hostname(self, aws_instance):
        try:
            self.ec2.destroy_instance(aws_instance['Instances'][0]['InstanceId'])
        except:
            log.exception("failed to cleanup_empty_hostname")
