import etcd
import json

from config import cfg
from logger import log

class EtcD:
    def __init__(self):
        self.etcd_host = cfg.ETCD_HOST
        self.etcd_port = cfg.ETCD_PORT
        log.info("etcd host {} port {}".format(self.etcd_host, self.etcd_port))
        self.client = etcd.Client(host=self.etcd_host, port=self.etcd_port)
        log.info("etcd successfully connected")

    def get(self, key, timeout=cfg.ETCD_TIMEOUT, default=None):
        try:
            return self.client.read(key, timeout=timeout).value
        except etcd.EtcdKeyNotFound:
            return default

    def get_json(self, key, timeout=cfg.ETCD_TIMEOUT, default=None):
        try:
            val = self.get(key, timeout=timeout, default=default)
            return json.loads(val)
        except:
            return {}

    def list(self, key, timeout=cfg.ETCD_TIMEOUT):
        try:
            return self.client.read(key, recursive=True, timeout=timeout).children
        except etcd.EtcdKeyNotFound:
            return None

    def set(self, key, value, ttl=None, timeout=cfg.ETCD_TIMEOUT):
        #  log.info("setting etcd key {}, value {}, ttl {}".format(key, value, ttl))
        try:
            self.client.write(key, value, ttl=ttl, timeout=timeout)
        except:
            log.exception("failed to write etcd key")

    def delete(self, key):
        try:
            log.debug('Deleting {}'.format(key))
            self.client.delete(key)
        except:
            log.exception("failed to delete etcd key")
