import boto3
import json
from config import Config

cfg = Config()

ssm = boto3.client("ssm", region_name="us-west-2")

def add_parameter_to_store(key):
    val = getattr(cfg, key)
    name = "/%s/%s/%s" % (cfg.BEBO_ENV, cfg.APP_NAME, key)
    stringified = json.dumps(val)
    print("%s: %s" % (name, stringified))

    ssm.put_parameter(
        Name=name,
        Value=stringified,
        Type="SecureString",
        Overwrite=True
    )



keys = [k  for k in dir(cfg) if not k.startswith("__")]

print(len(keys), "keys")

for key in keys:
    add_parameter_to_store(key)
