import { configure, addDecorator } from '@storybook/react';
import { withBackgrounds } from '@storybook/addon-backgrounds';
import { configureViewport } from '@storybook/addon-viewport';
import { withKnobs } from '@storybook/addon-knobs';
import theme from '../src/theme';

// css
import './style.scss';

addDecorator(withKnobs);

addDecorator(
  withBackgrounds([
    { name: 'Surface One', value: theme.colors.surfaceOne, default: true },
    { name: 'Surface Two', value: theme.colors.surfaceTwo, default: true },
    { name: 'facebook', value: '#3b5998' }
  ])
);

// automatically import all files ending in *.stories.js
const req = require.context('../src', true, /.stories.js$/);
function loadStories() {
  req.keys().forEach(filename => req(filename));
}

//

configure(loadStories, module);
