// you can use this file to add your custom webpack plugins, loaders and anything you like.
// This is just the basic way to add additional webpack configurations.
// For more information refer the docs: https://storybook.js.org/configurations/custom-webpack-config

// IMPORTANT
// When you add this file, we won't add the default configurations which is similar
// to "React Create App". This only has babel loader to load JavaScript.

const webpack = require('webpack');

const getClientEnvironment = require('../config/env');

// Export a function. Accept the base config as the only param.
module.exports = (storybookBaseConfig, configType) => {
  // configType has a value of 'DEVELOPMENT' or 'PRODUCTION'
  // You can change the configuration based on that.
  // 'PRODUCTION' is used when building the static version of storybook.

  // Make whatever fine-grained changes you need
  let config = null;
  if (configType === 'DEVELOPMENT') {
    config = require('../config/webpack.config.dev');
  } else {
    config = require('../config/webpack.config.prod');
  }

  const publicUrl = '';

  const env = getClientEnvironment(publicUrl);

  if (config && config.module) {
    storybookBaseConfig.module = config.module;
    storybookBaseConfig.plugins = [
      new webpack.DefinePlugin(env.stringified),
      ...storybookBaseConfig.plugins
    ];
  }

  // Return the altered config
  return storybookBaseConfig;
};
