import React, { memo, useMemo } from 'react';
import cx from 'classnames';
import { container, img, withRing, inner, placeholder, iconContainer } from './avatar.module.scss';
import { getColorFromString } from 'bebo-ui/colors';

export default memo(function Avatar({
  ring,
  ringColor,
  user,
  className,
  fluid,
  size = 60,
  style = {},
  icon
}) {
  const resizedImageUrl = useMemo(() => {
    let image_url = user.image_url;
    if (image_url && image_url.indexOf('a.imgdropt') > -1) {
      image_url = image_url + `?original=false&w=${size * 2}&h=${size * 2}&contain=true`;
    }
    return image_url;
  }, [size, user.image_url]);
  return (
    <div
      className={cx(container, className)}
      style={{ ...style, width: fluid ? '100%' : size, height: fluid ? '100%' : size }}
    >
      <div className={inner}>
        {resizedImageUrl ? (
          <img
            className={ring ? withRing : img}
            src={resizedImageUrl}
            style={{ borderWidth: ring, borderColor: ringColor ? ringColor : null }}
            alt=""
          />
        ) : (
          <PlaceHolder
            ring={ring}
            ringColor={ringColor}
            username={user.username}
            userId={user.user_id}
            size={size}
          />
        )}
        {icon && <div className={iconContainer}>{icon}</div>}
      </div>
    </div>
  );
});

const PlaceHolder = memo(function AvatarPlaceHolder({ username, userId, size, ring, ringColor }) {
  const color = useMemo(() => getColorFromString(userId).value, [userId]);

  return (
    <div
      className={ring ? withRing : img}
      style={{
        borderWidth: ring,
        backgroundColor: color,
        borderColor: ringColor ? ringColor : null
      }}
    >
      <div style={{ fontSize: size / 1.66 }} className={placeholder}>
        {username.slice(0, 1).toUpperCase()}
      </div>
    </div>
  );
});
