import React, { memo } from 'react';
import cx from 'classnames';
import css from './flex.module.scss';

export default memo(function Column({
  grow,
  minWidth,
  children,
  className,
  marginRight,
  maxWidth,
  style = {},
  ...rest
}) {
  return (
    <div
      {...rest}
      className={cx(css.column, className)}
      style={{ flexGrow: grow, minWidth, marginRight, maxWidth, ...style }}
    >
      {children}
    </div>
  );
});
