import React from 'react';

const LIBRARY = {
  community: (
    <g>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M58 21H43V36H58V21ZM33.125 47L31.25 35.75H35V32H20V47H33.125ZM48.8625 78L44.5725 62.8H39.75L36 40H66L62.25 62.8H57.4275L53.1375 78H48.8625ZM33 70L30 81H28L25 70H20.7929L17 51H34.7015L37 64.8168L35.9645 70H33ZM77 70L74 81H72L69 70H65.0355L64 64.8168L66.2985 51H84L80.2071 70H77ZM80 47H66.875L68.75 35.75H65V32H80V47Z"
      />
    </g>
  ),
  'system-close': (
    <g>
      <path d="M30 34L34.2426 29.7573L69.598 65.1127L65.3553 69.3553L30 34Z" />
      <path d="M69.598 34L65.3553 29.7574L30 65.1127L34.2426 69.3553L69.598 34Z" />
    </g>
  ),

  'system-minimize': (
    <g>
      <path id="Icon/App/Minimize" fillRule="evenodd" clipRule="evenodd" d="M29 65H71V71H29V65Z" />
    </g>
  ),
  // NAV ICONS //////////////////////////////////////////////////////////////////////////////
  'nav-settings': (
    <g>
      <path
        id="a"
        d="M72.9221184,52.94 C73.0454848,51.98 73.1380096,51.02 73.1380096,50 C73.1380096,48.98 73.0454848,48.02 72.9221184,47.06 L79.4296953,42.11 C80.0156857,41.66 80.1698937,40.85 79.7997945,40.19 L73.6314752,29.81 C73.261376,29.15 72.4286529,28.91 71.7501378,29.15 L64.0705802,32.15 C62.4668172,30.95 60.7396878,29.96 58.8583504,29.21 L57.6863697,21.26 C57.5938449,20.54 56.9461714,20 56.1751315,20 L43.8384928,20 C43.0674529,20 42.4197793,20.54 42.3272546,21.26 L41.1552739,29.21 C39.2739365,29.96 37.5468071,30.98 35.943044,32.15 L28.2634865,29.15 C27.5541297,28.88 26.7522482,29.15 26.3821491,29.81 L20.2138297,40.19 C19.812889,40.85 19.9979386,41.66 20.5839289,42.11 L27.0915058,47.06 C26.9681394,48.02 26.8756146,49.01 26.8756146,50 C26.8756146,50.99 26.9681394,51.98 27.0915058,52.94 L20.5839289,57.89 C19.9979386,58.34 19.8437306,59.15 20.2138297,59.81 L26.3821491,70.19 C26.7522482,70.85 27.5849713,71.09 28.2634865,70.85 L35.943044,67.85 C37.5468071,69.05 39.2739365,70.04 41.1552739,70.79 L42.3272546,78.74 C42.4197793,79.46 43.0674529,80 43.8384928,80 L56.1751315,80 C56.9461714,80 57.5938449,79.46 57.6863697,78.74 L58.8583504,70.79 C60.7396878,70.04 62.4668172,69.02 64.0705802,67.85 L71.7501378,70.85 C72.4594945,71.12 73.261376,70.85 73.6314752,70.19 L79.7997945,59.81 C80.1698937,59.15 80.0156857,58.34 79.4296953,57.89 L72.9221184,52.94 L72.9221184,52.94 Z M50,62.8571429 C42.9102041,62.8571429 37.1428571,57.0897959 37.1428571,50 C37.1428571,42.9102041 42.9102041,37.1428571 50,37.1428571 C57.0897959,37.1428571 62.8571429,42.9102041 62.8571429,50 C62.8571429,57.0897959 57.0897959,62.8571429 50,62.8571429 Z"
      />
      <rect width="100" height="100" fillOpacity="0" />
    </g>
  ),
  // EDITOR ICONS //////////////////////////////////////////////////////////////////////////////
  close: (
    <g>
      <path
        d="M50.5,46.4644661 L29.9939033,25.9583694 C29.0175926,24.9820587 27.4346802,24.9820587 26.4583694,25.9583694 C25.4820587,26.9346802 25.4820587,28.5175926 26.4583694,29.4939033 L46.9644661,50 L26.4583694,70.5060967 C25.4820587,71.4824074 25.4820587,73.0653198 26.4583694,74.0416306 C27.4346802,75.0179413 29.0175926,75.0179413 29.9939033,74.0416306 L50.5,53.5355339 L71.0060967,74.0416306 C71.9824074,75.0179413 73.5653198,75.0179413 74.5416306,74.0416306 C75.5179413,73.0653198 75.5179413,71.4824074 74.5416306,70.5060967 L54.0355339,50 L74.5416306,29.4939033 C75.5179413,28.5175926 75.5179413,26.9346802 74.5416306,25.9583694 C73.5653198,24.9820587 71.9824074,24.9820587 71.0060967,25.9583694 L50.5,46.4644661 Z"
        id="path-2"
      />
    </g>
  ),
  back: (
    <g>
      <polygon
        fillRule="nonzero"
        points="64.1225873 30.8337684 58.255433 24.9666141 33.2888188 49.9332282 58.255433 74.8998424 64.1225873 69.0326881 45.0647385 49.9332282"
      />
    </g>
  ),
  'twitch-logo': (
    <g>
      <path
        id="a"
        d="M26.0078125,20 L22,30.2985075 L22,72.3880597 L36.25,72.3880597 L36.25,80 L44.265625,80 L51.8359375,72.3880597 L63.4140625,72.3880597 L79,56.7164179 L79,20 L26.0078125,20 Z M73.65625,54.0298507 L64.75,62.9850746 L50.5,62.9850746 L42.9296875,70.5970149 L42.9296875,62.9850746 L30.90625,62.9850746 L30.90625,25.3731343 L73.65625,25.3731343 L73.65625,54.0298507 Z M64.75,35.6716418 L64.75,51.3432836 L59.40625,51.3432836 L59.40625,35.6716418 L64.75,35.6716418 Z M50.5,35.6716418 L50.5,51.3432836 L45.15625,51.3432836 L45.15625,35.6716418 L50.5,35.6716418 Z"
      />
      <rect width="100" height="100" fillOpacity="0" />
    </g>
  ),
  // MISC ICONS //////////////////////////////////////////////////////////////////////////////
  checkmark: (
    <g transform="translate(0.000000, 1.000000)">
      <polygon points="39.0560136 62.116008 24.8279784 47.8879727 20 52.7159511 39.0560136 71.7719647 80 30.8279784 75.1720216 26" />
    </g>
  ),
  lock: (
    <g>
      <path d="M67.25,39 L64.375,39 L64.375,33.2857143 C64.375,25.4 57.935,19 50,19 C42.065,19 35.625,25.4 35.625,33.2857143 L35.625,39 L32.75,39 C29.573125,39 27,41.5571429 27,44.7142857 L27,73.2857143 C27,76.4428571 29.573125,79 32.75,79 L67.25,79 C70.426875,79 73,76.4428571 73,73.2857143 L73,44.7142857 C73,41.5571429 70.426875,39 67.25,39 Z M50,64.7142857 C46.823125,64.7142857 44.25,62.1571429 44.25,59 C44.25,55.8428571 46.823125,53.2857143 50,53.2857143 C53.176875,53.2857143 55.75,55.8428571 55.75,59 C55.75,62.1571429 53.176875,64.7142857 50,64.7142857 Z M58.9125,39 L41.0875,39 L41.0875,33.2857143 C41.0875,28.4 45.08375,24.4285714 50,24.4285714 C54.91625,24.4285714 58.9125,28.4 58.9125,33.2857143 L58.9125,39 Z" />
    </g>
  ),
  menu: (
    <g>
      <path d="M25 70H71V63.3333H25V70ZM25 53.3333H63.5V46.6667H25V53.3333ZM25 30V36.6667H75V30H25Z" />
    </g>
  ),
  //PLATFORMS
  win10: (
    <g>
      <path d="M47.481 24.7304L79.9927 20V48.4449L47.481 48.7022V24.7304ZM44.52 25.1658L20 28.4949L20.0229 48.8836L44.5308 48.7444L44.52 25.1658ZM44.5278 75.061L44.5088 51.4614L20.0181 51.3035L20.0195 71.7018L44.5278 75.061ZM79.9922 80L80 51.6833L47.4351 51.6305L47.4805 75.4255L79.9922 80Z" />
    </g>
  ),
  ps4: (
    <g>
      <path d="M79.2761 73.3297C79.2162 73.3297 79.2162 73.2694 79.2162 73.209C79.2162 73.1487 79.2162 73.0884 79.2162 73.028V72.666C79.2162 72.485 79.1563 72.3643 79.0964 72.304C79.0365 72.2437 78.9766 72.1833 78.9167 72.1833C78.9766 72.123 79.0964 72.0626 79.0964 72.0023C79.1563 71.8816 79.2162 71.761 79.2162 71.58C79.2162 71.2783 79.0964 71.0369 78.7969 70.9163C78.6771 70.8559 78.4974 70.7956 78.2578 70.7956H77V73.5107H77.4792V72.3643H78.1979C78.3177 72.3643 78.4375 72.3643 78.4974 72.4247C78.6172 72.485 78.6172 72.5453 78.6771 72.7263V73.1487C78.6771 73.2694 78.6771 73.3297 78.6771 73.3901C78.6771 73.4504 78.6771 73.4504 78.737 73.5107V73.5711H79.2761V73.3297ZM78.6172 71.8816C78.5573 71.942 78.4375 71.942 78.2578 71.942H77.4792V71.1576H78.2578C78.3776 71.1576 78.4375 71.1576 78.4974 71.2179C78.6172 71.2783 78.6771 71.3989 78.6771 71.5196C78.737 71.7006 78.737 71.8213 78.6172 71.8816Z" />
      <path d="M79.8151 70.4335C79.3359 69.9508 78.737 69.7095 78.0781 69.7095C76.7604 69.7095 75.6223 70.7955 75.6223 72.1833C75.6223 72.847 75.8619 73.4504 76.3411 73.933C76.8203 74.4157 77.4192 74.6571 78.0781 74.6571C78.737 74.6571 79.3359 74.4157 79.8151 73.933C80.2943 73.4504 80.5339 72.847 80.5339 72.1833C80.5339 71.5196 80.2943 70.9162 79.8151 70.4335ZM78.0781 74.2347C77.539 74.2347 77 74.0537 76.6406 73.6314C76.2812 73.2693 76.0416 72.7263 76.0416 72.1833C76.0416 71.6402 76.2213 71.0972 76.6406 70.7352C77 70.3732 77.539 70.1318 78.0781 70.1318C78.6172 70.1318 79.1563 70.3128 79.5156 70.7352C79.9349 71.0972 80.1146 71.6402 80.1146 72.1833C80.1146 73.3297 79.2162 74.2347 78.0781 74.2347Z" />
      <path d="M28.4834 65.1842C30.0407 65.6669 32.7959 65.5462 34.7126 64.8825L39.8638 63.0121V68.4424C39.5643 68.5027 39.145 68.5631 38.8455 68.6234C33.6944 69.4681 28.1839 69.1061 22.7931 67.296C17.7618 65.8479 16.9232 62.8914 19.1993 61.1417C21.3556 59.5729 24.9494 58.3662 24.9494 58.3662L39.8638 52.9962V59.0902L29.0823 62.9518C27.2255 63.7361 26.9859 64.7015 28.4834 65.1842Z" />
      <path d="M81.4325 63.0725C80.1746 64.6412 77.1199 65.7876 77.1199 65.7876L54.359 74.0537V67.9597L71.1302 61.9261C73.0469 61.2624 73.3464 60.297 71.789 59.7539C70.2317 59.2712 67.4765 59.3919 65.5598 60.0556L54.359 64.0378V57.7628L55.0179 57.5215C55.0179 57.5215 58.2523 56.3751 62.8045 55.8321C67.3567 55.3494 72.9271 55.8924 77.2397 57.5818C82.0913 59.1506 82.6903 61.5037 81.4325 63.0725Z" />
      <path d="M56.5155 52.6945V37.188C56.5155 35.3779 56.1561 33.6885 54.479 33.2058C53.1612 32.7834 52.3826 33.9902 52.3826 35.8003V74.7174L41.9605 71.3989V25C46.3929 25.8447 52.8618 27.7755 56.3358 28.9822C65.1406 32.0594 68.1355 35.8606 68.1355 44.3681C68.1355 52.6945 62.9844 55.8924 56.5155 52.6945Z" />
    </g>
  ),
  xbox: (
    <g>
      <path d="M29.0749 28.6265L29.072 28.6294C29.4164 28.4269 32.4603 27.0703 42.0582 36.4819C42.0949 36.506 42.1193 36.5422 42.1193 36.5783C42.1193 36.6144 42.0949 36.6385 42.0704 36.6626C35.9391 43.8434 24.0917 60.9879 26.4123 68.0602C26.4367 68.1205 26.4245 68.1807 26.3757 68.2168C26.3268 68.253 26.2535 68.2168 26.2169 68.1686C22.1741 62.9518 19.9878 56.5662 20.0001 50C19.9878 41.9759 23.2489 34.2891 29.0505 28.6506L29.072 28.6294C29.0465 28.6444 29.0358 28.6531 29.0383 28.6506L29.0749 28.6265Z" />
      <path d="M80.8127 50C80.8249 41.9759 77.576 34.2771 71.7744 28.6506C71.8111 28.6867 69.0752 26.3614 58.7667 36.4699C58.7301 36.494 58.7057 36.5181 58.7057 36.5663C58.7057 36.6024 58.7301 36.6265 58.7545 36.6506C64.8736 43.8313 76.721 60.9879 74.4004 68.0602C74.3882 68.1205 74.3882 68.1807 74.437 68.2168C74.4859 68.253 74.5592 68.2168 74.5958 68.1686C78.6386 62.9518 80.8249 56.5662 80.8127 50Z" />
      <path d="M66.2538 24.3855C61.6003 21.6626 56.5438 20 50.4125 20C44.2933 20 39.1757 21.6626 34.5223 24.4217C34.4734 24.4458 34.449 24.506 34.4734 24.5663C34.4979 24.6145 34.5589 24.6265 34.62 24.6145C39.8353 23.2892 48.1041 27.5663 50.3514 28.8434C50.3636 28.8554 50.388 28.8675 50.4125 28.8675C50.4369 28.8675 50.4491 28.8554 50.4735 28.8434C51.3163 28.3373 60.269 23.3253 66.1561 24.5783C66.2171 24.5904 66.2782 24.5783 66.3027 24.5301C66.3271 24.4819 66.3149 24.4096 66.2538 24.3855Z" />
      <path d="M50.4125 44.0602C50.4491 44.0602 50.4857 44.0843 50.5102 44.1084C59.6095 50.9397 75.1821 67.8072 70.4309 72.5783L70.4431 72.5662V72.5783H70.4309C64.8858 77.3735 57.7652 80.012 50.4003 80C43.0353 80.012 35.9147 77.3735 30.3818 72.5783C25.6306 67.8072 41.2032 50.9277 50.3025 44.1084C50.327 44.0843 50.3758 44.0602 50.4125 44.0602Z" />
    </g>
  ),
  'no-platform': (
    <g>
      <path d="M79.2761 73.3297C79.2162 73.3297 79.2162 73.2694 79.2162 73.209C79.2162 73.1487 79.2162 73.0884 79.2162 73.028V72.666C79.2162 72.485 79.1563 72.3643 79.0964 72.304C79.0365 72.2437 78.9766 72.1833 78.9167 72.1833C78.9766 72.123 79.0964 72.0626 79.0964 72.0023C79.1563 71.8816 79.2162 71.761 79.2162 71.58C79.2162 71.2783 79.0964 71.0369 78.7969 70.9163C78.6771 70.8559 78.4974 70.7956 78.2578 70.7956H77V73.5107H77.4792V72.3643H78.1979C78.3177 72.3643 78.4375 72.3643 78.4974 72.4247C78.6172 72.485 78.6172 72.5453 78.6771 72.7263V73.1487C78.6771 73.2694 78.6771 73.3297 78.6771 73.3901C78.6771 73.4504 78.6771 73.4504 78.737 73.5107V73.5711H79.2761V73.3297ZM78.6172 71.8816C78.5573 71.942 78.4375 71.942 78.2578 71.942H77.4792V71.1576H78.2578C78.3776 71.1576 78.4375 71.1576 78.4974 71.2179C78.6172 71.2783 78.6771 71.3989 78.6771 71.5196C78.737 71.7006 78.737 71.8213 78.6172 71.8816Z" />
      <path d="M79.8151 70.4335C79.3359 69.9508 78.737 69.7095 78.0781 69.7095C76.7604 69.7095 75.6223 70.7955 75.6223 72.1833C75.6223 72.847 75.8619 73.4504 76.3411 73.933C76.8203 74.4157 77.4192 74.6571 78.0781 74.6571C78.737 74.6571 79.3359 74.4157 79.8151 73.933C80.2943 73.4504 80.5339 72.847 80.5339 72.1833C80.5339 71.5196 80.2943 70.9162 79.8151 70.4335ZM78.0781 74.2347C77.539 74.2347 77 74.0537 76.6406 73.6314C76.2812 73.2693 76.0416 72.7263 76.0416 72.1833C76.0416 71.6402 76.2213 71.0972 76.6406 70.7352C77 70.3732 77.539 70.1318 78.0781 70.1318C78.6172 70.1318 79.1563 70.3128 79.5156 70.7352C79.9349 71.0972 80.1146 71.6402 80.1146 72.1833C80.1146 73.3297 79.2162 74.2347 78.0781 74.2347Z" />
      <path d="M28.4834 65.1842C30.0407 65.6669 32.7959 65.5462 34.7126 64.8825L39.8638 63.0121V68.4424C39.5643 68.5027 39.145 68.5631 38.8455 68.6234C33.6944 69.4681 28.1839 69.1061 22.7931 67.296C17.7618 65.8479 16.9232 62.8914 19.1993 61.1417C21.3556 59.5729 24.9494 58.3662 24.9494 58.3662L39.8638 52.9962V59.0902L29.0823 62.9518C27.2255 63.7361 26.9859 64.7015 28.4834 65.1842Z" />
      <path d="M81.4325 63.0725C80.1746 64.6412 77.1199 65.7876 77.1199 65.7876L54.359 74.0537V67.9597L71.1302 61.9261C73.0469 61.2624 73.3464 60.297 71.789 59.7539C70.2317 59.2712 67.4765 59.3919 65.5598 60.0556L54.359 64.0378V57.7628L55.0179 57.5215C55.0179 57.5215 58.2523 56.3751 62.8045 55.8321C67.3567 55.3494 72.9271 55.8924 77.2397 57.5818C82.0913 59.1506 82.6903 61.5037 81.4325 63.0725Z" />
      <path d="M56.5155 52.6945V37.188C56.5155 35.3779 56.1561 33.6885 54.479 33.2058C53.1612 32.7834 52.3826 33.9902 52.3826 35.8003V74.7174L41.9605 71.3989V25C46.3929 25.8447 52.8618 27.7755 56.3358 28.9822C65.1406 32.0594 68.1355 35.8606 68.1355 44.3681C68.1355 52.6945 62.9844 55.8924 56.5155 52.6945Z" />
    </g>
  ),
  'line-ribbon': (
    <g>
      <path d="M78.4183 9.5625C77.6266 8.575 76.4308 8 75.1683 8H25.1683C23.9058 8 22.71 8.575 21.9183 9.5625C21.1266 10.5458 20.8266 11.8375 21.0975 13.0708L29.4308 50.5708L37.5683 48.7625L30.36 16.3333H42.6683L46.0016 33H54.335L57.6683 16.3333H69.9766L62.7683 48.7625L70.9058 50.5708L79.2391 13.0708C79.51 11.8375 79.21 10.5458 78.4183 9.5625Z" />
      <path d="M66.8353 91.3335C66.202 91.3335 65.5603 91.1877 64.9728 90.896L50.1687 83.4919L35.3645 90.8919C33.9062 91.621 32.1603 91.4335 30.8978 90.4169C29.627 89.396 29.0687 87.7294 29.4562 86.1585L33.177 71.2794L25.8687 60.3127C25.0145 59.0335 24.9353 57.3919 25.6603 56.0377C26.3895 54.6794 27.7978 53.8335 29.3353 53.8335H39.2603L46.4437 39.471C47.8562 36.6502 52.4853 36.6502 53.8978 39.471L61.0812 53.8335H71.002C72.5395 53.8335 73.9478 54.6794 74.677 56.0336C75.402 57.3877 75.3228 59.0335 74.4687 60.3085L67.1603 71.2752L70.8812 86.1544C71.2728 87.7294 70.7103 89.3919 69.4395 90.4127C68.6895 91.0252 67.7645 91.3335 66.8353 91.3335ZM50.1687 74.6669C50.8062 74.6669 51.4478 74.8127 52.0311 75.1044L60.5937 79.3835L58.6228 71.5044C58.3395 70.3669 58.5478 69.1585 59.202 68.1835L63.2145 62.1627H58.502C56.9228 62.1627 55.4811 61.271 54.7728 59.8585L50.1687 50.6502L45.5645 59.8627C44.8562 61.2752 43.4145 62.1669 41.8353 62.1669H37.1228L41.1353 68.1877C41.7853 69.1627 41.9978 70.3669 41.7145 71.5085L39.7437 79.3877L48.3062 75.1085C48.8895 74.8127 49.5312 74.6669 50.1687 74.6669Z" />
    </g>
  ),
  'line-trophy': (
    <g>
      <path d="M86.9 13.1H73.4602C72.0375 10.6605 69.4258 9 66.4 9H33.6C30.5783 9 27.9625 10.6605 26.5398 13.1H13.1C10.8327 13.1 9 14.9327 9 17.2V29.6599C9 33.4155 10.681 36.9169 13.6166 39.2662L30.7505 52.9725C34.4487 57.6219 39.791 60.8978 45.9 61.931V70.5H37.7C35.4327 70.5 33.6 72.3327 33.6 74.6V82.8H29.5V91H37.7H62.3H70.5V82.8H66.4V74.6C66.4 72.3327 64.5673 70.5 62.3 70.5H54.1V61.931C60.209 60.8978 65.5513 57.6219 69.2495 52.9684L86.3875 39.258C89.319 36.9169 91 33.4155 91 29.6599V17.2C91 14.9327 89.1673 13.1 86.9 13.1ZM58.2 82.8H41.8V78.7H58.2V82.8ZM18.7416 32.862C17.7617 32.083 17.2 30.9104 17.2 29.6599V21.3H25.4V37.7C25.4 37.8722 25.4246 38.0403 25.4246 38.2125L18.7416 32.862ZM50 54.1C40.9595 54.1 33.6 46.7446 33.6 37.7V17.2H66.4V37.7C66.4 46.7446 59.0405 54.1 50 54.1ZM82.8 29.6599C82.8 30.9104 82.2383 32.083 81.2625 32.862L74.5754 38.2125C74.5754 38.0403 74.6 37.8722 74.6 37.7V21.3H82.8V29.6599Z" />
    </g>
  ),
  'double-ribbon': (
    <g>
      <path d="M63.9413 47.5721C63.1336 46.171 62.2037 44.8522 61.1679 43.6305L61.7603 41.8302C63.8816 41.9068 65.9077 42.3455 67.8041 43.0591L73.6732 25.4545H67.1345C67.6277 23.651 67.6166 21.7657 67.1336 20H77.4559C78.3314 20 79.155 20.42 79.665 21.1318C80.1805 21.8409 80.3223 22.7573 80.0441 23.5891L72.6559 45.7536C77.2214 49.2473 80.1832 54.7291 80.1832 60.9091C80.1832 71.4364 71.6168 80 61.0923 80C60.5799 80 60.0722 79.9797 59.5699 79.9399C61.2739 78.2562 62.7532 76.3402 63.9575 74.2427C70.1056 72.9235 74.7287 67.448 74.7287 60.9091C74.7287 54.3668 70.0975 48.8857 63.9413 47.5721Z" />
      <path d="M66.3997 68.5382L69.2741 70.4545L67.2691 64.4396C67.0847 65.8432 66.792 67.2124 66.3997 68.5382Z" />
      <path d="M67.4961 61.3234C67.4982 61.1856 67.4992 61.0475 67.4992 60.9091C67.4992 59.5169 67.3929 58.1507 67.1883 56.8182H72.0014L67.4961 61.3234Z" />
      <path d="M65.01 31.954L62.6617 39.0909H63.8196L65.01 31.954Z" />
      <path d="M52.6563 45.7537L60.0445 23.5891C60.3226 22.7573 60.1808 21.8409 59.6654 21.1318C59.1554 20.42 58.3317 20 57.4563 20H24.729C23.8535 20 23.0299 20.42 22.5172 21.1318C22.0045 21.8437 21.8626 22.76 22.1381 23.5891L29.5263 45.7537C24.9635 49.2473 22.0017 54.7291 22.0017 60.9091C22.0017 71.4364 30.5681 80 41.0926 80C51.6172 80 60.1835 71.4364 60.1835 60.9091C60.1835 54.7291 57.2217 49.2473 52.6563 45.7537ZM28.5117 25.4546H36.0908L38.3654 39.0909H43.8199L46.0945 25.4546H53.6735L47.8045 43.0591C45.7099 42.2709 43.4572 41.8182 41.0926 41.8182C38.7281 41.8182 36.4754 42.2709 34.3808 43.0591L28.5117 25.4546ZM41.0926 74.5455C33.5735 74.5455 27.4563 68.4309 27.4563 60.9091C27.4563 53.39 33.5735 47.2728 41.0926 47.2728C48.6117 47.2728 54.729 53.39 54.729 60.9091C54.729 68.4309 48.6117 74.5455 41.0926 74.5455Z" />
      <path d="M43.8199 56.8182L41.0926 48.6364L38.3654 56.8182H30.1835L35.6381 62.2727L32.9108 70.4546L41.0926 65L49.2745 70.4546L46.5472 62.2727L52.0017 56.8182H43.8199Z" />
    </g>
  ),
  edit: (
    <g>
      <path d="M27,62.6051974 L27,73 L37.3948026,73 L66.98001,43.4147926 L56.5852074,33.01999 L27,62.6051974 Z M76.1754123,34.252707 C77.2748626,33.1532567 77.2748626,31.4207896 76.1754123,30.3213393 L69.6786607,23.8245877 C68.5792104,22.7251374 66.8467433,22.7251374 65.747293,23.8245877 L60.316675,29.2885224 L70.7114776,39.683325 L76.1754123,34.252707 L76.1754123,34.252707 Z" />
    </g>
  ),
  info: (
    <g>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M50.5 18C32.5601 18 18 32.5601 18 50.5C18 68.4399 32.5601 83 50.5 83C68.4399 83 83 68.4399 83 50.5C83 32.5601 68.4399 18 50.5 18ZM47.25 66.75V47.25H53.75V66.75H47.25ZM47.25 34.25V40.75H53.75V34.25H47.25Z"
      />
    </g>
  ),
  ticket: (
    <g>
      <path d="M10 62.6666L16.5834 69.25C20.2192 65.6142 26.1143 65.6143 29.75 69.25C33.3859 72.8859 33.3858 78.7808 29.75 82.4167L36.3334 89L73.2001 52.1333L46.8668 25.8L10.0001 62.6666H10ZM49.5 23.1667L75.8334 49.5L89 36.3333L82.4167 29.75C78.7808 33.3858 72.8859 33.3859 69.25 29.75C65.6143 26.1142 65.6142 20.2192 69.25 16.5833L62.6666 10L49.5 23.1667ZM35.675 44.8917L44.2745 48.5536L51.4338 42.2172L50.4258 51.619L58.4903 56.3097L49.2531 58.4698L47.093 67.707L42.4023 59.6425L33.0005 60.6505L39.337 53.4911L35.675 44.8917V44.8917Z" />
    </g>
  ),
  'chevron-left': (
    <g>
      <polygon
        transform="translate(50.309524, 50.000000) translate(-50.309524, -50.000000) "
        points="39 50 58 31 61.6190476 34.6190476 46.2380952 50 61.6190476 65.3809524 58 69"
      />
    </g>
  ),
  'chevron-right': (
    <g>
      <polygon
        transform="translate(50.309524, 50.000000) rotate(180) translate(-50.309524, -50.000000) "
        points="39 50 58 31 61.6190476 34.6190476 46.2380952 50 61.6190476 65.3809524 58 69"
      />
    </g>
  ),
  eye: (
    <g>
      <path d="M50 28.125C35.4167 28.125 22.9626 37.1958 17.9167 50C22.9626 62.8042 35.4167 71.875 50 71.875C64.5835 71.875 77.0376 62.8042 82.0835 50C77.0376 37.1958 64.5835 28.125 50 28.125ZM50 64.5833C41.9502 64.5833 35.4167 58.05 35.4167 50C35.4167 41.95 41.9502 35.4167 50 35.4167C58.05 35.4167 64.5835 41.95 64.5835 50C64.5835 58.05 58.05 64.5833 50 64.5833ZM41.25 50C41.25 45.1583 45.1584 41.25 50 41.25C54.8416 41.25 58.75 45.1583 58.75 50C58.75 54.8417 54.8416 58.75 50 58.75C45.1584 58.75 41.25 54.8417 41.25 50Z" />
    </g>
  ),
  twitch: (
    <g>
      <path
        id="a"
        d="M26.0078125,20 L22,30.2985075 L22,72.3880597 L36.25,72.3880597 L36.25,80 L44.265625,80 L51.8359375,72.3880597 L63.4140625,72.3880597 L79,56.7164179 L79,20 L26.0078125,20 Z M73.65625,54.0298507 L64.75,62.9850746 L50.5,62.9850746 L42.9296875,70.5970149 L42.9296875,62.9850746 L30.90625,62.9850746 L30.90625,25.3731343 L73.65625,25.3731343 L73.65625,54.0298507 Z M64.75,35.6716418 L64.75,51.3432836 L59.40625,51.3432836 L59.40625,35.6716418 L64.75,35.6716418 Z M50.5,35.6716418 L50.5,51.3432836 L45.15625,51.3432836 L45.15625,35.6716418 L50.5,35.6716418 Z"
      />
      <rect width="100" height="100" fillOpacity="0" />
    </g>
  )
};

export default LIBRARY;
