import React, { memo, useMemo } from 'react';

import invariant from 'invariant';

import IconLib from './icon-library';

const Icon = memo(({ size, className, style = {}, viewBox = '0 0 100 100', icon, ...rest }) => {
  const styles = useMemo(
    () => ({
      fill: 'currentcolor',
      verticalAlign: 'middle',
      width: size,
      height: size,
      flex: '0 0 auto',
      ...style
    }),
    [size, style]
  );

  if (!(icon in IconLib)) {
    invariant(false, `Unknown icon in shared bebo-ui/Icon`, icon);
    return null;
  }

  return (
    <svg
      viewBox={viewBox}
      preserveAspectRatio="xMidYMid meet"
      className={className}
      style={styles}
      {...rest}
    >
      {IconLib[icon]}
    </svg>
  );
});

export default Icon;
