import React, { memo } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { Link } from '@reach/router';

import css from './IconButton.module.scss';
import { Icon } from 'bebo-ui';

const IconButton = memo(function IconButton({
  link,
  color,
  size,
  onClick,
  children,
  className,
  icon,
  noPadding,
  disabled,
  title,
  style = {}
}) {
  const btnStyle = Object.assign(
    {},
    {
      display: 'flex',
      justitfyContent: 'center',
      alignItems: 'center',
      padding: noPadding ? '0' : '2px',
      pointerEvents: disabled ? 'none' : 'auto'
    },
    style
  );

  const styles = {
    fill: color,
    flex: '0 0 auo'
  };

  const classes = cx(css.iconButton, className, { disabled: css.disabled });

  if (link) {
    return (
      <Link to={link} onClick={onClick ? onClick : () => null} style={btnStyle} className={classes}>
        <Icon size={size} icon={icon} style={styles} />
      </Link>
    );
  } else {
    return (
      <button onClick={onClick} className={classes} style={btnStyle} title={title}>
        <Icon size={size} icon={icon} style={styles} />
      </button>
    );
  }
});

export default IconButton;

IconButton.defaultProps = {
  size: 25,
  className: ''
};

IconButton.propTypes = {
  icon: PropTypes.string,
  size: PropTypes.number,
  to: PropTypes.string,
  title: PropTypes.string
};
