import React, { memo, useState } from 'react';
import { Button, Icon } from 'bebo-ui';
import Dropzone from 'react-dropzone';
import FileController from 'controllers/file';

import cx from 'classnames';

import css from './image-upload.module.scss';

const ImageUpload = memo(
  ({ imageComponent, size, nameSpace, onUploadComplete, onUploadError, imageUrl, className }) => {
    if (!imageComponent) {
      imageComponent = <img src={imageUrl} alt="" />;
    }

    const [isUploading, setIsUploading] = useState(false);

    const onImageDrop = (acceptedFiles, rejectedFiles) => {
      if (!acceptedFiles || !acceptedFiles.length) {
        return Promise.resolve();
      }
      setIsUploading(true);
      return FileController.upload(acceptedFiles[0], nameSpace)
        .then(result => {
          setIsUploading(false);
          if (onUploadComplete) {
            onUploadComplete(result);
          }
        })
        .catch(err => {
          setIsUploading(false);
          if (onUploadError) {
            onUploadError(err);
          }
        });
    };

    return (
      <Dropzone multiple={false} accept="image/*" onDrop={onImageDrop}>
        {({ getRootProps, getInputProps, isDragActive }) => (
          <div
            {...getRootProps()}
            style={{ width: size, height: size }}
            className={cx(css.container, className)}
          >
            {imageComponent}
            <div className={css.imageUploadButtonContainer}>
              <Button primary loading={isUploading} className={css.imageUploadButton}>
                <Icon size="28" icon="edit" />
              </Button>
              <input {...getInputProps()} name="playerAvatar" />
            </div>
          </div>
        )}
      </Dropzone>
    );
  }
);

export default ImageUpload;
