import React, { memo } from 'react';

import cx from 'classnames';
import { rgba } from 'bebo-ui/util/color';

import css from './Loader.module.scss';

const Loader = memo(function Loader({ className, style, color, size }) {
  const classes = cx(css.uiLoader, className);

  const opts = {
    border: `${size * 0.1}px solid ${rgba(color, 0.3)}`,
    borderTop: `${size * 0.11}px solid ${color}`,
    width: `${size}px`,
    height: `${size}px`
  };

  const styles = Object.assign({}, opts, style);

  return <div className={classes} style={styles} />;
});

Loader.defaultProps = {
  color: '#FFFFFF',
  size: 60,
  style: {
    opacity: 0.5
  }
};

export default Loader;
