import React, { useContext } from 'react';
import { Link, Location } from '@reach/router';
import cx from 'classnames';

import { NavContext } from 'components/navigation';

const NavLink = ({ activeClassName, exact, onClick, closeNav = false, to, ...props }) => {
  const { close } = useContext(NavContext);
  const handleClick = e => {
    if (closeNav) {
      close();
    }
    if (onClick) {
      onClick(e);
    }
  };
  return (
    <Location>
      {({ location }) => {
        if (to === location.pathname) {
          return (
            <span
              {...props}
              onClick={handleClick}
              className={cx(props.className, activeClassName)}
            />
          );
        }

        return to ? (
          <Link
            {...props}
            to={to}
            onClick={handleClick}
            getProps={({ isPartiallyCurrent, isCurrent }) =>
              (exact && isCurrent) || (!exact && isPartiallyCurrent)
                ? { className: cx(props.className, activeClassName) }
                : {}
            }
          />
        ) : null;
      }}
    </Location>
  );
};

export default NavLink;
