import React, { memo } from 'react';
import cx from 'classnames';
import css from './flex.module.scss';

export default memo(function Row({
  grow,
  maxHeight,
  children,
  className,
  spaceBetween,
  style = {},
  ...rest
}) {
  return (
    <div
      className={cx(css.row, className)}
      style={{
        ...style,
        flexGrow: grow,
        flexBasis: grow,
        maxHeight,
        justifyContent: spaceBetween
          ? 'space-between'
          : style.justifyContent
          ? style.justifyContent
          : null
      }}
      {...rest}
    >
      {children}
    </div>
  );
});
