import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import Select from 'react-select';
import 'react-select/scss/default.scss';
import './Select.scss';

export default function InputSelect({
  closeOnSelect,
  optionRenderer,
  value,
  inlineLabel,
  className,
  onChange,
  onFocus,
  label,
  options,
  searchable,
  placeholderData,
  onOpen,
  onClose,
  type,
  disabled = false,
  ...rest
}) {
  /// diff type of selects
  const fontRenderer = ({ label, value }) => (
    <span className="form-select__input--item" style={{ fontFamily: value }}>
      {label}
    </span>
  );

  const textRenderer = ({ label, value, textStyle }) => (
    <span className="form-select__input--item text-template" style={textStyle}>
      {label}
      <span>{label}</span>
    </span>
  );

  const textPlaceholder = (
    <span className="form-select__input--item" style={placeholderData ? placeholderData : null}>
      Custom
    </span>
  );

  const generateTypeOptions = type => {
    switch (type) {
      case 'template':
        return {
          valueRenderer: textRenderer,
          optionRenderer: textRenderer,
          //arrowRenderer: () => <Icon icon="select" size={20} style={{ fill: '#FFF' }} />,
          searchable: false,
          placeholder: textPlaceholder
        };
      case 'font':
        return {
          valueRenderer: fontRenderer,
          optionRenderer: fontRenderer
        };

      default:
        return {};
    }
  };

  const opts = generateTypeOptions(type);

  const props = {
    value,
    searchable,
    onChange,
    options,
    closeOnSelect: closeOnSelect === false ? false : true,
    onFocus,
    onOpen,
    ...opts,
    ...rest
  };
  if (optionRenderer && typeof optionRenderer === 'function') {
    props.optionRenderer = optionRenderer;
  }

  const classes = cx('form-item', 'form-select', className);

  return (
    <div className={classes}>
      {disabled ? (
        <span className="form-select__input" style={{ cursor: 'default !important' }}>
          <span
            className="form-select__input--item"
            style={{ lineHeight: '34px', padding: '0px 10px' }}
          >
            {(options.find(opt => opt.value === value) || {}).label || value || ''}
          </span>
        </span>
      ) : (
        <Select className="form-select__input" {...props} />
      )}
    </div>
  );
}

InputSelect.defaultProps = {
  label: '',
  className: '',
  options: [],
  value: '',
  searchable: false
};

InputSelect.propTypes = {
  onChange: PropTypes.func,
  onFocus: PropTypes.func,
  options: PropTypes.array
};
