import React, { memo, useMemo } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';

import css from './team-avatar.module.scss';

const SIZES = ['small', 'medium', 'large'];

const TeamAvatar = memo(
  ({ image_url, name, fluid, size = 'medium', className, icon, ...props }) => {
    const resizedImageUrl = useMemo(() => {
      if (typeof size === 'number' && image_url && image_url.indexOf('a.imgdropt') > -1) {
        return image_url + `?original=false&w=${size * 2}&h=${size * 2}&contain=true`;
      }
      return image_url;
    }, [image_url, size]);

    return (
      <div
        className={cx(css.container, className, { [css[size]]: size && typeof size !== 'number' })}
        style={
          typeof size === 'number' ? { height: size, width: size, borderRadius: size * 0.06 } : {}
        }
      >
        {resizedImageUrl && (
          <img
            className={css.image}
            src={resizedImageUrl}
            alt={name}
            style={{ display: 'block', borderRadius: typeof size === 'number' ? size * 0.06 : 0 }}
          />
        )}
        {icon ? <div className={css.iconContainer}>{icon}</div> : null}
      </div>
    );
  }
);

export default TeamAvatar;

TeamAvatar.propTypes = {
  size: PropTypes.oneOfType([PropTypes.oneOf(SIZES), PropTypes.number]),
  name: PropTypes.string,
  image_url: PropTypes.string
};
