import React from 'react';
import Toggle from 'react-toggle';

// toggle scss
import './Toggle.scss';

export default function InputToggle(props) {
  const { value, onChange, inlineLabel, style, ...restProps } = props;
  return (
    <div className={`form-item form-toggle`} style={style}>
      <Toggle className="form-toggle__toggle" checked={value} onChange={onChange} {...restProps} />
    </div>
  );
}

InputToggle.defaultProps = {
  value: false
};
