import React, { Fragment, memo, useContext } from 'react';
import cx from 'classnames';
import { Match } from '@reach/router';
import invariant from 'invariant';

import { NavContext } from 'components/navigation';

import css from './user-link.module.scss';
import { Avatar } from 'bebo-ui';

const UserLink = memo(function UserLink({
  reverse,
  className,
  avatarOnly,
  children,
  closeNav,
  onClick,
  ...rest
}) {
  const { close } = useContext(NavContext);
  const { user, style = {} } = rest;

  invariant(user, `UserLink requires a user object to be passed to it`, user);

  const handleClick = e => {
    if (closeNav) {
      setTimeout(close, 200);
    }
    if (onClick) {
      onClick(e);
    }
  };

  return (
    <Match path="/app/league/:league_id/*">
      {({ match }) => (
        <span
          onClick={handleClick}
          to={`${match && match.division_id ? `/app/league/${match.league_id}` : ''}/p/${
            user.user_id
          }`}
          className={cx(css.container, className)}
          style={children ? style : { ...style }}
        >
          {children ? (
            children
          ) : (
            <Fragment>
              {!reverse && <Avatar className={css.avatar} {...rest} />}

              {!avatarOnly && (
                <span style={reverse ? { marginRight: 15 } : { marginLeft: 15 }}>
                  {user.username}
                </span>
              )}
              {reverse && <Avatar className={css.avatar} {...rest} />}
            </Fragment>
          )}
        </span>
      )}
    </Match>
  );
});

export default UserLink;
