import flatten from 'flat';
import generate from 'string-to-color';
import nerestColor from 'nearest-color';

const colors = {
  red: {
    '400': '#ef5350'
    // '500': '#f44336',
    // '600': '#e53935',
    // '700': '#d32f2f',
    // '800': '#c62828',
    // '900': '#b71c1c'
  },
  pink: {
    '400': '#ec407a'
    // '500': '#e91e63',
    // '600': '#d81b60',
    // '700': '#c2185b',
    // '800': '#ad1457'
  },
  deepPurple: {
    '400': '#7e57c2'
    // '500': '#673ab7',
    // '600': '#5e35b1',
    // '700': '#512da8'
    // '800': '#4527a0',
    // '900': '#311b92'
  },
  indigo: {
    '400': '#5c6bc0'
    // '500': '#3f51b5',
    // '600': '#3949ab',
    // '700': '#303f9f'
    // '800': '#283593'
    // '900': '#1a237e'
  },
  blue: {
    '400': '#42a5f5'
    // '500': '#2196f3',
    // '600': '#1e88e5',
    // '700': '#1976d2',
    // '800': '#1565c0'
    // '900': '#0d47a1'
  },

  cyan: {
    '400': '#26c6da',
    '500': '#00bcd4',
    '600': '#00acc1',
    '700': '#0097a7'
    // '800': '#00838f',
    // '900': '#006064'
  },
  teal: {
    '400': '#26a69a',
    '500': '#009688',
    '600': '#00897b',
    '700': '#00796b'
    // '800': '#00695c'
    // '900': '#004d40'
  },
  green: {
    //   '400': '#66bb6a',
    '500': '#4caf50',
    '600': '#43a047',
    '700': '#388e3c'
  },
  deepOrange: {
    '400': '#ff7043',
    '500': '#ff5722',
    '600': '#f4511e',
    '700': '#e64a19'
    // '800': '#d84315',
    // '900': '#bf360c'
  },
  blueGrey: {
    '500': '#FF9800',
    '600': '#546E7A'
  }
};

const keys = Object.keys(colors);
const totalKeys = keys.length;
const keysPerColor = {};

keys.forEach(color => {
  keysPerColor[color] = Object.keys(colors[color]).length;
});

const random = (lower, upper) => Math.floor(Math.random() * upper) + lower;

export const getRandomColor = () => {
  const color = keys[random(0, totalKeys)];
  return Object.values(colors[color])[random(0, keysPerColor[color])];
};

let flatColors = null;
let nearest = null;
const stringCache = new Map();

export const getColorFromString = input => {
  if (stringCache.has(input)) {
    return stringCache.get(input);
  }
  if (!flatColors) {
    flatColors = flatten(colors);
  }
  if (!nearest) {
    nearest = nerestColor.from(flatColors);
  }

  const output = nearest(generate(input));
  stringCache.set(input, output);
  return output;
};
