import tinycolor from 'tinycolor2';

function rgb(hex) {
  return tinycolor(hex).toRgbString();
}

function rgba(hex, opacity) {
  return tinycolor(hex)
    .setAlpha(opacity)
    .toRgbString();
}

function darken(hex, amount) {
  return tinycolor(hex)
    .darken(amount / 100)
    .toString();
}

function lighten(hex, amount) {
  return tinycolor(hex)
    .lighten(amount / 100)
    .toString();
}

export { rgb, rgba, darken, lighten };
