/**
 * Created by jonas on 3/6/17.
 */
//TODO it breaks when i remove this will have to look at later
import 'classes/socket';
//END TODO
import { sendLogs } from 'classes/log-api';
import Config from 'scripts/config';

const SEND_INTERVAL = 15000;
const SEND_NUMBER = 50;

const RealConsole = Object.assign({}, window.console);
const Logger = Object.assign({}, window.console);

class LogSender {
  constructor() {
    this.queue = [];

    this.send = this.send.bind(this);
    this.startInterval();
  }

  startInterval() {
    this.interval = setInterval(this.send, SEND_INTERVAL);
  }

  stopInterval() {
    if (this.interval) {
      clearInterval(this.interval);
    }
  }

  add(data, log_level_tx = 'log') {
    const message_sa = this.buildStr(data);
    this.queue.push({ message_sa, log_level_tx, client_time_dttm: new Date(), type_tx: 'web' });
    if (this.queue.length === SEND_NUMBER) {
      this.send();
    }
  }

  addRaw(data) {
    if (!data.type_tx) {
      console.error('LogSender.addRaw - log data is missing type_tx', data);
      return;
    }
    this.queue.push(data);
    if (this.queue.length === SEND_NUMBER) {
      this.send();
    }
  }

  buildStr(data) {
    return data
      .map(arg => {
        if (typeof arg === 'object' && arg && arg.stack) {
          // NWJS Error is not instance of Error ;-(
          return `"${arg.stack}"`;
        } else {
          return JSON.stringify(arg);
        }
      })
      .join(', ');
  }

  send() {
    if (this.queue && this.queue.length) {
      const logs = [].concat(this.queue);
      this.queue = [];
      return sendLogs(logs).catch(err => {
        console.localError('postLogs failed', err);
      });
    }
  }
}

export const Sender = new LogSender();

Logger.info = (...args) => {
  Sender.add(args, 'info');
  if (RealConsole.info) {
    RealConsole.info.apply(RealConsole, args);
  }
};
Logger.warning = (...args) => {
  Sender.add(args, 'warn');
  if (RealConsole.warn) {
    RealConsole.warn.apply(RealConsole, args);
  }
};
Logger.warn = (...args) => {
  Sender.add(args, 'warn');
  if (RealConsole.warn) {
    RealConsole.warn.apply(RealConsole, args);
  }
};
Logger.error = (...args) => {
  Sender.add(args, 'error');
  if (RealConsole.error) {
    RealConsole.error.apply(RealConsole, args);
  }
};

Logger.localError = (...args) => {
  // Sender.add(args, 'error');
  if (RealConsole.error) {
    RealConsole.error.apply(RealConsole, args);
  }
};

Logger.debug = (...args) => {
  if (RealConsole.debug) {
    RealConsole.debug.apply(RealConsole, args);
  }
};

Logger.log = (...args) => {
  if (RealConsole.log) {
    RealConsole.log.apply(RealConsole, args);
  }
};

window.onerror = (msg, url, line, col, err) => {
  if (err && err.stack) {
    console.error(`${msg} | Stack: ${JSON.stringify(err.stack)}`);
  } else {
    console.error(`${msg}`);
  }
};

window.addEventListener('unhandledrejection', function(event) {
  console.error('Unhandled rejection (promise: ', event.promise, ', reason: ', event.reason, ').');
});

window.console = Logger;

export const logFlusher = () => {
  Sender.send();
};
export default (Config.env === 'prod' ? Logger : window.console);
