import config from 'scripts/config';
import { sessionStorage } from 'scripts/utils';

const _getAccessToken = () => {
  return Promise.resolve(sessionStorage.get('at'));
};

const _POST = (url, body) => {
  if (!body) body = {};
  return _getAccessToken()
    .then(access_token => {
      const headers = {
        'Content-Type': 'application/json',
        'X-Riano-User-Agent': navigator.userAgent
      };
      if (access_token) {
        headers['X-Access-Token'] = access_token;
      }
      const options = {
        method: 'POST',
        headers,
        body: JSON.stringify(body),
        mode: 'cors'
      };
      return fetch('https://' + config.LOG_API + url, options);
    })
    .catch(err => {
      console.error('failed to upload logs', err);
    });
};

//actual API calls below

export const sendLogs = (logs = []) => {
  return _POST('/web/logs', { logs });
};

export const sendEvents = (events = []) => {
  return _POST('/events', { events });
};
