import UserController, { isLoggedIn$, loggedInUser$ } from 'controllers/user';
import config from 'scripts/config';

import { getRoutingKey } from 'scripts/utils';

import { uuid, isDesktopApp, getParameterByName, storage } from 'scripts/utils';

const DEFAULT_MESSAGE_TIMEOUT = 15 * 1000; /// 15s

const SUB_COUNTS = {};

class Socket {
  constructor() {
    this.port = 0; // storage.get('ws_port');
    this.reqIdMap = {};
    this.pendingMessages = [];
    this.user_subscribed = isDesktopApp();
    this.open = false;
    this.user_id = null;

    // this subject queues as necessary to ensure every message is delivered

    // this method returns an object which contains two observables
  }

  userSubscribe = () => {
  };

  userUnsubscribe = () => {
  };

  checkConnection = () => {
  };

  onOpen = () => {
  };

  onClose = () => {
  };

  flushMessages = () => {
  };

  _parseMessage = rawMessage => {
    return {};
  };

  createTimeout = (timeoutCallback, timeout = DEFAULT_MESSAGE_TIMEOUT) =>
    setTimeout(timeoutCallback, timeout);

  generateError = (url, req_id) => ({
    url,
    code: 504,
    ack_id: req_id,
    message: 'connection timed out'
  });

  send = (url, data = {}, opts = {}, callback, timeout) => {
  };

  cleanup = () => {};
}

const singleton = new Socket();
export default singleton;

export const onmessage$ = singleton.parsedMessages;

const methodFactory = (url, payload = {}, method, opts = {}) =>
  new Promise((resolve, reject) => {
    singleton.send(url, { ...payload, method }, opts, response => {
      if (response && response.code < 400) {
        return resolve(response);
      }
      reject(response);
    });
  });
export const checkConnection = singleton.checkConnection;

export const WS_RAW = (url, payload) => methodFactory(url, payload, null, null);
export const GET = (url, payload, opts) => methodFactory(url, payload, 'GET', opts);
export const POST = (url, payload, opts) => methodFactory(url, payload, 'POST', opts);
export const PUT = (url, payload, opts) => methodFactory(url, payload, 'PUT', opts);
export const DELETE = (url, payload, opts) => methodFactory(url, payload, 'DELETE', opts);

export const subscribe = (url, payload) => {
  const routingKey = getRoutingKey(url, payload, true);
  if (routingKey in SUB_COUNTS) {
    let prevNumber = SUB_COUNTS[routingKey];
    SUB_COUNTS[routingKey] = prevNumber + 1;
  } else {
    SUB_COUNTS[routingKey] = 1;
  }
  return POST(`/subscribe${url}`, payload);
};
export const unsubscribe = (url, payload) => {
  const routingKey = getRoutingKey(url, payload, true);
  if (routingKey in SUB_COUNTS) {
    let prevNumber = SUB_COUNTS[routingKey];
    if (prevNumber - 1 <= 0) {
      delete SUB_COUNTS[routingKey];
    } else {
      SUB_COUNTS[routingKey] = prevNumber - 1;
    }
  } else {
    console.warn('trying to unsubscribe from non-existent routing key');
  }
  return POST(`/unsubscribe${url}`, payload);
};
