import React, { memo } from 'react';

import css from './action-card.module.scss';

import cx from 'classnames';

import { Column } from 'bebo-ui';

const ActionCard = memo(
  ({ cardRef, children, actionBtn, secondaryActionBtn, title, subTitle, sticky }) => {
    return (
      <div className={cx(css.container, sticky && css.sticky)} ref={cardRef}>
        <Column className={css.card}>
          {title && <h2 className={css.title}>{title}</h2>}
          {subTitle && <h4 className={css.subTitle}>{subTitle}</h4>}
          {children && <div className={css.content}>{children}</div>}
          {actionBtn}
          {secondaryActionBtn && (
            <div className={css.secondaryBtnContainer}>{secondaryActionBtn}</div>
          )}
        </Column>
      </div>
    );
  }
);

export default ActionCard;
