import React, { memo, useCallback, useState } from 'react';

import ActionCard from './card';

import { Button } from 'bebo-ui';

import Sheet from 'components/modal-sheet';
import CreateTeam from 'components/settings/create-team';

const CreateTeamActionCard = memo(({ track, leagueId, cardRef }) => {
  const [sheet, setSheet] = useState('');
  const onCreateTeam = useCallback(() => {
    track('create-sheet');
    setSheet('create');
  }, [track]);
  const onHaveInvite = useCallback(() => {
    track('join-sheet');
    setSheet('join');
  }, [track]);

  const actionBtn = (
    <Button primary fluid onClick={onCreateTeam}>
      Create Your Team
    </Button>
  );

  const secondaryActionBtn = (
    <Button secondary fluid onClick={onHaveInvite}>
      Invited?
    </Button>
  );

  return (
    <>
      <ActionCard
        cardRef={cardRef}
        title="Join This League"
        actionBtn={actionBtn}
        secondaryActionBtn={secondaryActionBtn}
      >
        <p>
          Before you start your journey towards domination you need to either join a team or create
          your own and invite a teammate.
        </p>
      </ActionCard>
      <Sheet open={sheet === 'create'} onClose={() => setSheet('')}>
        <CreateTeam leagueId={leagueId} onCreate={() => setSheet('')} />
      </Sheet>
      <Sheet open={sheet === 'join'} onClose={() => setSheet('')}>
        <h4>How To Join A Team</h4>
        <p>
          Ask the friend who created the team you want to join for their team invite link. Then open
          the invite link in your browser and follow the steps.
        </p>
      </Sheet>
    </>
  );
});

export default CreateTeamActionCard;
