import React, { memo, useCallback } from 'react';

import ActionCard from './card';

import CopyButton from 'components/copy-button';

const CreateTeamActionCard = memo(({ track, cardRef, playersNeeded, invite_url }) => {
  const onCopyInviteLink = useCallback(() => {
    track('copy-invite');
  }, [track]);

  const actionBtn = (
    <CopyButton
      successText={'Copied invite link successfully.'}
      primary
      fluid
      onCopy={onCopyInviteLink}
      value={invite_url}
    >
      Copy Invite Link
    </CopyButton>
  );

  //   const secondaryActionBtn = (
  //     <Button secondary fluid onClick={onHaveInvite}>
  //       Have an invite?
  //     </Button>
  //   );

  return (
    <>
      <ActionCard
        cardRef={cardRef}
        title="Assemble your team"
        actionBtn={actionBtn}
        // secondaryActionBtn={secondaryActionBtn}
      >
        <p>
          You need to add{' '}
          <b>{`${playersNeeded} more ${playersNeeded >= 2 ? 'players' : 'player'}`}</b> to your team
          before we can place you in the league to compete with other teams.
        </p>
        <h5>Invite Link</h5>
        <p>
          Send this invite link to your teammate: <br />
          <b>{invite_url}</b>
        </p>
      </ActionCard>
    </>
  );
});

export default CreateTeamActionCard;
