import React, { memo, useState, useEffect } from 'react';

import Clipboard from 'react-clipboard.js';
import { Button } from 'bebo-ui';

import useSnack from 'hooks/useSnack';

const CopyButton = memo(({ onCopy, value, children, successText }) => {
  let _mounted = false;
  useEffect(() => {
    //eslint-disable-next-line
    _mounted = true;
    return () => {
      _mounted = false;
    };
  }, []);
  const { onSuccess } = useSnack();
  const [copied, setCopied] = useState(false);

  const onCopySuccess = e => {
    if (copied) {
      return;
    }
    setCopied(true);
    if (onCopy) {
      onCopy(e);
    }

    if (successText) {
      onSuccess({ text: successText }).then(() => {
        if (_mounted) {
          setCopied(false);
        }
      });
    }
  };

  return (
    <Clipboard
      onSuccess={onCopySuccess}
      component={'div'}
      style={{ display: 'flex' }}
      data-clipboard-text={value}
    >
      <Button primary fluid disabled={copied}>
        {children ? children : 'Copy'}
      </Button>
    </Clipboard>
  );
});

export default CopyButton;
