import React, { memo, useState, useMemo } from 'react';

import css from './division-play.module.scss';

import Sheet from 'components/modal-sheet';
import SheetTeam from 'components/sheet-team';

import useTrack from 'hooks/useTrack';

//action cards
import CreateTeamActionCard from 'components/action-cards/create-team';
import TeamSummaryActionCard from 'components/action-cards/team-summary';
import InviteTeamActionCard from 'components/action-cards/team-invite';
//end action cards

const DivisionPlay = memo(({ standings, actingUser, actingTeam, league, cardRef }) => {
  const leagueId = league.league_id;
  const [selectedTeam, setSelectedTeam] = useState(null);

  const leagueTeam = useMemo(() => {
    const currentLeague =
      actingUser.leagues && actingUser.leagues.find(l => l.league_id === leagueId);

    return currentLeague && currentLeague.teams && currentLeague.teams[0];
  }, [actingUser, leagueId]);

  const track = useTrack('home', 'division', {
    league_id: leagueId,
    team_id: leagueTeam && leagueTeam.team_id
  });

  const playersNeeded = useMemo(() => {
    return (
      ((league && league.team_size) || 0) -
      ((leagueTeam && leagueTeam.users && leagueTeam.users.length) || 0)
    );
  }, [league, leagueTeam]);

  const renderCardType = useMemo(() => {
    if (!actingUser || !actingUser.user_id) {
      //TODO implement this later
      return null;
    }
    if (leagueTeam && leagueTeam.team_id) {
      if (playersNeeded > 0) {
        return 'invite';
      }
      return 'play';
    }

    return 'team';
  }, [leagueTeam, playersNeeded, actingUser]);

  const renderCard = useMemo(() => {
    switch (renderCardType) {
      case 'invite':
        return (
          <InviteTeamActionCard
            cardRef={cardRef}
            track={track}
            leagueId={leagueId}
            playersNeeded={playersNeeded}
            invite_url={leagueTeam && leagueTeam.invite_url}
          />
        );
      case 'play':
        return (
          <TeamSummaryActionCard
            cardRef={cardRef}
            track={track}
            leagueId={leagueId}
            teamId={leagueTeam.team_id}
          />
        );
      case 'team':
        return <CreateTeamActionCard cardRef={cardRef} track={track} leagueId={leagueId} />;
      default:
        return null;
    }
  }, [cardRef, leagueId, leagueTeam, playersNeeded, renderCardType, track]);

  if (renderCardType && !renderCard) {
    return null;
  }

  return (
    <>
      <div key={league.league_id} className={css.container}>
        {renderCard}
      </div>

      <Sheet noPadding open={selectedTeam} onClose={() => setSelectedTeam(null)}>
        <SheetTeam
          leagueId={leagueId}
          team={selectedTeam}
          actingUser={actingUser}
          actingTeam={actingTeam}
        />
      </Sheet>
    </>
  );
});

export default DivisionPlay;
