import React, { memo, useMemo, useCallback } from 'react';
import config from 'scripts/config';

import cx from 'classnames';

import { Button, Row, Loader } from 'bebo-ui';

import css from './download-prompt.module.scss';

import { isDesktopApp } from 'scripts/utils';

const DownloadPrompt = memo(({ inline, onCancel, canCancel, canBack, track }) => {
  const isApp = useMemo(isDesktopApp, []);
  const doTrack = useCallback(
    (...args) => {
      if (track) {
        track(...args);
      }
    },
    [track]
  );
  return (
    <div className={cx(css.downloadPrompt, inline ? css.inline : null)}>
      {isApp ? (
        inline ? null : (
          <>
            <Row>
              <h4 style={{ lineHeight: '25px' }}>Bebo is still starting up</h4>
              <Loader size={25} style={{ marginLeft: 'auto', marginRight: 0 }} />
            </Row>
            <p>Please hold on while we get things going.</p>
            <p>
              This shouldn't take longer than <b>10-15 seconds</b>.
            </p>
            <p>
              If this message does not disappear in 10-15 seconds please let us know in Discord.
            </p>
            {onCancel && (
              <Button fluid danger={!canBack} secondary={canBack} onClick={onCancel}>
                {canBack ? 'Go Back' : canCancel ? 'Cancel Match' : 'End Match'}
              </Button>
            )}
          </>
        )
      ) : (
        <>
          {inline ? <h5>Download the Bebo Client</h5> : <h4>You Need The Score Tracker!</h4>}
          {!inline && <p>To play in the league, you need the Bebo PC app.</p>}
          {!inline && <p>It automatically tracks your games, kills & wins.</p>}
          <Button
            primary
            style={{ margin: '10px auto', display: 'block' }}
            link={`${config.WWW_URL}/download`}
            external
            onClick={() => doTrack('download-prompt', { inline })}
          >
            Download Now
          </Button>

          {!inline && (
            <p style={{ textAlign: 'center' }}>
              <i>Already have the app? Make sure it's open!</i>
            </p>
          )}

          {onCancel && (
            <Button fluid danger={!canBack} secondary={canBack} onClick={onCancel}>
              {canBack ? 'Go Back' : canCancel ? 'Cancel Match' : 'End Match'}
            </Button>
          )}
        </>
      )}
    </div>
  );
});

export default DownloadPrompt;
