import React from 'react';
import { storiesOf } from '@storybook/react';
import centered from '@storybook/addon-centered';

import Ftux from './index.js';

// data
const props = {
  title: '',
  subtitle: '',
  buttonText: 'Next',
  currentStep: 1
};

// Story

storiesOf('ftux', module)
  .addDecorator(centered)
  .add('Step 1', () => (
    <div>
      <Ftux title={'Season Zero'} currentStep={0} buttonText={'Next'} />
    </div>
  ))
  .add('Step 2', () => (
    <div>
      <Ftux title={'How does a match work?'} currentStep={1} buttonText={'Next'} />
    </div>
  ))
  .add('Step 3', () => (
    <div>
      <Ftux
        title={'Rankings'}
        subtitle={'League standings update live on Bebo.com'}
        currentStep={2}
        buttonText={'Next'}
      />
    </div>
  ))
  .add('Step 4', () => (
    <div>
      <Ftux title={'Rules & Reqs.'} currentStep={3} buttonText={'Next'} />
    </div>
  ))
  .add('Step 5', () => (
    <div>
      <Ftux
        title={'Need Help?'}
        subtitle={'Use the #help channel in Discord and our team will assist you'}
        currentStep={4}
        buttonText={'Next'}
      />
    </div>
  ))
  .add('Step 6', () => (
    <div>
      <Ftux
        title={'You got Bebo first'}
        subtitle={'Alpha. Beta. Early Access. Pre-Launch. Not perfect. Brand spanking new.'}
        currentStep={5}
        buttonText={'Done'}
      />
    </div>
  ));
