import React, { memo } from 'react';
import cx from 'classnames';
import css from './ftux.module.scss';

import { Button } from 'bebo-ui';

const Ftux = memo(({ title, subtitle, buttonText = 'Next', Component, onNext, noButton }) => {
  return (
    <div className={cx(css.container)}>
      <div className={css.ftux}>
        <div className={css.ftuxHeader}>
          <h1>{title}</h1>
          {subtitle && <p>{subtitle}</p>}
        </div>

        <div className={css.ftuxContent}>
          <Component onNext={onNext} />
        </div>

        {!noButton && (
          <div className={css.ftuxAction}>
            <Button primary style={{ width: 280 }} onClick={onNext}>
              {buttonText}
            </Button>
          </div>
        )}
      </div>
    </div>
  );
});

export default Ftux;
