import React, { memo, useState } from 'react';

import { Input, Column, Button } from 'bebo-ui';

import containerCss from '../ftux.module.scss';

import UserController from 'controllers/user';

import useActingUser from 'hooks/useActingUser';
import useSnack from 'hooks/useSnack';

const FtuxStep0 = memo(({ onNext }) => {
  const actingUser = useActingUser();
  const { onSuccess, onError } = useSnack();
  const [isSaving, setIsSaving] = useState(false);

  const [username, setUserName] = useState(actingUser.username);

  const saveNewUsername = () => {
    if (!username) {
      return onError({ text: 'Please enter a username.' });
    }
    setIsSaving(true);

    const payload = {};

    if (username !== actingUser.username) {
      payload.username = username;
    }

    return UserController.update(payload)
      .then(response => {
        onSuccess({ text: `Welcome, ${username}!`, autoHide: 2500 });
        setTimeout(() => {
          setIsSaving(false);
          onNext();
        }, 1500);
      })
      .catch(err => {
        setIsSaving(false);
        console.error('*** user update err', err);
        onError(err);
      });
  };

  return (
    <Column>
      <Column>
        <Input
          fluid
          autoFocus
          value={username}
          placeholder={'Your Fierce Username Here'}
          onChange={setUserName}
          onSubmit={saveNewUsername}
        />
      </Column>
      <Column className={containerCss.ftuxAction}>
        <Button
          loading={isSaving}
          disabled={!username}
          style={{ width: 280 }}
          primary
          onClick={saveNewUsername}
        >
          Next
        </Button>
      </Column>
    </Column>
  );
});

export default FtuxStep0;
