import React, { memo } from 'react';
import cx from 'classnames';
import { Link } from '@reach/router';
import posed from 'react-pose';

import './HeaderMenu.module.scss';

const Menu = posed.nav({
  open: { y: '0%', staggerChildren: 100 },
  closed: { y: '-100%', staggerChildren: 100, staggerDirection: -1, afterChildren: true }
});

const NavItem = posed.li({
  open: { opacity: 1, applyAtStart: { pointerEvents: 'all', display: 'inherit' } },
  closed: { opacity: 0, applyAtEnd: { pointerEvents: 'none', display: 'none' } }
});

export default memo(function HeaderMenu({ links, onClick, pose, background }) {
  const classes = cx('header-menu');
  return (
    <Menu pose={pose} className={classes}>
      <ul className={classes}>
        {links.map((link, i) => (
          <NavItem key={`link_${i}`}>
            <HeaderMenuItem
              {...link}
              style={{ background }}
              onClick={() => {
                onClick();
                if (link.onClick) {
                  link.onClick();
                }
              }}
            />
          </NavItem>
        ))}
      </ul>
    </Menu>
  );
});

const HeaderMenuItem = memo(({ link, external, relative, text, onClick, danger, ...rest }) => {
  if (onClick && !link) {
    return (
      <span className={cx('header-menu__item', { danger })} onClick={onClick} {...rest}>
        {text}
      </span>
    );
  }
  if (relative) {
    return (
      <a className={cx('header-menu__item', { danger })} href={`#${relative}`} {...rest}>
        {text}
      </a>
    );
  }
  if (external) {
    return (
      <a className={cx('header-menu__item', { danger })} href={link} {...rest}>
        {text}
      </a>
    );
  }
  return (
    <Link className={cx('header-menu__item', { danger })} to={link} {...rest}>
      {text}
    </Link>
  );
});
