import React, { PureComponent } from 'react';
import cx from 'classnames';
import './HeaderMenuButton.module.scss';

export default class HeaderMenbuButton extends PureComponent {
  render() {
    const { active, onClick } = this.props;
    const classes = cx('header-menu-btn', 'hamburger', 'hamburger--spin', { 'is-active': active });
    return (
      <button className={classes} type="button" onClick={onClick}>
        <span className="hamburger-box">
          <span className="hamburger-inner" />
        </span>
      </button>
    );
  }
}
