import React, { memo } from 'react';
import { Link } from '@reach/router';

import css from './HeaderRightNav.module.scss';

const HeaderRightNav = memo(({ children }) => {
  return <ul className="web-header__right-nav">{children ? children : <HeaderButton />}</ul>;
});

export default HeaderRightNav;

const HeaderButton = memo(() => {
  return (
    <div className="web-header__right-nav__buttons">
      <Link className={css.link} to={'/how-to'}>
        How It Works
      </Link>
    </div>
  );
});
