import React, { memo, useState } from 'react';
import cx from 'classnames';

import { useMedia } from 'the-platform';

// import moment from 'moment';
import './Header.module.scss';

import HeaderRightNav from './HeaderRightNav';
import HeaderLogo from './HeaderLogo';

// Mobile
import HeaderMenuButton from './HeaderMenuButton';
import HeaderMenu from './HeaderMenu';

import useActingUser from 'hooks/useActingUser';
import useStorage from 'hooks/useStorage';

import UserController from 'controllers/user';

const Header = memo(
  ({ sticky, transparent, background, logo, rightNav, tournament, openModal, inverse }) => {
    const mobile = !useMedia({ minWidth: 1024 }, window.innerWidth > 1024);
    const [showMobileMenu, setShowMobileMenu] = useState(false);
    const actingUser = useActingUser();
    const [wasLoggedIn] = useStorage('wasLoggedIn', false);

    const style = { background };

    const links = [
      { text: 'Download', link: '/download' },
      { text: 'Merch', link: 'http://dbh.la/bebo', external: true, target: '_blank' },
      // { text: 'FAQ', external: true, target: '_blank', link: 'https://help.bebo.com' },
      {
        text: actingUser ? 'Logout' : wasLoggedIn ? 'Login' : 'Sign Up',
        onClick: () => {
          if (actingUser) {
            UserController.logout();
          }
        },
        link: actingUser ? null : wasLoggedIn ? '/login' : '/signup',
        danger: Boolean(actingUser)
      }
    ];

    const classes = cx(
      'web-header',
      { mobile },
      { sticky },
      { transparent },
      { tournament },
      { inverse }
    );

    if (mobile) {
      return (
        <header className={classes} style={style}>
          <div className="web-header__inner">
            <HeaderMenuButton
              active={showMobileMenu}
              onClick={() => setShowMobileMenu(!showMobileMenu)}
            />
            <HeaderLogo tournament={tournament} mobile>
              {logo}
            </HeaderLogo>
          </div>
          <HeaderMenu
            background={background}
            pose={showMobileMenu ? 'open' : 'closed'}
            links={links}
            onClick={() => setShowMobileMenu(!showMobileMenu)}
          />
        </header>
      );
    }

    return (
      <header className={classes} style={style}>
        <div className="web-header__inner">
          <HeaderLogo tournament={tournament}>{logo}</HeaderLogo>
          <HeaderRightNav openModal={openModal}>{rightNav}</HeaderRightNav>
        </div>
      </header>
    );
  }
);

export default Header;

// const TournamentInfo = ({ tournament }) => {
//   const { name, imageUrl, startDttm } = tournament;
//   return (
//     <div className="tournament-nav--title--container">
//       <img className="tournament-nav--title--logo" alt={name} src={imageUrl} />
//       <div className="tournament-nav--title--details">
//         <span className="tournament-nav--title">{name}</span>
//         <span className="tournament-nav--date">{moment(startDttm).calendar()}</span>
//       </div>
//     </div>
//   );
// };
