import React, { memo } from 'react';
import cx from 'classnames';

import css from './invite.module.scss';

import { Avatar, Column } from 'bebo-ui';

import Header from 'components/header';
import Footer from 'components/footer';
import SignupButton from 'components/signup-button';

import useTrack from 'hooks/useTrack';
import useActingUser from 'hooks/useActingUser';

import LoginFlow from 'components/login';

const Invite = memo(({ league, team, playerName, playerBio, playerImg }) => {
  const actingUser = useActingUser();
  const { name, image_url, description } = league;

  const track = useTrack('signup_funnel', 'invite_landing', { league, team, playerName });

  return (
    <Column style={{ height: '100%' }}>
      <Header inverse background="#000" />
      <div className={cx(css.container)}>
        <div className={css.invite}>
          <div className={css.inviteContent}>
            <div className={css.inviteText}>
              {image_url && (
                <Avatar ring={5} user={{ username: name, image_url: image_url }} size={100} />
              )}
              <h2>{name}</h2>
              {description && <h4>{description}</h4>}
              {team != null && (
                <p>
                  You've been invited to team <span className={css.link}>{team}</span>
                  {playerName ? (
                    <>
                      {' '}
                      by <span className={css.link}>{playerName}</span>.
                    </>
                  ) : (
                    '.'
                  )}
                </p>
              )}
              {playerName != null && team == null && (
                <p>You've been invited to join this league by:</p>
              )}
              {playerName == null && <p>You've been invited to join this league.</p>}
            </div>

            {playerName != null && (
              <div className={css.player}>
                <Avatar user={{ username: playerName, image_url: playerImg }} size={60} />
                <div className={css.playerInfo}>
                  <h4>{playerName}</h4>
                  {playerBio && <p>{playerBio}</p>}
                </div>
              </div>
            )}

            {actingUser && actingUser.username ? (
              <SignupButton
                primary
                fluid
                style={{ width: 280 }}
                className={css.inviteButton}
                from="invite"
                onClick={() => track('click')}
              >
                {playerName ? 'Accept Invite' : 'Join League'}
              </SignupButton>
            ) : (
              <LoginFlow isSignup={true} track={track} isEmbedded />
            )}
          </div>
        </div>
      </div>
      <Footer inverse background="#000" />
    </Column>
  );
});

export default Invite;
