import React, { memo } from 'react';
import css from './leaderboard.module.scss';

import LeaderboardItem from './leaderboard-item';

const Leaderboard = memo(({ standings = [], actingTeam, onSelectTeam, isSolo, activeTeamId }) => {
  return (
    <div className={css.container}>
      {/* <LeaderboardHeader /> */}
      {standings.map((standing, index) => {
        const { team, ...rest } = standing;
        return (
          <LeaderboardItem
            onClick={onSelectTeam}
            key={team.team_id}
            isMe={team.team_id === (actingTeam && actingTeam.team_id)}
            topTeam={index < 3 && index}
            team={team}
            isActive={activeTeamId === team.team_id}
            {...rest}
          />
        );
      })}
    </div>
  );
});

// const LeaderboardHeader = memo(() => {
//   return (
//     <div className={css.header}>
//       <label style={{ width: 30 }} className={css.headerLabel}>
//         #
//       </label>
//       <label className={css.headerLabel}>Team</label>
//       <label className={css.headerLabel}>Standing</label>
//     </div>
//   );
// });

export default Leaderboard;
