import React from 'react';
import { storiesOf } from '@storybook/react';
import centered from '@storybook/addon-centered';
import Leaderboard from './index.js';

// data
const generateStandingData = entries => {
  const leaderboard = [];
  for (let i = 0; i < entries; i++) {
    leaderboard.push({
      score: Math.floor(Math.random() * 300) + 1,
      user: { username: `user-${i}`, user_id: i }
    });
  }
  const x = leaderboard
    .sort((a, b) => b.score - a.score)
    .map((t, i) => {
      return { ...t, rank: i + 1 };
    });
  return x;
};

const data = generateStandingData(40);

// Story

storiesOf('Leaderboard', module)
  .addDecorator(centered)
  .add('default', () => (
    <div style={{ width: 400, height: '90vh', position: 'relative' }}>
      <Leaderboard standings={data} myUserId={data[5].user.user_id} />
    </div>
  ));
