import React, { memo } from 'react';

import css from './league-sidebar.module.scss';

import { Column, NavLink } from 'bebo-ui';

const LeaguePicker = memo(({ leagues = [], large = false }) => {
  return (
    <Column className={css.container}>
      {leagues.map(league => {
        const link = `/app/league/${league.league_id}`;

        return (
          <NavLink
            closeNav
            className={css.navLink}
            activeClassName={css.navLinkActive}
            key={league.league_id}
            to={link}
          >
            <img src={league.image_url} alt={league.name} />
            {large && <h4>{league.name}</h4>}
          </NavLink>
        );
      })}
    </Column>
  );
});

export default LeaguePicker;
