import React, { memo } from 'react';
import css from './lobby-header.module.scss';

import imgPattern from './assets/pattern.svg';
import imgGameModeArt from './assets/duo.png';

const getGameMode = (modeName, isTournamentMatch, matchRounds) => {
  const name = isTournamentMatch ? 'Tournament Match' : 'League Match';
  const desc = `Play ${matchRounds} ${modeName} matches. The team with the highest total score ${
    isTournamentMatch ? 'advances to the next round' : 'wins'
  }.`;

  const scoring = [
    {
      label: 'Elimination',
      value: '1'
    },
    {
      label: 'Victory',
      value: '10'
    }
  ];

  return { name, desc, scoring };
};

const LobbyHeader = memo(({ isTournamentMatch, league, modeName, matchRounds }) => {
  const gameMode = getGameMode(modeName, isTournamentMatch, matchRounds);

  return (
    <div className={css.lobbyHeader}>
      <div className={css.matchMode}>
        <span className={css.matchModeGetReady}>{league.name}</span>
        <span className={css.matchModeName}>{gameMode.name}</span>
        <span className={css.matchModeDesc}>{gameMode.desc}</span>
        <div className={css.matchModeScoring}>
          {gameMode.scoring.map(({ label, value }, i) => (
            <div key={`item_${i}`} className={css.matchModeScore}>
              <span className={css.matchModeScoreLabel}>{label}</span>
              <span className={css.matchModeScoreValue}>{value} pts</span>
            </div>
          ))}
        </div>
      </div>
      <div className={css.background}>
        <div className={css.backgroundGradient} />
        <img className={css.backgroundModeArt} alt="" src={imgGameModeArt} />
        <LeagueBackground image_url={league.image_url} />
        <img className={css.backgroundPattern} alt="" src={imgPattern} />
      </div>
    </div>
  );
});

const LeagueBackground = ({ image_url }) => {
  return (
    <div className={css.leagueBackground}>
      <div className={css.leagueBackgroundGradient} />
      <img className={css.leagueBackgroundImage} alt="" src={image_url} />
    </div>
  );
};

export default LobbyHeader;
