import React, { memo } from 'react';
import cx from 'classnames';
import { Avatar, Icon } from 'bebo-ui';
import Linkify from 'react-linkify';

import css from './lobby-team.module.scss';

const generateStatus = userState => {
  const { ready, bran } = userState;
  // probs check more here
  if (ready && bran) {
    return 'ready';
  }
  if (ready) {
    return 'notTracking';
  }
  return 'notReady';
};

const LobbyTeam = memo(({ actingTeam, userStates }) => {
  const { users } = actingTeam;

  const usersReady = Object.values(userStates).filter(state => state.ready && state.bran).length;

  return (
    <div className={css.team}>
      <TeamStatus
        text="Match will start as soon as everyone in your team is ready and tracking."
        icon="info"
        usersReady={usersReady}
        teamSize={4}
      />
      <ul className={css.membersList}>
        {users.map(user => (
          <LobbyTeamMember
            key={user.user_id}
            user={user}
            status={generateStatus(userStates[user.user_id])}
          />
        ))}
      </ul>
    </div>
  );
});

export default LobbyTeam;

const LobbyTeamMember = memo(({ user, status }) => {
  const statusMap = {
    ready: 'Ready',
    notReady: 'Not Ready',
    notTracking: 'Not Tracking'
  };

  return (
    <li className={css.member}>
      <Avatar size={45} className={css.memberAvatar} user={user} />
      <span className={css.memberMeta}>
        <span className={css.memberName}>{user.username}</span>
        {user.bio ? (
          <span className={css.memberBio}>
            <Linkify
              properties={{
                target: '_blank'
              }}
            >
              {user.bio}
            </Linkify>
          </span>
        ) : (
          <span className={css.memberBio}>I haven't filled out my profile yet</span>
        )}
      </span>
      <span className={cx(css.memberState, css[status])}>{statusMap[status]}</span>
    </li>
  );
});

const TeamStatus = memo(({ icon, text }) => {
  return (
    <div className={css.status}>
      <Icon size={40} icon={icon} className={css.statusIcon} />
      <span className={css.statusText}>{text}</span>
    </div>
  );
});
